/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings;

import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CPlusPlusFileType;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

final class CommandLineHelper {
    private static final String PREINCLUDE = "--preinclude=";
    private static final String SYS_INCLUDE = "--sys_include=";
    private static final boolean isWindows = Platform.isWindows();

    CommandLineHelper() {
    }

    static List<String> processCommandLine(TFile baseDir, String cmd, boolean appendSourceFile) {
        List items = StringUtility.parseQuotedLineIntoWords((String)cmd.substring(cmd.indexOf(32) + 1).trim());
        return CommandLineHelper.filterAndNormalizeItems(baseDir, items, appendSourceFile);
    }

    private static String normalizeFileNameSeparators(String fileName) {
        if (isWindows) {
            return fileName.replace('/', '\\');
        }
        return fileName.replace('\\', '/');
    }

    static List<String> filterAndNormalizeItems(TFile baseDir, List<String> items, boolean appendSourceFile) {
        ArrayList<String> filteredList = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean addNext = false;
        int i = 0;
        String sourceFileName = null;
        for (String string : items) {
            String ext;
            if (string.equals("--compile_args")) {
                return CommandLineHelper.processCommandLine(baseDir, "cmd " + items.get(i + 1), appendSourceFile);
            }
            if (addNext) {
                sb.append(CommandLineHelper.normalizeFileNameSeparators(string));
                filteredList.add(sb.toString());
                sb.setLength(0);
                addNext = false;
            } else if (string.startsWith("-D")) {
                filteredList.add(string);
            } else if (string.equals("-I") || string.equals("--include") || string.equals("-iquote")) {
                String string2 = "-I";
                sb.append(string2);
                addNext = true;
            } else if (string.equals("-F") && Platform.isMac()) {
                String string3 = "-F";
                sb.append(string3);
                addNext = true;
            } else if (string.startsWith("-I")) {
                filteredList.add(string);
                filteredList.add("-I" + CommandLineHelper.normalizeFileNameSeparators(string.substring(2)));
            } else if (string.equals("-isystem")) {
                String string4 = SYS_INCLUDE;
                sb.append(string4);
                addNext = true;
            } else if (string.startsWith("-external:I")) {
                if (string.equals("-external:I")) {
                    String string5 = SYS_INCLUDE;
                    sb.append(string5);
                    addNext = true;
                } else {
                    filteredList.add(SYS_INCLUDE + CommandLineHelper.normalizeFileNameSeparators(string.substring(11)));
                }
            } else if (string.startsWith("-isystem=")) {
                filteredList.add(SYS_INCLUDE + CommandLineHelper.normalizeFileNameSeparators(string.substring(9)));
            } else if (string.equals("-include")) {
                String string6 = PREINCLUDE;
                sb.append(string6);
                addNext = true;
            } else if (string.startsWith("--include=")) {
                String string7 = "-I" + CommandLineHelper.normalizeFileNameSeparators(string.substring(10));
                filteredList.add(string7);
            } else if (string.startsWith("-iquote=")) {
                String string8 = "-I" + CommandLineHelper.normalizeFileNameSeparators(string.substring(8));
                filteredList.add(string8);
            } else if (string.startsWith("-include=")) {
                String string9 = PREINCLUDE + CommandLineHelper.normalizeFileNameSeparators(string.substring(9));
                filteredList.add(string9);
            } else if (string.contains("c++11")) {
                filteredList.add("--c++11");
            } else if (string.contains("c++14")) {
                filteredList.add("--c++14");
            } else if (string.contains("c++17")) {
                filteredList.add("--c++17");
            } else if (string.contains("c++20")) {
                filteredList.add("--c++20");
            } else if (string.startsWith("-F") && Platform.isMac()) {
                filteredList.add(string);
            } else if (appendSourceFile && !string.startsWith("-") && (CPlusPlusFileType.CPP_SOURCE.hasExtension(ext = FileUtility.getExtension((String)string)) || CPlusPlusFileType.C_SOURCE.hasExtension(ext))) {
                sourceFileName = CommandLineHelper.normalizeFileNameSeparators(string);
            }
            ++i;
        }
        i = 0;
        for (String string : filteredList) {
            if (string.startsWith("-I")) {
                path = string.substring(2).trim();
                filteredList.set(i, "-I" + CommandLineHelper.filterPath(baseDir, path));
            } else if (string.startsWith(PREINCLUDE)) {
                path = string.substring(PREINCLUDE.length()).trim();
                filteredList.set(i, PREINCLUDE + CommandLineHelper.filterPath(baseDir, path));
            } else if (string.startsWith(SYS_INCLUDE)) {
                path = string.substring(SYS_INCLUDE.length()).trim();
                filteredList.set(i, SYS_INCLUDE + CommandLineHelper.filterPath(baseDir, path));
            }
            ++i;
        }
        if (appendSourceFile) {
            if (sourceFileName == null) {
                return null;
            }
            filteredList.add(sourceFileName);
        }
        return filteredList;
    }

    private static String filterPath(TFile baseDir, String path) {
        TFile filePath = new TFile(path);
        if (!filePath.isAbsolute()) {
            TFile fullPath = new TFile((File)baseDir, path);
            if (fullPath.exists()) {
                return fullPath.getNormalizedAbsolutePath();
            }
            return path;
        }
        return filePath.getNormalizedAbsolutePath();
    }
}

