/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings;

import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.SourceBeanFactory;
import de.schlichtherle.truezip.file.TFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaptureFileData {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaptureFileData.class);
    private final TFile m_captureFile;

    public CaptureFileData(TFile captureFile) {
        assert (captureFile != null) : "Parameter 'captureFile' of method 'CaptureFileData' must not be null";
        this.m_captureFile = captureFile;
    }

    private TFile getBaseDirectory() {
        return this.m_captureFile.getParentFile();
    }

    private boolean isAbsolute(TFile file) {
        if (file.isAbsolute()) {
            return true;
        }
        if (Platform.isWindows()) {
            String path = file.getPath();
            return path.startsWith("\\") || path.startsWith("/");
        }
        return false;
    }

    public boolean readData(OperationResult result, SourceBeanFactory factory) {
        int entries = 0;
        try {
            TFile baseDir = this.getBaseDirectory();
            Throwable throwable = null;
            Object var6_9 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader((File)this.m_captureFile));){
                String line;
                while ((line = reader.readLine()) != null) {
                    String compileCommand;
                    String[] commands = line.split("&&");
                    TFile dir = baseDir;
                    if (commands.length > 1) {
                        String firstCommand = commands[0].trim();
                        if (firstCommand.startsWith("cd ")) {
                            String dirName = firstCommand.substring(3).trim();
                            TFile dirFile = new TFile(dirName);
                            dir = this.isAbsolute(dirFile) ? dirFile : new TFile((File)baseDir, dirName);
                        }
                        compileCommand = commands[commands.length - 1];
                    } else {
                        compileCommand = commands[0];
                    }
                    List parts = StringUtility.parseQuotedLineIntoWords((String)compileCommand.trim());
                    if (!parts.contains("-c")) continue;
                    parts.add(0, "capture_cwd=" + dir.getNormalizedAbsolutePath());
                    if (!factory.processCommand(this.m_captureFile.getParentFile(), parts)) continue;
                    ++entries;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            String msg = String.format("Cannot read capture file '%s'", this.m_captureFile.getPath());
            LOGGER.error(msg, (Throwable)e);
            result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, msg, new Object[0]);
            return false;
        }
        return entries != 0;
    }
}

