/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.settings.ModuleSettings;
import com.hello2morrow.sonargraph.core.model.system.settings.RootDirectorySettings;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.file.DirectoryScanner;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.CaptureFileData;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.CppExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.SourceBeanFactory;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.CppCauses;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppRootDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CPlusPlusSystemSettings;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CapturingDataFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CompilerOptions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.DirectoryBean;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ExcludedDirectoryNode;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ICaptureExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.SourceFileNode;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusCaptureModule;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusModule;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public final class CaptureExtension
extends CppExtension
implements ICaptureExtension {
    public static final String RAW_CAPTURE_FILE_NAME = "h2m-capture.txt";
    public static final String CAPTURE_FILE_NAME = "h2m-capture-rel.txt";

    private void reportNoFilesError(OperationResult result) {
        if (result.isSuccess()) {
            result.addError((OperationResult.IMessageCause)CppCauses.COULD_NOT_FIND_ANY_CAPTURING_FILES, "Could not find any files named 'h2m-capture.txt'.", new Object[0]);
        }
    }

    @Override
    public List<DirectoryBean> findAndReadCapturingFiles(TFile rootDir, OperationResult result) {
        DirectoryScanner scanner = new DirectoryScanner(Collections.emptyList(), false);
        FileConsumer consumer = new FileConsumer();
        scanner.scan(rootDir, (DirectoryScanner.IFileConsumer)consumer);
        SourceBeanFactory factory = new SourceBeanFactory();
        for (TFile file : consumer.m_files) {
            CaptureFileData data = new CaptureFileData(file);
            data.readData(result, factory);
        }
        if (factory.isEmpty()) {
            this.reportNoFilesError(result);
            return Collections.emptyList();
        }
        return factory.getRootDirectories();
    }

    @Override
    public List<DirectoryBean> prepareToAddCapturingModules(SoftwareSystem system, OperationResult result) {
        List<DirectoryBean> dirs = this.findAndReadCapturingFiles(system.getDirectoryFile(), result);
        return this.prepareToAddModules(dirs, system);
    }

    private boolean canUpdateCapturingData(SoftwareSystem system) {
        assert (system != null) : "Parameter 'system' of method 'canUpdateCapturingData' must not be null";
        return !((Workspace)system.getUniqueExistingChild(Workspace.class)).getChildren(CPlusPlusCaptureModule.class).isEmpty();
    }

    @Override
    public boolean canUpdateCapturingData(ISoftwareSystemProvider provider) {
        assert (provider != null) : "Parameter 'provider' of method 'canUpdateCapturingData' must not be null";
        return provider.hasSoftwareSystem() && this.canUpdateCapturingData(provider.getSoftwareSystem());
    }

    @Override
    public void updateCapturingData(SoftwareSystem system, OperationResult result) {
        assert (system != null) : "Parameter 'system' of method 'updateCapturingData' must not be null";
        assert (result != null) : "Parameter 'result' of method 'updateCapturingData' must not be null";
        assert (this.canUpdateCapturingData(system));
        List<DirectoryBean> dirs = this.findAndReadCapturingFiles(system.getDirectoryFile(), result);
        if (dirs.isEmpty()) {
            return;
        }
        HashMap<List<String>, CompilerOptions> optionMap = new HashMap<List<String>, CompilerOptions>();
        Workspace ws = (Workspace)system.getUniqueExistingChild(Workspace.class);
        CPlusPlusSystemSettings settings = (CPlusPlusSystemSettings)((Object)ws.getUniqueChild(CPlusPlusSystemSettings.class));
        for (Module module : ws.getChildren(CPlusPlusCaptureModule.class, true)) {
            block1: for (CppRootDirectoryPath root : module.getChildren(CppRootDirectoryPath.class)) {
                List<String> excludedDirs;
                RootDirectorySettings rootDirSettings = (RootDirectorySettings)root.getFirstChild(RootDirectorySettings.class);
                system.setNeedsSave(true);
                if (rootDirSettings == null) {
                    rootDirSettings = new RootDirectorySettings((NamedElement)root);
                    root.addChild((NamedElement)rootDirSettings);
                    excludedDirs = Collections.emptyList();
                } else {
                    excludedDirs = rootDirSettings.getChildren(ExcludedDirectoryNode.class).stream().map(n -> n.getShortName()).collect(Collectors.toList());
                    rootDirSettings.removeChildren(new Class[]{SourceFileNode.class});
                }
                for (DirectoryBean beanRoot : dirs) {
                    DirectoryBean rootBean = beanRoot.markAndLockRoot(root.getFile(), excludedDirs);
                    if (rootBean == null) continue;
                    this.createSourceFileNodes(settings, rootDirSettings, optionMap, rootBean);
                    continue block1;
                }
            }
        }
    }

    public static void moveElements(CPlusPlusModule sourceModule, CPlusPlusModule targetModule) {
        ModuleSettings settings = (ModuleSettings)sourceModule.getUniqueChild(ModuleSettings.class);
        ModuleSettings targetSettings = (ModuleSettings)targetModule.getUniqueChild(ModuleSettings.class);
        if (targetSettings != null) {
            targetSettings.remove();
            assert (settings != null);
            settings.changeParent((NamedElement)targetModule, true);
        }
        CaptureExtension.moveRootSettings(sourceModule, targetModule);
    }

    private static class FileConsumer
    implements DirectoryScanner.IFileConsumer {
        private final List<TFile> m_files = new ArrayList<TFile>();

        private FileConsumer() {
        }

        public IFileType accepts(TFile file) {
            if (file.getName().equals(CaptureExtension.RAW_CAPTURE_FILE_NAME)) {
                this.m_files.add(file);
                return new CapturingDataFile.CapturingFileType();
            }
            return null;
        }

        public void consume(TFile rootPathBeingScanned, TFile file, IFileType fileType) {
        }

        public boolean continueScanning(TFile rootPathBeingScanned, TFile path) {
            return !path.getName().startsWith(".");
        }
    }
}

