/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser;

import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.CodeAnalyzer;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.CppSignatureEncoder;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.ElementProcessor;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.ICompilationUnitContext;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.IElementProcessor;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.parser.EDG;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppElement;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppElementType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppElementWithSignature;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppFlags;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppStructuredType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppDependencyType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class VariableProcessor
extends ElementProcessor {
    private final EDG.Variable m_edgVariable;
    private final List<CppElementWithSignature> m_declarations = new ArrayList<CppElementWithSignature>();
    private final Map<CppElementWithSignature, EDG.SourcePosition> m_declarationPositionMap = new HashMap<CppElementWithSignature, EDG.SourcePosition>();
    private CppElementWithSignature m_definition = null;
    private long m_lowestSeq;

    public VariableProcessor(ICompilationUnitContext context, IElementProcessor parentProcessor, EDG.Variable v) {
        super(context, parentProcessor);
        this.m_edgVariable = v;
    }

    @Override
    public boolean initElement() {
        EDG.SourceCorrespondence sc;
        String name;
        if (this.m_edgVariable.isTemplateVariable()) {
            EDG.Scope parentScope = this.m_edgVariable.sourceCorresp().parentScope();
            if (parentScope instanceof EDG.ScopeAssocType) {
                EDG.ScopeAssocType typeScope = (EDG.ScopeAssocType)parentScope;
                EDG.Type type = typeScope.assocType();
                assert (type instanceof EDG.TypeClassStructUnion);
                EDG.TypeClassStructUnion cls = (EDG.TypeClassStructUnion)type;
                if (!cls.isPrototypeInstantiation()) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if ((name = this.getElementName(sc = this.m_edgVariable.sourceCorresp())).equals("<error>")) {
            return false;
        }
        EDG.SourcePosition origSp = sc.declPosition();
        this.m_lowestSeq = origSp.seq();
        Collection<EDG.SourcePosition> positions = this.getContext().getSecondaryPositions(this.m_edgVariable, origSp);
        EDG.Position pos = origSp.getPosition();
        CppElement parent = this.getParentProcessor().getParentFor(pos);
        int accessSpecifier = sc.access();
        EDG.StorageClass storageClass = this.m_edgVariable.storageClass();
        if (this.m_edgVariable.isInline() && !(parent instanceof CppStructuredType)) {
            return false;
        }
        CppElementWithSignature element = new CppElementWithSignature(parent, CppElementType.VAR, name, pos.getLineNumber());
        element.setNamespace(this.getParentProcessor().getNamespace(), this.getParentProcessor().isAnonymousNamespace());
        if (storageClass != EDG.StorageClass.SC_EXTERN || this.m_edgVariable.isMemberConstant()) {
            this.m_definition = element;
            this.m_definition.addFlag(CppFlags.DEFINITION);
        } else {
            element.addFlag(CppFlags.DECLARATION);
            this.m_declarations.add(element);
        }
        parent.addChild(element);
        switch (accessSpecifier) {
            case 0: {
                element.addFlag(CppFlags.PUBLIC);
                break;
            }
            case 1: {
                element.addFlag(CppFlags.PROTECTED);
                break;
            }
            case 2: {
                element.addFlag(CppFlags.PRIVATE);
            }
        }
        this.m_declarationPositionMap.put(element, origSp);
        this.getContext().mapElement(this.m_edgVariable, element);
        this.getContext().mapElementPosition(element, origSp);
        for (EDG.SourcePosition sp : positions) {
            EDG.Position secondaryPos = sp.getPosition();
            CppElement secondaryParent = this.getParentProcessor().getParentFor(secondaryPos);
            if (secondaryParent == parent) continue;
            long seq = sp.seq();
            if (seq < this.m_lowestSeq) {
                this.m_lowestSeq = seq;
            }
            CppElementWithSignature decl = new CppElementWithSignature(secondaryParent, CppElementType.VAR, name, secondaryPos.getLineNumber());
            decl.addFlag(CppFlags.DECLARATION);
            secondaryParent.addChild(decl);
            switch (accessSpecifier) {
                case 0: {
                    decl.addFlag(CppFlags.PUBLIC);
                    break;
                }
                case 1: {
                    decl.addFlag(CppFlags.PROTECTED);
                    break;
                }
                case 2: {
                    decl.addFlag(CppFlags.PRIVATE);
                }
            }
            this.m_declarations.add(decl);
            this.m_declarationPositionMap.put(decl, sp);
            this.getContext().addSecondaryDeclaration(element, decl);
            this.getContext().mapElementPosition(decl, sp);
        }
        if (this.m_definition != null) {
            for (CppElementWithSignature decl : this.m_declarations) {
                decl.addDependency(this.m_definition, CppDependencyType.DECLARES, pos.getLineNumber());
            }
        }
        return true;
    }

    @Override
    public void processElement() {
        if (this.m_definition != null) {
            String sig = CppSignatureEncoder.encode(this, this.m_edgVariable.type(), this.getContext(), this.m_definition, CppDependencyType.VARIABLE_TYPE, this.m_edgVariable.sourceCorresp().declPosition());
            this.m_definition.setSignature(sig);
            if (!this.m_definition.isExternal()) {
                CodeAnalyzer.analyze(this.m_definition, this.getContext(), this, this.m_edgVariable);
            }
        }
        for (CppElementWithSignature var : this.m_declarations) {
            String sig = CppSignatureEncoder.encode(this, this.m_edgVariable.type(), this.getContext(), var, CppDependencyType.VARIABLE_TYPE, this.m_declarationPositionMap.get(var));
            var.setSignature(sig);
        }
    }

    @Override
    public CppElement getElement() {
        if (this.m_declarations.size() > 0) {
            return this.m_declarations.get(0);
        }
        return this.m_definition;
    }

    @Override
    public EDG.CObject getEDGObject() {
        return this.m_edgVariable;
    }
}

