/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.command.system;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.AbstractCreateSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.CreateSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.system.CPlusPlusCommandId;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.system.CreateCompilerDefinitionCommand;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controllerinterface.settings.ICPlusPlusInstallationExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.DirectoryBean;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.ICppImportExtension;
import de.schlichtherle.truezip.file.TFile;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CreateNewSystemFromCompileCommandsCommand
extends AbstractCreateSoftwareSystemCommand {
    private final IInteraction m_interaction;

    public CreateNewSystemFromCompileCommandsCommand(ISoftwareSystemProvider provider, IInteraction interaction) {
        super(provider);
        assert (interaction != null) : "Parameter 'interation' of method 'CreateNewCmakeBasedSystemCommand' must not be null";
        this.m_interaction = interaction;
    }

    public ICommandId getId() {
        return CPlusPlusCommandId.CREATE_COMMAND_BASED_SYSTEM;
    }

    protected void internalRun(IWorkerContext workerContext) {
        OperationResult result;
        CreateSoftwareSystemCommand createSoftwareSystemCommand = new CreateSoftwareSystemCommand((ISoftwareSystemProvider)this.getController(), (AbstractCreateSoftwareSystemCommand.IInteraction)this.m_interaction);
        if (!createSoftwareSystemCommand.isEnabled().isSuccess()) {
            return;
        }
        this.runPrerequisiteCommand((Command)createSoftwareSystemCommand, workerContext);
        if (createSoftwareSystemCommand.canceled() || !this.getController().hasSoftwareSystem()) {
            return;
        }
        ImportData importData = new ImportData();
        if (!this.m_interaction.collect(importData)) {
            return;
        }
        if (importData.getSelectedCompilerDefinition() == null) {
            CreateCompilerDefinitionCommand compilerDefinitionCommand = new CreateCompilerDefinitionCommand((ISoftwareSystemProvider)this.getController(), this.m_interaction);
            this.runPrerequisiteCommand((Command)compilerDefinitionCommand, workerContext);
        } else if (!"default".equals(importData.getSelectedCompilerDefinition()) && (result = ((ICPlusPlusInstallationExtension)this.getController().getInstallation().getExtension(ICPlusPlusInstallationExtension.class)).setActiveCompilerDefinitionId(importData.getSelectedCompilerDefinition())).isFailure()) {
            this.m_interaction.processOperationResult(result);
        }
        ICppImportExtension importExtension = (ICppImportExtension)this.getController().getInstallation().getExtension(ICppImportExtension.class);
        OperationResult result2 = importExtension.createModules(workerContext, this.getController().getSoftwareSystem(), importData.getModuleNames(), importData.getCommandFile(), importData.getCCSpyDirectory(), importData.getRootsMap());
        if (!result2.isFailure()) {
            result2.addMessagesFrom(this.getController().saveSoftwareSystem(workerContext));
        }
        this.m_interaction.processModuleCreationResult(result2);
    }

    public static interface IInteraction
    extends AbstractCreateSoftwareSystemCommand.IInteraction,
    CreateCompilerDefinitionCommand.IInteraction {
        public boolean collect(ImportData var1);

        public void processModuleCreationResult(OperationResult var1);
    }

    public static final class ImportData
    implements ICommandInteractionData {
        private final Map<String, List<DirectoryBean>> m_modules = new LinkedHashMap<String, List<DirectoryBean>>();
        private TFile m_commandFile;
        private TFile m_ccspyDirectory;
        private String m_selectedCompilerDefinition;

        public void addModule(String name, List<DirectoryBean> roots) {
            this.m_modules.put(name, roots);
        }

        Collection<String> getModuleNames() {
            return this.m_modules.keySet();
        }

        Map<String, List<DirectoryBean>> getRootsMap() {
            return this.m_modules;
        }

        boolean isCCSpyProject() {
            return this.m_ccspyDirectory != null;
        }

        TFile getCommandFile() {
            return this.m_commandFile;
        }

        public void setCommandFile(TFile commandFile) {
            this.m_commandFile = commandFile;
        }

        TFile getCCSpyDirectory() {
            return this.m_ccspyDirectory;
        }

        public void setCCSpyDirectory(TFile dir) {
            this.m_ccspyDirectory = dir;
        }

        public void setSelectedCompilerDefinition(String selectedCompilerDefinition) {
            this.m_selectedCompilerDefinition = selectedCompilerDefinition;
        }

        String getSelectedCompilerDefinition() {
            return this.m_selectedCompilerDefinition;
        }
    }
}

