/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.service.impl;

import com.hello2morrow.sonargraph.core.foundation.common.base.CoreResourceProviderAdapter;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.Iso8601DateFormat;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TFileWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SonargraphEnterpriseReportUploader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SonargraphEnterpriseReportUploader.class);
    private static final String PROPS_COMMIT_ID = "commitId";
    private static final String PROPS_VERSION = "version";
    private static final String PROPS_BRANCH = "branch";
    private static final String PROPS_USE_SONARGRAPH_ID = "useSonargraphId";
    private static final String PROPS_REPORT_NAME = "reportName";
    private static final String FAILED_UPLOADS_DIR_NAME = "failedUploads";
    private static final String BRANCH_DEFAULT = "default";
    private final TFile m_failedUploadsDirectory;

    SonargraphEnterpriseReportUploader(String failedUploadDirectory) {
        this.m_failedUploadsDirectory = failedUploadDirectory == null ? SonargraphEnterpriseReportUploader.getDefaultFailedUploadDirectory() : new TFile(failedUploadDirectory);
        if (!this.m_failedUploadsDirectory.isDirectory()) {
            this.m_failedUploadsDirectory.mkdirs();
        }
    }

    static TFile getDefaultFailedUploadDirectory() {
        return new TFile((File)CoreResourceProviderAdapter.getInstance().getSonargraphUserHomeDir(), FAILED_UPLOADS_DIR_NAME);
    }

    OperationResultWithOutcome<String> uploadSonargraphXmlReportAndSnapshot(String hostUrl, TFile reportFile, TFile snapshotFile, boolean useSonargraphId, String branch, String version, String commitId, String clientKey) {
        return this.internUploadFiles(hostUrl, reportFile.getName(), reportFile, snapshotFile, useSonargraphId, branch, version, commitId, clientKey, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OperationResultWithOutcome<String> internUploadFiles(String hostUrl, String reportName, TFile reportFile, TFile snapshotFile, boolean useSonargraphId, String branch, String version, String commitId, String clientKey, boolean isResendFailedUploadOperation) {
        boolean success;
        OperationResultWithOutcome uploadResult;
        block30: {
            if (!$assertionsDisabled) {
                if (hostUrl == null) throw new AssertionError((Object)"Parameter 'hostUrl' of method 'uploadSonargraphXmlReport' must not be empty");
                if (hostUrl.length() <= 0) {
                    throw new AssertionError((Object)"Parameter 'hostUrl' of method 'uploadSonargraphXmlReport' must not be empty");
                }
            }
            assert (reportFile != null) : "Parameter 'reportFile' of method 'uploadSonargraphXmlReport' must not be null";
            if (!$assertionsDisabled) {
                if (clientKey == null) throw new AssertionError((Object)"Parameter 'clientKey' of method 'uploadSonargraphXmlReportAndSnapshot' must not be empty");
                if (clientKey.length() <= 0) {
                    throw new AssertionError((Object)"Parameter 'clientKey' of method 'uploadSonargraphXmlReportAndSnapshot' must not be empty");
                }
            }
            uploadResult = new OperationResultWithOutcome("Uploading data to Sonargraph-Enterprise");
            String serverReply = null;
            success = false;
            try {
                HttpPost post = this.createHttpPostRequest(hostUrl, reportFile, snapshotFile, useSonargraphId, branch, version, commitId, clientKey, reportName);
                Throwable throwable = null;
                Object var16_20 = null;
                try {
                    CloseableHttpClient client = HttpClients.createDefault();
                    try {
                        block29: {
                            try (CloseableHttpResponse response = client.execute((HttpUriRequest)post);){
                                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                                response.getEntity().writeTo((OutputStream)outputStream);
                                serverReply = outputStream.toString();
                                int statusCode = response.getStatusLine().getStatusCode();
                                if (statusCode == 200) {
                                    success = true;
                                    String info = String.format("Uploaded '%s' successfully to '%s': %s", reportName, hostUrl, serverReply);
                                    LOGGER.info(info);
                                    uploadResult.setOutcome((Object)info);
                                    break block29;
                                }
                                if (statusCode == 409) {
                                    success = true;
                                    String warning = String.format("Upload '%s' not processed by '%s': %s", reportName, hostUrl, serverReply);
                                    uploadResult.setOutcome((Object)warning);
                                    uploadResult.addWarning((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_UPLOAD, warning, new Object[0]);
                                } else {
                                    String errorMessage = String.format("Failed to upload '%s' to '%s': %s", reportName, hostUrl, serverReply);
                                    uploadResult.setOutcome((Object)errorMessage);
                                    uploadResult.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_UPLOAD, errorMessage, new Object[0]);
                                }
                            }
                        }
                        if (client == null) break block30;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (client == null) throw throwable;
                        client.close();
                        throw throwable;
                    }
                    client.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (MalformedURLException | URISyntaxException e) {
                uploadResult.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_UPLOAD, (Throwable)e, String.format("Invalid URL for uploading '%s' to '%s': %s", reportFile.getPath(), hostUrl, e.getMessage()), new Object[0]);
            }
            catch (ClientProtocolException e) {
                uploadResult.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_UPLOAD, (Throwable)e, String.format("Failed to create HTTP client for uploading '%s' to '%s': %s", reportFile.getPath(), hostUrl, e.getMessage()), new Object[0]);
            }
            catch (IOException e) {
                uploadResult.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_UPLOAD, (Throwable)e, String.format("IOError while uploading '%s' to '%s': %s", reportFile.getPath(), hostUrl, e.getMessage()), new Object[0]);
            }
        }
        if (success) return uploadResult;
        if (isResendFailedUploadOperation) return uploadResult;
        String timestampString = Iso8601DateFormat.formatDateAndTimeForFileName((Date)new Date(System.currentTimeMillis()));
        String targetName = FileUtility.removeExtension((String)reportFile.getName());
        try {
            String reportTargetName = SonargraphEnterpriseReportUploader.createTargetFileName(targetName, timestampString, (IFileType)CoreFileType.REPORT_XML);
            Files.copy(Paths.get(reportFile.getAbsolutePath(), new String[0]), Paths.get(this.m_failedUploadsDirectory.getAbsolutePath(), reportTargetName), new CopyOption[0]);
        }
        catch (IOException e) {
            LOGGER.error(String.format("Failed to copy report '%s' for later retry", reportName), (Throwable)e);
        }
        if (snapshotFile != null) {
            try {
                String snapshotTargetName = SonargraphEnterpriseReportUploader.createTargetFileName(targetName, timestampString, (IFileType)CoreFileType.SNAPSHOT);
                Files.copy(Paths.get(snapshotFile.getAbsolutePath(), new String[0]), Paths.get(this.m_failedUploadsDirectory.getAbsolutePath(), snapshotTargetName), new CopyOption[0]);
            }
            catch (IOException e) {
                LOGGER.error(String.format("Failed to copy report '%s' for later retry", snapshotFile.getName()), (Throwable)e);
            }
        }
        this.storePropertiesFile(reportFile.getName(), useSonargraphId, branch, version, commitId, timestampString, targetName);
        return uploadResult;
    }

    private static String createTargetFileName(String targetName, String timestampString, IFileType type) {
        return targetName + "_" + timestampString + type.getDefaultExtension();
    }

    private void storePropertiesFile(String reportFileName, boolean useSonargraphId, String branch, String version, String commitId, String timestampString, String targetName) {
        assert (reportFileName != null && reportFileName.length() > 0) : "Parameter 'reportFileName' of method 'storePropertiesFile' must not be empty";
        assert (timestampString != null && timestampString.length() > 0) : "Parameter 'timestampString' of method 'storePropertiesFile' must not be empty";
        assert (targetName != null && targetName.length() > 0) : "Parameter 'targetName' of method 'storePropertiesFile' must not be empty";
        Properties uploadProps = new Properties();
        uploadProps.put(PROPS_REPORT_NAME, reportFileName);
        uploadProps.put(PROPS_USE_SONARGRAPH_ID, Boolean.toString(useSonargraphId));
        uploadProps.put(PROPS_BRANCH, SonargraphEnterpriseReportUploader.getActualBranch(branch));
        if (version != null && version.length() > 0) {
            uploadProps.put(PROPS_VERSION, version);
        }
        if (commitId != null && commitId.length() > 0) {
            uploadProps.put(PROPS_COMMIT_ID, commitId);
        }
        String propsFileName = SonargraphEnterpriseReportUploader.createTargetFileName(targetName, timestampString, (IFileType)CoreFileType.PROPERTIES);
        try {
            Throwable throwable = null;
            Object var11_13 = null;
            try (TFileWriter writer = new TFileWriter((File)new TFile((File)this.m_failedUploadsDirectory, propsFileName), false, StandardCharsets.UTF_8);){
                uploadProps.store((Writer)writer, "Upload of resources to Sonargraph Enterprise failed.");
                writer.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            LOGGER.error("Failed to persist properties file '" + propsFileName + "'", (Throwable)ex);
        }
    }

    private HttpPost createHttpPostRequest(String hostUrl, TFile reportFile, TFile snapshotFile, boolean useSonargraphId, String branch, String version, String commitId, String clientKey, String reportName) throws MalformedURLException, URISyntaxException {
        URL host = new URL(hostUrl);
        URL url = new URL(host, "/upload/sonargraphXmlReport");
        HttpPost post = new HttpPost(url.toURI());
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.addBinaryBody("report", new File(reportFile.getAbsolutePath()), ContentType.APPLICATION_XML, reportName);
        if (snapshotFile != null) {
            builder.addBinaryBody("snapshot", new File(snapshotFile.getAbsolutePath()), ContentType.DEFAULT_BINARY, snapshotFile.getName());
        }
        HttpEntity entity = builder.build();
        post.setEntity(entity);
        post.setHeader("X-SonargraphReportName", reportName);
        post.setHeader("X-UseSonargraphId", Boolean.toString(useSonargraphId));
        post.setHeader("X-SonargraphBranch", SonargraphEnterpriseReportUploader.getActualBranch(branch));
        post.setHeader("X-ClientKey", clientKey);
        if (version != null && version.length() > 0) {
            post.setHeader("X-SonargraphVersion", version);
        }
        if (commitId != null && commitId.length() > 0) {
            post.setHeader("X-SonargraphCommitId", commitId);
        }
        return post;
    }

    private static String getActualBranch(String branch) {
        return branch == null ? BRANCH_DEFAULT : branch;
    }

    StrictPair<Integer, Set<String>> uploadFailedReports(String hostUrl, String clientKey) {
        assert (hostUrl != null && hostUrl.length() > 0) : "Parameter 'hostUrl' of method 'uploadFailedReports' must not be empty";
        assert (clientKey != null && clientKey.length() > 0) : "Parameter 'clientKey' of method 'uploadFailedReports' must not be empty";
        int count = 0;
        int successfullyUploadedReports = 0;
        HashSet<String> failedUploadedReports = new HashSet<String>();
        for (TFile propertyFile : this.determinePropertyFiles()) {
            Properties props = new Properties();
            try {
                props.load((InputStream)new TFileInputStream((File)propertyFile));
            }
            catch (IOException e) {
                LOGGER.error("Failed to load properties file '{}'", (Throwable)e);
                continue;
            }
            String reportName = props.getProperty(PROPS_REPORT_NAME);
            String branch = props.getProperty(PROPS_BRANCH);
            String version = props.getProperty(PROPS_VERSION);
            String commitId = props.getProperty(PROPS_COMMIT_ID);
            String useSonargraphIdProp = props.getProperty(PROPS_USE_SONARGRAPH_ID);
            boolean useSonargraphId = useSonargraphIdProp != null ? Boolean.parseBoolean(useSonargraphIdProp) : true;
            String fileName = FileUtility.getFileNameWithoutExtension((TFile)propertyFile);
            TFile reportFile = new TFile((File)this.m_failedUploadsDirectory, fileName + CoreFileType.REPORT_XML.getDefaultExtension());
            if (!reportFile.exists()) {
                LOGGER.error("Report file belonging to property file '{}' does not exist.");
                continue;
            }
            TFile snapshotFile = new TFile((File)this.m_failedUploadsDirectory, fileName + CoreFileType.SNAPSHOT.getDefaultExtension());
            if (!snapshotFile.exists()) {
                snapshotFile = null;
            }
            OperationResultWithOutcome<String> uploadResult = this.internUploadFiles(hostUrl, reportName, reportFile, snapshotFile, useSonargraphId, branch, version, commitId, clientKey, true);
            ++count;
            if (uploadResult.isSuccess()) {
                ++successfullyUploadedReports;
                try {
                    reportFile.rm();
                }
                catch (IOException e) {
                    LOGGER.error("Failed to remove uploaded report file", (Throwable)e);
                }
                if (snapshotFile != null) {
                    try {
                        snapshotFile.rm_r();
                    }
                    catch (IOException e) {
                        LOGGER.error("Failed to remove uploaded snapshot file", (Throwable)e);
                    }
                }
                try {
                    propertyFile.rm();
                }
                catch (IOException ex) {
                    LOGGER.error("Failed to remove properties file", (Throwable)ex);
                }
                continue;
            }
            failedUploadedReports.add(reportFile.getAbsolutePath());
        }
        LOGGER.info(String.format("Uploaded %d of %d reports successfully to Sonargraph-Enterprise", successfullyUploadedReports, count));
        return new StrictPair((Object)successfullyUploadedReports, failedUploadedReports);
    }

    private List<TFile> determinePropertyFiles() {
        TFile[] reportFiles = this.m_failedUploadsDirectory.listFiles((d, n) -> n.endsWith(CoreFileType.PROPERTIES.getDefaultExtension()));
        if (reportFiles == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(reportFiles);
    }
}

