/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin.angular;

import com.hello2morrow.sonargraph.plugin.angular.IExecutionContext;
import com.hello2morrow.sonargraph.plugin.angular.IJsonFileManager;
import com.hello2morrow.sonargraph.plugin.angular.JsonFile;
import com.hello2morrow.sonargraph.plugin.angular.NxProjectJsonFile;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

final class NxJsonFile
extends JsonFile {
    private final List<NxProjectJsonFile> m_nxProjectJsonFiles = new ArrayList<NxProjectJsonFile>();

    NxJsonFile(Path path, IJsonFileManager manager, IExecutionContext context) throws IOException {
        super(path, manager);
        assert (path != null) : "Parameter 'path' of method 'NxJsonFile' must not be null";
        assert (manager != null) : "Parameter 'manager' of method 'NxJsonFile' must not be null";
        assert (context != null) : "Parameter 'context' of method 'NxJsonFile' must not be null";
        for (String dir : List.of("apps", "libs")) {
            if (context.hasBeenCanceled()) {
                return;
            }
            List components = Files.list(this.getPath().getParent().resolve(dir)).collect(Collectors.toList());
            for (Path p : components) {
                if (context.hasBeenCanceled()) {
                    return;
                }
                Path projectPath = p.resolve("project.json");
                if (!Files.exists(projectPath, new LinkOption[0])) continue;
                NxProjectJsonFile projectJson = new NxProjectJsonFile(projectPath, path, manager, context);
                this.m_nxProjectJsonFiles.add(projectJson);
            }
        }
    }

    Optional<Path> getSourceFor(Path path) {
        return this.m_nxProjectJsonFiles.stream().filter(project -> path.equals(project.getTsConfigJsonFile().getPath())).findFirst().map(NxProjectJsonFile::getSourceRoot);
    }

    List<NxProjectJsonFile> getNxProjectJsonFiles() {
        return this.m_nxProjectJsonFiles;
    }
}

