/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.classfile;

import com.hello2morrow.sonargraph.languageprovider.java.foundation.common.JavaNameUtility;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaFileType;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Opcodes;

public final class ClassPackageNameExtractor
extends ClassVisitor
implements Opcodes {
    private String m_fullyQualifiedName;

    private ClassPackageNameExtractor() {
        super(589824);
    }

    public static String extractPackageName(TFile classFile) {
        ClassPackageNameExtractor extractor = new ClassPackageNameExtractor();
        return extractor.getPackageName(classFile);
    }

    private String getPackageName(TFile file) {
        assert (file != null) : "Parameter 'file' of method 'getPackageName' must not be null";
        assert (JavaFileType.determine(file.getName()) == JavaFileType.CLASS_FILE) : "Not a class file: " + file.getAbsolutePath();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedInputStream classFileStream = new BufferedInputStream((InputStream)new TFileInputStream((File)file));){
                ClassReader cr = new ClassReader((InputStream)classFileStream);
                cr.accept((ClassVisitor)this, 7);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String packageName = null;
        if (this.m_fullyQualifiedName != null) {
            packageName = JavaNameUtility.getPackageNameFromFullyQualifiedTypeName(this.m_fullyQualifiedName);
        }
        return packageName;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'visit' must not be empty";
        this.m_fullyQualifiedName = name.replace('/', '.');
    }
}

