/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser;

import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.CppSignatureEncoder;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.ICompilationUnitContext;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.IElementProcessor;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.parser.EDG;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.parser.EDGVisitor;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppElementType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppFunctionSpec;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppProgrammingElement;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppSourceFileElement;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppDependencyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CodeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CodeAnalyzer.class);
    private final CppProgrammingElement m_from;
    private final CppSourceFileElement m_fromHeader;
    private final ICompilationUnitContext m_context;
    private final IElementProcessor m_proc;
    private boolean m_isLValue = false;
    private boolean m_isVirtualCall;
    private boolean m_isCall;
    private int m_numberOfLogicalOperations;

    private CodeAnalyzer(CppProgrammingElement from, IElementProcessor proc, ICompilationUnitContext context) {
        this.m_from = from;
        this.m_fromHeader = from.getSource();
        this.m_context = context;
        this.m_proc = proc;
    }

    private void analyze(EDG.CObject node) {
        node.accept(new CodeVisitor());
    }

    static int analyze(CppProgrammingElement from, ICompilationUnitContext context, IElementProcessor proc, EDG.CObject node) {
        if (node == null || from.isExternal()) {
            return 0;
        }
        CodeAnalyzer analyzer = new CodeAnalyzer(from, proc, context);
        analyzer.analyze(node);
        return analyzer.m_numberOfLogicalOperations;
    }

    private final class CodeVisitor
    extends EDGVisitor {
        EDG.SourcePosition m_fallbackPosition;

        private CodeVisitor() {
        }

        private void setFallbackPosition(EDG.SourcePosition pos) {
            if (pos != null && pos.seq() != 0L) {
                this.m_fallbackPosition = pos;
            }
        }

        private CppFunctionSpec mapRoutine(EDG.Routine routine) {
            if (routine.compilerGenerated() || routine.isLambdaBody()) {
                return null;
            }
            CppFunctionSpec routineElement = (CppFunctionSpec)CodeAnalyzer.this.m_context.getElement(routine);
            if (routineElement == null) {
                if (routine.isTemplateFunction() && !routine.isPrototypeInstantiation()) {
                    routineElement = (CppFunctionSpec)CodeAnalyzer.this.m_context.getElement(routine.assocTemplate());
                }
                if (routineElement == null) {
                    routineElement = (CppFunctionSpec)CodeAnalyzer.this.m_context.getElement(routine.sourceCorresp().declPosition().getOriginalPosition());
                }
            }
            if (routineElement == null) {
                LOGGER.warn(String.format("no match for '%s' at '%s'", routine.sourceCorresp().name(), routine.sourceCorresp().declPosition().getPosition()));
            }
            return routineElement;
        }

        private void addDependencyTo(EDG.SourcePosition pos, CppProgrammingElement to, CppDependencyType type) {
            int lineNumber = 0;
            if ((pos == null || pos.seq() == 0L) && (pos = this.m_fallbackPosition) == null) {
                return;
            }
            lineNumber = pos.getPosition().getLineNumber();
            CodeAnalyzer.this.m_from.addDependency(to, type, lineNumber);
        }

        private void addDependenciesFromType(EDG.SourcePosition pos, EDG.Type type, CppDependencyType dependencyType) {
            if (pos.seq() == 0L) {
                pos = this.m_fallbackPosition;
            }
            CppSignatureEncoder.encode(CodeAnalyzer.this.m_proc, type, CodeAnalyzer.this.m_context, CodeAnalyzer.this.m_from, dependencyType, pos);
        }

        private void addDependencyTo(EDG.SourcePosition pos, EDG.Routine routine, boolean isCall, boolean isVirtual) {
            if (!routine.compilerGenerated() && !routine.isLambdaBody()) {
                CppFunctionSpec r;
                if (pos == null || pos.seq() == 0L) {
                    pos = this.m_fallbackPosition;
                }
                if ((r = this.mapRoutine(routine)) == null) {
                    return;
                }
                if ((r = (CppFunctionSpec)CodeAnalyzer.this.m_context.selectDependencyTargetForPosition(CodeAnalyzer.this.m_fromHeader, r, pos)) == null) {
                    return;
                }
                CppDependencyType depType = !isCall ? CppDependencyType.ADDRESS_TAKEN : (isVirtual ? CppDependencyType.VIRTUAL_CALL : CppDependencyType.CALL);
                this.addDependencyTo(pos, r, depType);
            }
        }

        @Override
        public void visitScopeRoutine(EDG.ScopeRoutine obj) {
            this.setFallbackPosition(obj.assocBlock().position());
            EDG.ConstructorInit ci = obj.constructorInits();
            while (ci != null) {
                ci.accept(this);
                ci = ci.next();
            }
            obj.assocBlock().accept(this);
        }

        @Override
        public void visitConstructorInit(EDG.ConstructorInit obj) {
            if (obj.initializer() != null) {
                obj.initializer().accept(this);
            }
            if (obj.sourceExpr() != null) {
                obj.sourceExpr().accept(this);
            }
        }

        @Override
        public void visitConstructorInitField(EDG.ConstructorInitField obj) {
            CppProgrammingElement field;
            this.visitConstructorInit(obj);
            if (!obj.compilerGenerated() && (field = CodeAnalyzer.this.m_context.mapField(obj.field(), CodeAnalyzer.this.m_proc)) != null) {
                this.addDependencyTo(obj.ctorInitRange().start(), field, CppDependencyType.INITIALIZE);
            }
        }

        @Override
        public void visitConstantAggregate(EDG.ConstantAggregate obj) {
            EDG.Constant c = obj.firstConstant();
            while (c != null) {
                c.accept(this);
                c = c.next();
            }
        }

        @Override
        public void visitConstant(EDG.Constant obj) {
            if (obj.expr() != null) {
                obj.expr().accept(this);
            }
        }

        @Override
        public void visitConstantPtrToMemberRoutine(EDG.ConstantPtrToMemberRoutine obj) {
            EDG.Routine r = obj.routine();
            if (r != null) {
                this.addDependencyTo(obj.sourceCorresp().declPosition(), r, false, false);
            }
        }

        @Override
        public void visitConstantDynamicInit(EDG.ConstantDynamicInit obj) {
            if (obj.ptr() != null) {
                obj.ptr().accept(this);
            }
        }

        @Override
        public void visitConstantAddressConstant(EDG.ConstantAddressConstant obj) {
            if (obj.constant() != null) {
                EDG.Constant constant = obj.constant();
                CppProgrammingElement pe = CodeAnalyzer.this.m_context.getElement(constant);
                if (pe != null) {
                    this.addDependencyTo(null, pe, CppDependencyType.READ);
                } else {
                    constant.accept(this);
                }
            }
        }

        @Override
        public void visitConstantAddressRoutine(EDG.ConstantAddressRoutine obj) {
            EDG.Routine r = obj.routine();
            if (r != null) {
                if (obj.expr() != null && obj.expr().exprRange() != null) {
                    this.addDependencyTo(obj.expr().exprRange().start(), r, false, false);
                } else {
                    this.addDependencyTo(null, r, false, false);
                }
            }
        }

        @Override
        public void visitConstantAddressVariable(EDG.ConstantAddressVariable obj) {
            CppProgrammingElement varElement;
            EDG.Variable var = obj.variable();
            if (var != null && (varElement = CodeAnalyzer.this.m_context.getElement(var)) != null) {
                EDG.SourceRange sr;
                EDG.SourcePosition pos = null;
                EDG.ExprNode node = obj.expr();
                if (node != null && (sr = node.exprRange()) != null) {
                    pos = sr.start();
                }
                if ((varElement = CodeAnalyzer.this.m_context.selectDependencyTargetForPosition(CodeAnalyzer.this.m_fromHeader, varElement, pos)) != null) {
                    this.addDependencyTo(pos, varElement, CppDependencyType.ADDRESS_TAKEN);
                }
            }
        }

        @Override
        public void visitConstantPtrToMemberField(EDG.ConstantPtrToMemberField obj) {
            CppProgrammingElement field = CodeAnalyzer.this.m_context.mapField(obj.field(), CodeAnalyzer.this.m_proc);
            if (field != null) {
                this.addDependencyTo(obj.sourceCorresp().declPosition(), field, CppDependencyType.ADDRESS_TAKEN);
            }
        }

        @Override
        public void visitConstantIntegerValue(EDG.ConstantIntegerValue obj) {
            if (obj.expr() != null) {
                obj.expr().accept(this);
            } else {
                CppProgrammingElement enumTypeElement = CodeAnalyzer.this.m_context.getElement(obj.type());
                if (enumTypeElement != null && enumTypeElement.getType() == CppElementType.ENUM) {
                    CppProgrammingElement constant = CodeAnalyzer.this.m_context.getConstant(enumTypeElement, (int)obj.integerValue());
                    if (constant != null) {
                        this.addDependencyTo(null, constant, CppDependencyType.USES);
                    } else {
                        this.addDependencyTo(null, enumTypeElement, CppDependencyType.USES);
                    }
                }
            }
        }

        @Override
        public void visitDynamicInitConstructor(EDG.DynamicInitConstructor obj) {
            EDG.ExprNode arg = obj.args();
            while (arg != null) {
                arg.accept(this);
                arg = arg.next();
            }
            EDG.Routine constructor = obj.ptr();
            if (constructor != null) {
                assert (constructor.specialKind() == EDG.SpecialFunctionKind.SFK_CONSTRUCTOR);
                this.addDependencyTo(null, constructor, true, false);
            }
        }

        @Override
        public void visitDynamicInitExpression(EDG.DynamicInitExpression obj) {
            obj.expression().accept(this);
        }

        @Override
        public void visitDynamicInitConstant(EDG.DynamicInitConstant obj) {
            CppProgrammingElement constant = CodeAnalyzer.this.m_context.getElement(obj.ptr());
            if (constant != null) {
                this.addDependencyTo(obj.sourceCorresp().declPosition(), constant, CppDependencyType.USES);
            } else {
                EDG.ExprNode node = obj.ptr().expr();
                if (node != null) {
                    node.accept(this);
                }
            }
            if (obj.lambda() != null) {
                obj.lambda().accept(this);
            }
        }

        @Override
        public void visitLambda(EDG.Lambda obj) {
            if (obj.lambdaRoutine() != null) {
                obj.lambdaRoutine().getScope().accept(this);
            }
        }

        @Override
        public void visitExprNode(EDG.ExprNode obj) {
        }

        @Override
        public void visitExprNodeBuiltinOperation(EDG.ExprNodeBuiltinOperation obj) {
        }

        @Override
        public void visitExprNodeCondition(EDG.ExprNodeCondition obj) {
            EDG.ConditionSupplement sup = obj.condition();
            if (sup.dynamicInit() != null) {
                sup.dynamicInit().accept(this);
            }
            if (sup.expr() != null) {
                sup.expr().accept(this);
            }
        }

        @Override
        public void visitExprNodeConstant(EDG.ExprNodeConstant obj) {
            EDG.Constant constant = obj.ptr();
            assert (constant != null);
            CppProgrammingElement enumConst = CodeAnalyzer.this.m_context.getElement(constant);
            if (enumConst != null) {
                this.addDependencyTo(obj.exprRange().start(), enumConst, CppDependencyType.USES);
            } else if (constant.expr() != null) {
                constant.expr().accept(this);
            } else {
                constant.accept(this);
            }
        }

        @Override
        public void visitExprNodeField(EDG.ExprNodeField obj) {
            CppProgrammingElement field = CodeAnalyzer.this.m_context.mapField(obj.ptr(), CodeAnalyzer.this.m_proc);
            if (field != null) {
                this.addDependencyTo(obj.exprRange().start(), field, CodeAnalyzer.this.m_isLValue ? CppDependencyType.WRITE : CppDependencyType.READ);
            }
        }

        @Override
        public void visitExprNodeVariable(EDG.ExprNodeVariable obj) {
            EDG.SourcePosition pos;
            CppProgrammingElement varElement;
            EDG.Variable var = obj.ptr();
            EDG.StorageClass sc = var.declaredStorageClass();
            if (sc != EDG.StorageClass.SC_AUTO && sc != EDG.StorageClass.SC_REGISTER && (varElement = CodeAnalyzer.this.m_context.getElement(var)) != null && (varElement = CodeAnalyzer.this.m_context.selectDependencyTargetForPosition(CodeAnalyzer.this.m_fromHeader, varElement, pos = obj.exprRange().start())) != null) {
                this.addDependencyTo(pos, varElement, CodeAnalyzer.this.m_isLValue ? CppDependencyType.WRITE : CppDependencyType.READ);
            }
        }

        @Override
        public void visitExprNodeInit(EDG.ExprNodeInit obj) {
            if (obj.dynamicInit() != null) {
                obj.dynamicInit().accept(this);
            }
            if (obj.kind() == EDG.ExprNodeKind.ENK_LAMBDA.ordinal() && obj.source_lambda() != null) {
                obj.source_lambda().accept(this);
            }
        }

        @Override
        public void visitExprNodeNewDelete(EDG.ExprNodeNewDelete obj) {
            EDG.NewDeleteSupplement sup = obj.newDelete();
            EDG.Type type = sup.type();
            if (type instanceof EDG.TypeClassStructUnion) {
                CppProgrammingElement typeElement = CodeAnalyzer.this.m_context.mapRawType(CodeAnalyzer.this.m_proc, type, obj.exprRange().start(), false);
                assert (typeElement != null) : "new/delete requires a real class";
                this.addDependencyTo(obj.exprRange().start(), typeElement, sup.isNew() ? CppDependencyType.NEW : CppDependencyType.DELETE);
                if (sup.isNew()) {
                    if (sup.dynamicInit() != null) {
                        sup.dynamicInit().accept(this);
                    }
                } else if (sup.dynamicInit() != null) {
                    EDG.Routine destructor = sup.dynamicInit().destructor();
                    if (destructor != null) {
                        this.addDependencyTo(obj.exprRange().start(), destructor, true, destructor.isVirtual());
                    }
                    sup.arg().accept(this);
                }
            }
        }

        @Override
        public void visitExprNodeObjectLifetime(EDG.ExprNodeObjectLifetime obj) {
            if (obj.expr() != null) {
                obj.expr().accept(this);
            }
        }

        @Override
        public void visitExprNodeOperation(EDG.ExprNodeOperation obj) {
            boolean isLvalue = CodeAnalyzer.this.m_isLValue;
            boolean assignment = false;
            boolean firstOpIsRvalue = false;
            boolean isDynamic = false;
            this.setFallbackPosition(obj.exprRange().start());
            CodeAnalyzer.this.m_isCall = false;
            CodeAnalyzer.this.m_isVirtualCall = false;
            switch (obj.operationKind()) {
                case EOK_POST_INCR: 
                case EOK_POST_DECR: 
                case EOK_PRE_INCR: 
                case EOK_PRE_DECR: 
                case EOK_ASSIGN: 
                case EOK_ADD_ASSIGN: 
                case EOK_SUBTRACT_ASSIGN: 
                case EOK_MULTIPLY_ASSIGN: 
                case EOK_DIVIDE_ASSIGN: 
                case EOK_REMAINDER_ASSIGN: 
                case EOK_SHIFTL_ASSIGN: 
                case EOK_SHIFTR_ASSIGN: 
                case EOK_AND_ASSIGN: 
                case EOK_OR_ASSIGN: 
                case EOK_XOR_ASSIGN: 
                case EOK_PADD_ASSIGN: 
                case EOK_PSUBTRACT_ASSIGN: {
                    assignment = true;
                    break;
                }
                case EOK_DOT_FIELD: 
                case EOK_POINTS_TO_FIELD: 
                case EOK_DOT_STATIC: 
                case EOK_POINTS_TO_STATIC: {
                    firstOpIsRvalue = true;
                    break;
                }
                case EOK_LAND: 
                case EOK_LOR: {
                    ++CodeAnalyzer.this.m_numberOfLogicalOperations;
                    break;
                }
                case EOK_DOT_MEMBER_CALL: 
                case EOK_POINTS_TO_MEMBER_CALL: {
                    CodeAnalyzer.this.m_isVirtualCall = obj.isVirtualCall();
                    CodeAnalyzer.this.m_isCall = true;
                    break;
                }
                case EOK_CALL: 
                case EOK_DOT_PM_CALL: 
                case EOK_POINTS_TO_PM_CALL: {
                    CodeAnalyzer.this.m_isCall = true;
                    break;
                }
            }
            switch (obj.operationKind()) {
                case EOK_DYNAMIC_CAST: 
                case EOK_REF_DYNAMIC_CAST: {
                    isDynamic = true;
                }
                case EOK_CAST: 
                case EOK_REF_CAST: 
                case EOK_BASE_CLASS_CAST: 
                case EOK_DERIVED_CLASS_CAST: 
                case EOK_PM_BASE_CLASS_CAST: 
                case EOK_PM_DERIVED_CLASS_CAST: {
                    if (obj.compilerGenerated()) break;
                    this.addDependenciesFromType(obj.exprRange().start(), obj.type(), isDynamic ? CppDependencyType.DYNAMIC_CAST : CppDependencyType.CAST);
                }
            }
            if (assignment) {
                CodeAnalyzer.this.m_isLValue = true;
            }
            EDG.ExprNode node = obj.operands();
            while (node != null) {
                if (firstOpIsRvalue && CodeAnalyzer.this.m_isLValue) {
                    CodeAnalyzer.this.m_isLValue = false;
                    node.accept(this);
                    firstOpIsRvalue = false;
                    CodeAnalyzer.this.m_isLValue = true;
                } else {
                    node.accept(this);
                    CodeAnalyzer.this.m_isLValue = false;
                }
                node = node.next();
            }
            CodeAnalyzer.this.m_isLValue = isLvalue;
        }

        @Override
        public void visitExprNodeParamRef(EDG.ExprNodeParamRef obj) {
        }

        @Override
        public void visitExprNodeReusedValueInit(EDG.ExprNodeReusedValueInit obj) {
        }

        @Override
        public void visitExprNodeRoutine(EDG.ExprNodeRoutine obj) {
            this.addDependencyTo(obj.exprRange().start(), obj.ptr(), CodeAnalyzer.this.m_isCall, CodeAnalyzer.this.m_isVirtualCall);
        }

        @Override
        public void visitExprNodeSizeofInfo(EDG.ExprNodeSizeofInfo obj) {
        }

        @Override
        public void visitExprNodeSizeofInfoExpr(EDG.ExprNodeSizeofInfoExpr obj) {
            obj.expr().accept(this);
        }

        @Override
        public void visitExprNodeSizeofInfoType(EDG.ExprNodeSizeofInfoType obj) {
            this.addDependenciesFromType(obj.exprRange().start(), obj.type(), CppDependencyType.SIZEOF);
        }

        @Override
        public void visitExprNodeSizeofPack(EDG.ExprNodeSizeofPack obj) {
        }

        @Override
        public void visitExprNodeSizeofPackExpr(EDG.ExprNodeSizeofPackExpr obj) {
        }

        @Override
        public void visitExprNodeSizeofPackTempl(EDG.ExprNodeSizeofPackTempl obj) {
        }

        @Override
        public void visitExprNodeSizeofPackType(EDG.ExprNodeSizeofPackType obj) {
        }

        @Override
        public void visitExprNodeStatement(EDG.ExprNodeStatement obj) {
            obj.statement().accept(this);
        }

        @Override
        public void visitExprNodeThrowInfo(EDG.ExprNodeThrowInfo obj) {
        }

        @Override
        public void visitExprNodeTypeidInfo(EDG.ExprNodeTypeidInfo obj) {
        }

        @Override
        public void visitExprNodeTypeOperand(EDG.ExprNodeTypeOperand obj) {
        }

        @Override
        public void visitStatementBlock(EDG.StatementBlock obj) {
            this.setFallbackPosition(obj.position());
            assert (obj.expr() == null);
            EDG.Statement s = obj.statements();
            while (s != null) {
                s.accept(this);
                s = s.next();
            }
        }

        @Override
        public void visitStatement(EDG.Statement obj) {
            this.setFallbackPosition(obj.position());
            if (obj.expr() != null) {
                obj.expr().accept(this);
            }
        }

        @Override
        public void visitStatementReturnDynamicInit(EDG.StatementReturnDynamicInit obj) {
            this.setFallbackPosition(obj.position());
            if (obj.expr() != null) {
                obj.expr().accept(this);
            } else if (obj.returnDynamicInit() != null) {
                obj.returnDynamicInit().accept(this);
            }
        }

        @Override
        public void visitStatementDynamicInit(EDG.StatementDynamicInit obj) {
            this.setFallbackPosition(obj.position());
            assert (obj.expr() == null);
            obj.dynamicInit().accept(this);
        }

        @Override
        public void visitStatementForLoop(EDG.StatementForLoop obj) {
            this.setFallbackPosition(obj.position());
            EDG.ForLoop extraInfo = obj.extraInfo();
            if (extraInfo.initialization() != null) {
                extraInfo.initialization().accept(this);
            }
            if (obj.expr() != null) {
                obj.expr().accept(this);
            }
            if (extraInfo.increment() != null) {
                extraInfo.increment().accept(this);
            }
            obj.statement().accept(this);
        }

        @Override
        public void visitStatementIfStmt(EDG.StatementIfStmt obj) {
            this.setFallbackPosition(obj.position());
            obj.expr().accept(this);
            obj.thenStatement().accept(this);
            if (obj.elseStatement() != null) {
                obj.elseStatement().accept(this);
            }
        }

        @Override
        public void visitStatementLoopStatement(EDG.StatementLoopStatement obj) {
            this.setFallbackPosition(obj.position());
            obj.expr().accept(this);
            obj.loopStatement().accept(this);
        }

        @Override
        public void visitStatementSwitchStmt(EDG.StatementSwitchStmt obj) {
            obj.expr().accept(this);
            obj.bodyStatement().accept(this);
        }

        @Override
        public void visitStatementTryBlock(EDG.StatementTryBlock obj) {
            this.setFallbackPosition(obj.position());
            obj.tryBlock().statement().accept(this);
            EDG.Handler h = obj.tryBlock().handlers();
            while (h != null) {
                this.setFallbackPosition(h.catchPosition());
                if (h.dynamicInit() != null) {
                    h.dynamicInit().accept(this);
                }
                h.statement().accept(this);
                h = h.next();
            }
        }

        @Override
        public void visitStatementMicrosoftTry(EDG.StatementMicrosoftTry obj) {
            this.setFallbackPosition(obj.position());
            obj.microsoftTry().guardedStatement().accept(this);
            if (obj.microsoftTry().cleanupStatement() != null) {
                obj.microsoftTry().cleanupStatement().accept(this);
            }
        }

        @Override
        public void visitVariable(EDG.Variable obj) {
            this.setFallbackPosition(obj.sourceCorresp().declPosition());
            if (obj.initializer_dynamic() != null) {
                obj.initializer_dynamic().accept(this);
            } else if (obj.initializer_constant() != null) {
                obj.initializer_constant().accept(this);
            } else if (obj.initializer_boundExpr() != null) {
                obj.initializer_boundExpr().accept(this);
            }
        }
    }
}

