/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.apitest;

import com.hello2morrow.sonargraph.integration.access.controller.ControllerFactory;
import com.hello2morrow.sonargraph.integration.access.controller.IModuleInfoProcessor;
import com.hello2morrow.sonargraph.integration.access.controller.ISonargraphSystemController;
import com.hello2morrow.sonargraph.integration.access.foundation.Result;
import com.hello2morrow.sonargraph.integration.access.model.IMetricLevel;
import com.hello2morrow.sonargraph.integration.access.model.IModule;
import com.hello2morrow.sonargraph.integration.access.model.IThresholdViolationIssue;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;

public final class ModuleInfoProcessorThresholdViolationTest {
    ISonargraphSystemController m_controller;

    @Test
    public void validateThresholdIssues() {
        this.m_controller = ControllerFactory.createController();
        Result result = this.m_controller.loadSystemReport(new File("./src/test/resources/AlarmClock_thresholdViolations.xml"));
        Assert.assertTrue((String)("Failed to read report: " + result.toString()), (boolean)result.isSuccess());
        Map<String, IModule> moduleMap = this.m_controller.getSoftwareSystem().getModules();
        IModule moduleFoundation = moduleMap.get("Foundation");
        Assert.assertNotNull((String)"Module 'Foundation' not found", (Object)moduleFoundation);
        this.validateSourceFileThresholdIssuesForModule(moduleFoundation, 1, 1, 54);
        IModule moduleModel = moduleMap.get("Model");
        Assert.assertNotNull((String)"Module 'Model' not found", (Object)moduleModel);
        this.validateSourceFileThresholdIssuesForModule(moduleModel, 1, 1, 54);
        IModule moduleView = moduleMap.get("View");
        Assert.assertNotNull((String)"Module 'View' not found", (Object)moduleView);
        this.validateSourceFileThresholdIssuesForModule(moduleView, 0, 0, -1);
    }

    private void validateSourceFileThresholdIssuesForModule(IModule module, int numberOfAllThresholdViolations, int numberOfLocSourceFileViolations, int metricValue) {
        IModuleInfoProcessor processor = this.m_controller.createModuleInfoProcessor(module);
        List<IThresholdViolationIssue> thresholdIssues = processor.getThresholdViolationIssues(null);
        Assert.assertEquals((String)"Wrong number of issues", (long)numberOfAllThresholdViolations, (long)thresholdIssues.size());
        Optional<IMetricLevel> sourceFileLevel = processor.getMetricLevel("SourceFile");
        Assert.assertTrue((String)"Source file metric level does not exist", (boolean)sourceFileLevel.isPresent());
        List<IThresholdViolationIssue> linesOfCodeViolations = processor.getThresholdViolationIssues(th -> th.getThreshold().getMetricId().getName().equals("CoreLinesOfCode") && th.getThreshold().getMetricLevel().getName().equals("SourceFile"));
        Assert.assertEquals((String)"Wrong number of metric threshold issue", (long)numberOfLocSourceFileViolations, (long)linesOfCodeViolations.size());
        if (numberOfLocSourceFileViolations > 0) {
            Assert.assertEquals((String)"Wrong metric value", (long)metricValue, (long)linesOfCodeViolations.get(0).getMetricValue().intValue());
        }
    }
}

