/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.typescript.controller.system.architecture;

import com.hello2morrow.sonargraph.core.controller.system.architecture.AssignableAttributeRetriever;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitecturalModelProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.languageprovider.typescript.foundation.common.TypescriptLanguage;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.programming.TypescriptClass;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.programming.TypescriptInterface;
import gnu.trove.set.hash.THashSet;
import java.util.Collections;
import java.util.Set;

public abstract class TypescriptTypeHierarchyRetriever
extends AssignableAttributeRetriever<NamedElement> {
    protected static final String MATCHING_RULE = "Please note that \u201c*\u201d will match anything except dots ('.').\n\nWildcards: ?=any character, *=any sequence between slashes, **=any sequence";

    public String getBreakCharacters() {
        return ".";
    }

    public boolean availableFor(IArchitecturalModelProvider.ArchitectureModel architectureModel) {
        assert (architectureModel != null) : "Parameter 'architectureModel' of method 'availableFor' must not be null";
        switch (architectureModel) {
            case PHYSICAL: {
                return true;
            }
            case LOGICAL: {
                return false;
            }
        }
        assert (false) : "Unhandled architecture model: " + String.valueOf(architectureModel);
        return false;
    }

    protected abstract void collect(IWorkerContext var1, ProgrammingElement var2, Set<String> var3);

    protected boolean collectFor(ProgrammingElement type) {
        assert (type != null) : "Parameter 'type' of method 'collectFor' must not be null";
        return type instanceof TypescriptClass || type instanceof TypescriptInterface;
    }

    public Language getLanguage() {
        return TypescriptLanguage.INSTANCE;
    }

    protected String cutOffGenericParameters(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'cutOffGenericParameters' must not be empty";
        int ltPos = name.indexOf(60);
        if (ltPos > 0) {
            return name.substring(0, ltPos);
        }
        return name;
    }

    protected final Set<String> getData(IWorkerContext workerContext, NamedElement tsFile) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'getData' must not be null";
        assert (tsFile != null) : "Parameter 'tsFile' of method 'getData' must not be null";
        if (workerContext.hasBeenCanceled()) {
            return Collections.emptySet();
        }
        Set data = this.getData(tsFile);
        if (data == null) {
            data = new THashSet();
            for (ProgrammingElement pe : tsFile.getChildrenRecursively(ProgrammingElement.class, new Class[0])) {
                if (workerContext.hasBeenCanceled()) {
                    return Collections.emptySet();
                }
                if (!this.collectFor(pe)) continue;
                this.collect(workerContext, pe, data);
            }
            this.setData(tsFile, data);
        }
        return data;
    }

    public String getMultipleAttributeInfo() {
        return this.getShortName();
    }

    protected String computeAttributeForComponent(IWorkerContext workerContext, IComponent assignable, String[] params) {
        NamedElement tsFile = assignable.getNamedElement();
        return this.createAttribute(this.getData(workerContext, tsFile));
    }
}

