/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.utilities;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

public final class NumberUtility {
    public static final int MAX_PRECISION_USED = 2;
    private static final long MEGABYTE = 0x100000L;
    private static final DecimalFormat FLOAT_FORMAT;
    private static final DecimalFormat FLOAT_FORMAT_NO_GROUPING;
    private static final Locale STANDARD_LOCALE;
    private static final DecimalFormat LOCALE_INDEPENDENT_FLOAT_FORMAT;
    private static final NumberFormat INTEGER_FORMAT;
    private static final NumberFormat INTEGER_FORMAT_NO_GROUPING;

    static {
        STANDARD_LOCALE = Locale.US;
        FLOAT_FORMAT = (DecimalFormat)DecimalFormat.getInstance(Locale.getDefault());
        FLOAT_FORMAT.setMaximumFractionDigits(2);
        FLOAT_FORMAT.setMinimumFractionDigits(2);
        FLOAT_FORMAT.setRoundingMode(RoundingMode.HALF_UP);
        FLOAT_FORMAT_NO_GROUPING = (DecimalFormat)DecimalFormat.getInstance(Locale.getDefault());
        FLOAT_FORMAT_NO_GROUPING.setMaximumFractionDigits(2);
        FLOAT_FORMAT_NO_GROUPING.setMinimumFractionDigits(2);
        FLOAT_FORMAT_NO_GROUPING.setRoundingMode(RoundingMode.HALF_UP);
        FLOAT_FORMAT_NO_GROUPING.setGroupingUsed(false);
        LOCALE_INDEPENDENT_FLOAT_FORMAT = (DecimalFormat)DecimalFormat.getInstance(STANDARD_LOCALE);
        LOCALE_INDEPENDENT_FLOAT_FORMAT.setMaximumFractionDigits(2);
        LOCALE_INDEPENDENT_FLOAT_FORMAT.setMinimumFractionDigits(2);
        LOCALE_INDEPENDENT_FLOAT_FORMAT.setRoundingMode(RoundingMode.HALF_UP);
        LOCALE_INDEPENDENT_FLOAT_FORMAT.setGroupingUsed(false);
        INTEGER_FORMAT = NumberFormat.getIntegerInstance();
        INTEGER_FORMAT_NO_GROUPING = NumberFormat.getIntegerInstance();
        INTEGER_FORMAT_NO_GROUPING.setGroupingUsed(false);
    }

    private NumberUtility() {
    }

    public static String format(Number number) {
        return NumberUtility.format(number, true);
    }

    public static String format(Number number, boolean grouping) {
        return NumberUtility.internalFormat(number, grouping, true);
    }

    public static String formatLocaleIndependent(Number number) {
        return NumberUtility.internalFormat(number, false, false);
    }

    private static String internalFormat(Number number, boolean grouping, boolean useLocale) {
        assert (number != null) : "Parameter 'number' of method 'format' must not be null";
        boolean isBigDecimal = number instanceof BigDecimal;
        if (isBigDecimal || number instanceof Float || number instanceof Double) {
            try {
                BigDecimal bigDecimal;
                BigDecimal bigDecimal2 = bigDecimal = isBigDecimal ? (BigDecimal)number : new BigDecimal(number.toString());
                if (useLocale) {
                    return grouping ? FLOAT_FORMAT.format(bigDecimal) : FLOAT_FORMAT_NO_GROUPING.format(bigDecimal);
                }
                return LOCALE_INDEPENDENT_FLOAT_FORMAT.format(bigDecimal);
            }
            catch (NumberFormatException n) {
                return "n/a";
            }
        }
        if (number instanceof Integer || number instanceof Long) {
            return grouping ? INTEGER_FORMAT.format(number) : INTEGER_FORMAT_NO_GROUPING.format(number);
        }
        return number.toString();
    }

    public static Number parse(String number, boolean integerOnly) {
        return NumberUtility.parse(number, integerOnly, false);
    }

    public static Number parse(String number, boolean integerOnly, boolean grouping) {
        Number result = null;
        NumberFormat nf = integerOnly ? (grouping ? INTEGER_FORMAT : INTEGER_FORMAT_NO_GROUPING) : (grouping ? FLOAT_FORMAT : FLOAT_FORMAT_NO_GROUPING);
        number = number.trim();
        nf.setParseIntegerOnly(integerOnly);
        nf.setGroupingUsed(grouping);
        ParsePosition pp = new ParsePosition(0);
        result = nf.parse(number, pp);
        if (pp.getIndex() < number.length() || pp.getErrorIndex() >= 0) {
            return null;
        }
        return result;
    }

    public static Number parseLocaleIndependently(String number, boolean integerOnly) {
        Number result = null;
        NumberFormat nf = integerOnly ? INTEGER_FORMAT_NO_GROUPING : LOCALE_INDEPENDENT_FLOAT_FORMAT;
        number = number.trim();
        nf.setParseIntegerOnly(integerOnly);
        nf.setGroupingUsed(false);
        ParsePosition pp = new ParsePosition(0);
        result = nf.parse(number, pp);
        if (pp.getIndex() < number.length() || pp.getErrorIndex() >= 0) {
            return null;
        }
        return result;
    }

    public static float round(float toRound) {
        float rounded = toRound * 100.0f;
        float temp = Math.round(rounded);
        rounded = temp / 100.0f;
        return rounded;
    }

    public static double round(double toRound, int factor) {
        double rounded = toRound * (double)factor;
        double temp = Math.round(rounded);
        rounded = temp / (double)factor;
        return rounded;
    }

    public static double round(double toRound) {
        return NumberUtility.round(toRound, 100);
    }

    public static float getPercentageWithoutRounding(int part, int total) {
        assert (total >= part) : "Part is greater than total: " + part + " greater than " + total;
        if (total == 0 || part == 0) {
            return 0.0f;
        }
        return 100.0f / (float)total * (float)part;
    }

    public static float getPercentage(int part, int total) {
        assert (total >= part) : "Total is less than part";
        float result = NumberUtility.getPercentageWithoutRounding(part, total);
        return result == 0.0f ? 0.0f : NumberUtility.round(result);
    }

    public static char getGroupingSeparator() {
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance();
        return symbols.getGroupingSeparator();
    }

    public static char getDecimalSeparator() {
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance();
        return symbols.getDecimalSeparator();
    }

    public static String bytesToMegabytes(long bytes) {
        return NumberUtility.format(bytes / 0x100000L);
    }

    public static boolean areEqual(Float f1, Float f2) {
        if (f1 != null) {
            return f1.equals(f2);
        }
        if (f2 != null) {
            return f2.equals(f1);
        }
        return true;
    }
}

