/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.export;

import com.hello2morrow.sonargraph.foundation.export.Column;
import com.hello2morrow.sonargraph.foundation.export.ColumnDatatype;
import com.hello2morrow.sonargraph.foundation.export.RowComparator;
import com.hello2morrow.sonargraph.foundation.export.Sort;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class ExportData {
    private final String m_name;
    private final String m_header;
    private List<Column> m_columns;
    private List<List<Object>> m_rows;
    private boolean m_sorted;
    private int m_sortColumnIndex = -1;

    public ExportData(String name, String header) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'ExportData' must not be empty";
        assert (header != null && header.length() > 0) : "Parameter 'header' of method 'ExportData' must not be empty";
        this.m_name = name;
        this.m_header = header;
        this.m_columns = null;
        this.m_rows = null;
        this.m_sorted = false;
    }

    public ExportData(String name) {
        this(name, name);
    }

    public String getSheetName() {
        return this.m_name;
    }

    public String getSheetHeader() {
        return this.m_header;
    }

    public void addColumn(String title) {
        this.addColumn(title, ColumnDatatype.TEXT);
    }

    public void addColumn(String title, ColumnDatatype datatype) {
        this.addColumn(title, datatype, Sort.NONE);
    }

    public void addColumn(String title, ColumnDatatype datatype, Sort sort) {
        assert (title != null && title.length() > 0) : "Parameter 'title' of method 'addColumn' must not be empty";
        assert (datatype != null) : "Parameter 'datatype' of method 'addColumn' must not be null";
        assert (sort != null) : "Parameter 'sort' of method 'addColumn' must not be null";
        assert (this.m_rows == null) : "don't add additional columns after rows were already added";
        if (this.m_columns == null) {
            this.m_columns = new ArrayList<Column>();
        }
        Column column = new Column(title, datatype, sort);
        if (sort != Sort.NONE && this.m_sortColumnIndex != -1) {
            this.m_sortColumnIndex = this.m_columns.size();
        }
        this.m_columns.add(column);
    }

    public void addRow(Object ... columns) {
        assert (columns != null) : "Parameter 'columns' of method 'addRow' must not be null";
        assert (this.m_columns != null) : "there must be columns before adding a row";
        assert (columns.length == this.getColumnCount()) : "wrong number of columns";
        int index = 0;
        while (index < columns.length) {
            ColumnDatatype columnDatatype = this.m_columns.get(index).getType();
            Object object = columns[index];
            assert (columnDatatype.checkObject(object)) : "wrong object, expected " + String.valueOf((Object)columnDatatype) + ", but got" + String.valueOf(object.getClass());
            ++index;
        }
        if (this.m_rows == null) {
            this.m_rows = new ArrayList<List<Object>>();
        }
        this.m_rows.add(Arrays.asList(columns));
        this.m_sorted = false;
    }

    public int getRowCount() {
        if (this.m_rows != null) {
            return this.m_rows.size();
        }
        return 0;
    }

    public int getColumnCount() {
        if (this.m_columns != null) {
            return this.m_columns.size();
        }
        return 0;
    }

    public List<String> getColumnNames() {
        if (this.m_columns != null) {
            ArrayList<String> result = new ArrayList<String>(this.getColumnCount());
            for (Column column : this.m_columns) {
                result.add(column.getTitle());
            }
            return result;
        }
        return Collections.emptyList();
    }

    public boolean isColumnDatatype(int column, ColumnDatatype datatype) {
        assert (column >= 0 && column < this.getColumnCount());
        assert (datatype != null) : "Parameter 'datatype' of method 'isColumnDatatype' must not be null";
        return this.m_columns.get(column).getType() == datatype;
    }

    public Object getValueAt(int row, int column) {
        assert (row >= 0 && row < this.getRowCount());
        assert (column >= 0 && column < this.getColumnCount());
        if (!this.m_sorted) {
            this.sort();
        }
        return this.m_rows.get(row).get(column);
    }

    private void sort() {
        Collections.sort(this.m_rows, new RowComparator(Collections.unmodifiableList(this.m_columns), Math.max(this.m_sortColumnIndex, 0)));
        this.m_sorted = true;
    }
}

