/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.javapg.runtime.messaging;

import com.hello2morrow.javapg.runtime.messaging.FatalErrorException;
import com.hello2morrow.javapg.runtime.messaging.MessageReporter;
import com.hello2morrow.javapg.runtime.messaging.Position;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageBuilder
implements MessageReporter {
    private int errorCount;
    private int warningCount;
    private MessageReporter reporter = null;
    private ResourceBundle bundle;

    public MessageBuilder(String bundleName, MessageReporter out) {
        this(bundleName);
        this.reporter = out;
    }

    public MessageReporter getReporter() {
        return this.reporter;
    }

    private MessageBuilder(String bundleName) {
        this.bundle = ResourceBundle.getBundle(bundleName);
        try {
            String positionFormat = this.bundle.getString("PositionFormat");
            assert (positionFormat != null);
            Position.setFormat(positionFormat);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    @Override
    public void reportMessage(int severity, Position pos, String msg) {
        switch (severity) {
            case 2: 
            case 3: {
                ++this.errorCount;
                break;
            }
            case 1: {
                ++this.warningCount;
            }
        }
        this.reporter.reportMessage(severity, pos, msg);
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public void reset() {
        this.warningCount = 0;
        this.errorCount = 0;
    }

    public String buildMessage(String msgName, Object[] args) {
        String format = this.bundle.getString(msgName);
        return MessageFormat.format(format, args);
    }

    private void writeMsg(int msgClass, Position pos, String msgName, Object[] args) {
        this.reportMessage(msgClass, pos, this.buildMessage(msgName, args));
    }

    public void writeItSafe(int msgClass, Position pos, String msgName, Object[] args) {
        assert (msgClass != 3);
        this.writeMsg(msgClass, pos, msgName, args);
    }

    public void writeIt(int msgClass, Position pos, String msgName, Object[] args) throws FatalErrorException {
        this.writeMsg(msgClass, pos, msgName, args);
        if (msgClass == 3) {
            throw new FatalErrorException();
        }
    }

    public void write(int msgClass, Position pos, String msgCode) throws FatalErrorException {
        this.writeIt(msgClass, pos, msgCode, null);
    }

    public void write(int msgClass, Position pos, String msgCode, Object a1) throws FatalErrorException {
        Object[] args = new Object[]{a1};
        this.writeIt(msgClass, pos, msgCode, args);
    }

    public void write(int msgClass, Position pos, String msgCode, Object a1, Object a2) throws FatalErrorException {
        Object[] args = new Object[]{a1, a2};
        this.writeIt(msgClass, pos, msgCode, args);
    }

    public void write(int msgClass, Position pos, String msgCode, Object a1, Object a2, Object a3) throws FatalErrorException {
        Object[] args = new Object[]{a1, a2, a3};
        this.writeIt(msgClass, pos, msgCode, args);
    }

    public void writeSafe(int msgClass, Position pos, String msgCode) {
        this.writeItSafe(msgClass, pos, msgCode, null);
    }

    public void writeSafe(int msgClass, Position pos, String msgCode, Object a1) {
        Object[] args = new Object[]{a1};
        this.writeItSafe(msgClass, pos, msgCode, args);
    }

    public void writeSafe(int msgClass, Position pos, String msgCode, Object a1, Object a2) {
        Object[] args = new Object[]{a1, a2};
        this.writeItSafe(msgClass, pos, msgCode, args);
    }

    public void writeSafe(int msgClass, Position pos, String msgCode, Object a1, Object a2, Object a3) {
        Object[] args = new Object[]{a1, a2, a3};
        this.writeItSafe(msgClass, pos, msgCode, args);
    }
}

