/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.qualitygate;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractCurrentIssueQualityGateCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.Operator;
import java.util.List;

public final class CurrentIssueQualityGateCondition
extends AbstractCurrentIssueQualityGateCondition {
    public CurrentIssueQualityGateCondition(NamedElement parent, String issueType, List<String> severities, List<String> resolutions, Operator operator, int limit) {
        super(parent, issueType, severities, resolutions, operator, limit);
    }

    @Override
    public String getPresentationName(boolean shortName) {
        if (shortName) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName()).append('|');
            builder.append(this.getIssueType()).append('|');
            builder.append(CurrentIssueQualityGateCondition.getSeverityAsString(this.getSeverityList())).append('|');
            builder.append(CurrentIssueQualityGateCondition.getResolutionsAsString(this.getResolutionList())).append('|');
            builder.append(this.getOperator().getStandardName()).append('|');
            builder.append(this.getLimit());
            return builder.toString();
        }
        return CurrentIssueQualityGateCondition.createPresentationNameLong(this.getIssueType(), this.getSeverityList(), this.getResolutionList(), this.getOperator(), this.getLimit());
    }

    public static String createPresentationNameLong(String issueType, List<String> severities, List<String> resolutions, Operator operator, int limit) {
        StringBuilder builder = new StringBuilder();
        builder.append(operator.getPresentationName()).append(" ").append(limit);
        builder.append(" issues of type");
        builder.append(" '").append(issueType).append("'");
        builder.append(" with severity '").append(CurrentIssueQualityGateCondition.getSeverityAsString(severities)).append("'");
        builder.append(" and resolution '").append(CurrentIssueQualityGateCondition.getResolutionsAsString(resolutions)).append("'");
        return builder.toString();
    }
}

