/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.diff.issue;

import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.SingleElementDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.IIssueDiff;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.integration.access.model.IIssue;
import com.hello2morrow.sonargraph.integration.access.model.INamedElement;
import com.hello2morrow.sonargraph.integration.access.model.Severity;

public abstract class IssueDiff<B extends IIssue, C extends Issue>
extends SingleElementDiff<B, C>
implements IIssueDiff {
    protected final String m_changeDescription;

    public IssueDiff(NamedElement parent, B baseline, C current, IDiffElement.Change change) {
        super(parent, baseline, current, change);
        this.m_changeDescription = null;
    }

    public IssueDiff(NamedElement parent, B baseline, C current, IDiffElement.Change change, String changeDescription) {
        super(parent, baseline, current, change);
        assert (changeDescription != null) : "Parameter 'm_changeDescription' of method 'IssueDiff' must not be null";
        this.m_changeDescription = changeDescription;
    }

    @Override
    public boolean providesChangeDescription() {
        return true;
    }

    @Override
    public String getShortName() {
        if (this.getCurrent() != null) {
            return ((Issue)this.getCurrent()).getShortName();
        }
        return ((IIssue)this.getBaseline()).getPresentationName();
    }

    @Override
    public final String getImageResourceName() {
        return IssueDiff.class.getSimpleName();
    }

    @Override
    public String getFullyQualifiedNamePart() {
        StringBuilder fqNamePart = new StringBuilder(this.getShortName());
        if (this.getCurrent() != null) {
            Issue issue = (Issue)this.getCurrent();
            Object affectedElement = issue.getAffectedElement();
            NamedElement elementOrFrom = null;
            if (affectedElement instanceof Dependency) {
                Dependency dependency = (Dependency)affectedElement;
                affectedElement = dependency.getFrom();
            }
            if (affectedElement instanceof NamedElement) {
                elementOrFrom = (NamedElement)affectedElement;
            }
            if (elementOrFrom != null) {
                fqNamePart.append(Element.DESCRIPTOR_SEPARATOR);
                fqNamePart.append(elementOrFrom.getFullyQualifiedName());
            }
            fqNamePart.append(Element.DESCRIPTOR_SEPARATOR);
            fqNamePart.append(Element.escapeSpecialCharacters(issue.getId().getStandardName()));
            fqNamePart.append(Element.DESCRIPTOR_SEPARATOR);
            fqNamePart.append(Element.escapeSpecialCharacters(issue.getProvider().getStandardName()));
            fqNamePart.append(Element.DESCRIPTOR_SEPARATOR);
            fqNamePart.append(Integer.toString(issue.getLineNumber()));
            fqNamePart.append(Element.DESCRIPTOR_SEPARATOR);
            fqNamePart.append(Integer.toString(issue.getColumn()));
        } else {
            IIssue issue = (IIssue)this.getBaseline();
            fqNamePart.append(Element.DESCRIPTOR_SEPARATOR);
            fqNamePart.append(((INamedElement)issue.getAffectedNamedElements().get(0)).getFqName());
            fqNamePart.append(Element.DESCRIPTOR_SEPARATOR);
            fqNamePart.append(Element.escapeSpecialCharacters(issue.getIssueType().getName()));
            fqNamePart.append(Element.DESCRIPTOR_SEPARATOR);
            fqNamePart.append(Element.escapeSpecialCharacters(issue.getIssueProvider().getName()));
            fqNamePart.append(Element.DESCRIPTOR_SEPARATOR);
            fqNamePart.append(Integer.toString(issue.getLine()));
            fqNamePart.append(Element.DESCRIPTOR_SEPARATOR);
            fqNamePart.append(Integer.toString(issue.getColumn()));
        }
        return fqNamePart.toString();
    }

    @Override
    public final String getIssueCategoryStandardName() {
        if (this.getCurrent() != null) {
            return ((Issue)this.getCurrent()).getId().getCategory().getStandardName();
        }
        return ((IIssue)this.getBaseline()).getIssueType().getCategory().getName();
    }

    @Override
    public final com.hello2morrow.sonargraph.core.model.common.Severity getSeverity() {
        if (this.getCurrent() != null) {
            return ((Issue)this.getCurrent()).getSeverity();
        }
        Severity baselineSeverity = ((IIssue)this.getBaseline()).getSeverity();
        switch (baselineSeverity) {
            case ERROR: {
                return com.hello2morrow.sonargraph.core.model.common.Severity.ERROR;
            }
            case WARNING: {
                return com.hello2morrow.sonargraph.core.model.common.Severity.WARNING;
            }
            case INFO: {
                return com.hello2morrow.sonargraph.core.model.common.Severity.INFO;
            }
        }
        return com.hello2morrow.sonargraph.core.model.common.Severity.NONE;
    }

    @Override
    public final String getIssueCategoryPresentationName() {
        if (this.getCurrent() != null) {
            return ((Issue)this.getCurrent()).getId().getCategory().getPresentationName();
        }
        return ((IIssue)this.getBaseline()).getIssueType().getCategory().getPresentationName();
    }

    @Override
    public final String getProviderPresentationName() {
        if (this.getCurrent() != null) {
            return ((Issue)this.getCurrent()).getProvider().getPresentationName();
        }
        return ((IIssue)this.getBaseline()).getIssueProvider().getPresentationName();
    }

    @Override
    @Property
    public String getChangeDescription() {
        StringBuilder result = new StringBuilder();
        if (this.getCurrent() != null) {
            result.append(((Issue)this.getCurrent()).getDescription());
        } else {
            result.append(((IIssue)this.getBaseline()).getDescription());
        }
        if (this.m_changeDescription != null && !this.m_changeDescription.trim().isEmpty()) {
            result.append(", ").append(this.m_changeDescription);
        }
        return result.toString();
    }
}

