/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system;

import com.hello2morrow.sonargraph.core.model.element.Issue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class IssueDelta {
    private final List<Issue> m_issuesAdded = new ArrayList<Issue>();
    private final List<Issue> m_issuesRemoved = new ArrayList<Issue>();

    public void issuesAdded(List<Issue> issues) {
        assert (issues != null) : "Parameter 'issues' of method 'issuesAdded' must not be null";
        this.m_issuesAdded.addAll(issues);
    }

    public void issuesRemoved(List<Issue> issues) {
        assert (issues != null) : "Parameter 'issues' of method 'issuesRemoved' must not be null";
        this.m_issuesRemoved.addAll(issues);
    }

    public List<Issue> getIssuesAdded() {
        return Collections.unmodifiableList(this.m_issuesAdded);
    }

    public List<Issue> getIssuesRemoved() {
        return Collections.unmodifiableList(this.m_issuesRemoved);
    }

    public boolean isEmpty() {
        return this.m_issuesAdded.isEmpty() && this.m_issuesRemoved.isEmpty();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.m_issuesAdded.size()).append(" issue(s) added and ").append(this.m_issuesRemoved.size()).append(" issue(s) removed.");
        for (Issue next : this.m_issuesAdded) {
            builder.append("\n").append(" Added: ").append(next);
        }
        for (Issue next : this.m_issuesRemoved) {
            builder.append("\n").append(" Removed: ").append(next);
        }
        return builder.toString();
    }
}

