/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.script;

import java.util.HashSet;
import java.util.Set;

public class UniqueNameValidator {
    private final Set<String> m_existingNames;

    public UniqueNameValidator() {
        this.m_existingNames = new HashSet<String>();
    }

    public UniqueNameValidator(Set<String> existingNames) {
        assert (existingNames != null) : "Parameter 'existingNames' of method 'UniqueNameValidator' must not be null";
        this.m_existingNames = existingNames;
    }

    protected final boolean addName(String name) {
        assert (name != null) : "Parameter 'name' of method 'addName' must not be null";
        return this.m_existingNames.add(name);
    }

    protected final boolean removeName(String name) {
        assert (name != null) : "Parameter 'name' of method 'removeName' must not be null";
        return this.m_existingNames.remove(name);
    }

    public boolean isNameUnique(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'isNameValid' must not be empty";
        return !this.m_existingNames.contains(name);
    }

    private String getPrefix(String stringWithPrefix) {
        assert (stringWithPrefix != null && stringWithPrefix.length() > 0) : "Parameter 'stringWithPrefix' of method 'getPrefix' must not be empty";
        int openBrace = stringWithPrefix.lastIndexOf(" (");
        int closeBrace = stringWithPrefix.lastIndexOf(")");
        if (openBrace != -1 && closeBrace != -1 && closeBrace > openBrace + 2) {
            String number = stringWithPrefix.substring(openBrace + 2, closeBrace);
            try {
                Integer.parseInt(number);
                return stringWithPrefix.substring(0, openBrace);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return stringWithPrefix;
    }

    public String getValidName(String nameToTest) {
        String newName;
        String prefix = this.getPrefix(nameToTest);
        int index = 0;
        while (!this.isNameUnique(newName = prefix + " (" + index++ + ")")) {
        }
        this.m_existingNames.add(newName);
        return newName;
    }
}

