/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.script;

import com.hello2morrow.sonargraph.core.model.common.SourceLineWithContext;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.path.SourceFileReferenceWithLineNumberAndContext;
import com.hello2morrow.sonargraph.core.model.script.ScriptTreeNode;

public final class ScriptIssueSourceFileAndLineTreeNode
extends ScriptTreeNode {
    private final SourceFileReferenceWithLineNumberAndContext m_element;
    private final String m_description;

    public ScriptIssueSourceFileAndLineTreeNode(SourceFile sourceFile, String description, SourceLineWithContext line) {
        assert (sourceFile != null) : "Parameter 'sourceFile' of method 'ScriptIssueSourceFileTreeNode' must not be null";
        assert (description != null) : "Parameter 'description' of method 'ScriptIssueSourceFileTreeNode' must not be null";
        assert (line != null) : "Parameter 'line' of method 'ScriptIssueSourceFileTreeNode' must not be null";
        this.m_element = new SourceFileReferenceWithLineNumberAndContext(sourceFile, line);
        this.m_description = description;
    }

    @Override
    public SourceFileReferenceWithLineNumberAndContext getElement() {
        return this.m_element;
    }

    @Override
    public String getName() {
        return this.m_element.getPresentationName(false) + " [line: " + this.m_element.getLineNumber() + "]";
    }

    @Override
    public String getImageResourceName() {
        return this.m_element.getImageResourceName();
    }

    public String getDescription() {
        return this.m_description;
    }

    public int getLine() {
        return this.m_element.getLineNumber();
    }
}

