/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.refactoring;

import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.refactoring.PhysicalImpactDependencyEndpointCollector;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringStateHandler;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import java.util.ArrayList;
import java.util.List;

public class DeletionVisitor
extends NamedElementVisitor {
    private final RefactoringStateHandler m_refactoringStateHandler;
    private final boolean m_includeRecursiveElementChildren;
    private List<NamedElement> m_additional = new ArrayList<NamedElement>();
    private NamedElement m_deleted;

    public DeletionVisitor(RefactoringStateHandler handler, boolean includeRecursiveElementChildren) {
        assert (handler != null) : "Parameter 'handler' of method 'DeletionVisitor' must not be null";
        this.m_refactoringStateHandler = handler;
        this.m_includeRecursiveElementChildren = includeRecursiveElementChildren;
    }

    public final List<NamedElement> reset() {
        List<NamedElement> additional = this.m_additional;
        this.m_additional = new ArrayList<NamedElement>();
        this.m_deleted = null;
        return additional;
    }

    protected final RefactoringStateHandler getRefactoringStateHandler() {
        return this.m_refactoringStateHandler;
    }

    private void setDeletionState(List<ParserDependency> dependencies) {
        assert (dependencies != null) : "Parameter 'iterator' of method 'setDeletionState' must not be null";
        for (ParserDependency nextParserDependency : dependencies) {
            if (this.m_refactoringStateHandler.hasBeenDeleted(nextParserDependency)) continue;
            this.m_refactoringStateHandler.setIndirectlyDeleted(nextParserDependency);
        }
    }

    @Override
    public final void visitNamedElement(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitNamedElement' must not be null";
        if (this.m_deleted == null) {
            this.m_deleted = element;
            if (element instanceof ProgrammingElement) {
                ProgrammingElement programmingElement = (ProgrammingElement)element;
                this.setDeletionState(programmingElement.getIncomingDependencies(new IStandardEnumeration[0]));
                this.setDeletionState(programmingElement.getOutgoingDependencies(new IParserDependencyType[0]));
            }
            if (PhysicalImpactDependencyEndpointCollector.isRecursiveElement(element) && !this.m_includeRecursiveElementChildren) {
                List<IComponent> components = element.getChildren(IComponent.class);
                for (IComponent nextComponent : components) {
                    if (!this.m_refactoringStateHandler.hasBeenDeleted(nextComponent.getNamedElement())) {
                        this.m_refactoringStateHandler.setIndirectlyDeleted(nextComponent.getNamedElement());
                    }
                    for (ProgrammingElement nextProgrammingElement : nextComponent.getNamedElement().getChildrenRecursively(ProgrammingElement.class, new Class[0])) {
                        if (!this.m_refactoringStateHandler.hasBeenDeleted(nextProgrammingElement)) {
                            this.m_refactoringStateHandler.setIndirectlyDeleted(nextProgrammingElement);
                        }
                        this.setDeletionState(nextProgrammingElement.getIncomingDependencies(new IStandardEnumeration[0]));
                        this.setDeletionState(nextProgrammingElement.getOutgoingDependencies(new IParserDependencyType[0]));
                    }
                }
            } else {
                super.visitNamedElement(element);
            }
        } else if (!this.m_refactoringStateHandler.hasBeenDeleted(element)) {
            if (element instanceof ProgrammingElement) {
                ProgrammingElement programmingElement = (ProgrammingElement)element;
                this.setDeletionState(programmingElement.getIncomingDependencies(new IStandardEnumeration[0]));
                this.setDeletionState(programmingElement.getOutgoingDependencies(new IParserDependencyType[0]));
            }
            this.m_refactoringStateHandler.setIndirectlyDeleted(element);
            if (element instanceof SourceFile) {
                this.m_additional.add(element);
            }
            super.visitNamedElement(element);
        }
    }
}

