/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.path;

import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.QualityModel;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ImportQualityModel
extends QualityModel {
    private final Map<IFileType, List<ImportQualityModelCandidate>> m_fileTypeToCandidates = new LinkedHashMap<IFileType, List<ImportQualityModelCandidate>>();
    private boolean m_discardCurrentContent;

    private static Comparator<ImportQualityModelCandidate> getQualityModelCandidateComparator(final Comparator<IModifiableFile> modifiableFileComparator) {
        assert (modifiableFileComparator != null) : "Parameter 'modifiableFileComparator' of method 'getQualityModelCandidateComparator' must not be null";
        return new Comparator<ImportQualityModelCandidate>(){

            @Override
            public int compare(ImportQualityModelCandidate i1, ImportQualityModelCandidate i2) {
                if (!$assertionsDisabled && i1 == null) {
                    throw new AssertionError((Object)"Parameter 'i1' of method 'compare' must not be null");
                }
                if (!$assertionsDisabled && i2 == null) {
                    throw new AssertionError((Object)"Parameter 'i2' of method 'compare' must not be null");
                }
                IModifiableFile m1 = i1.getModifiableFile();
                IModifiableFile m2 = i2.getModifiableFile();
                return modifiableFileComparator.compare(m1, m2);
            }
        };
    }

    public ImportQualityModel(List<IModifiableFile> availableFiles) {
        super(availableFiles);
    }

    public ImportQualityModel() {
    }

    public void addCandidate(IModifiableFile modifiableFile, String description) {
        assert (modifiableFile != null) : "Parameter 'addCandidate' of method 'addCandidate' must not be null";
        boolean isAlreadyInModel = false;
        for (IModifiableFile nextAvailable : this.getAvailableModifiableFiles()) {
            if (!nextAvailable.getIdentifyingPath().equals(modifiableFile.getIdentifyingPath())) continue;
            isAlreadyInModel = true;
            break;
        }
        ImportQualityModelCandidate candidate = new ImportQualityModelCandidate(modifiableFile, true, isAlreadyInModel, description);
        IFileType fileType = candidate.getModifiableFile().getFileType();
        if (!this.m_fileTypeToCandidates.containsKey(fileType)) {
            ArrayList fileTypeCandidates = new ArrayList();
            this.m_fileTypeToCandidates.put(fileType, fileTypeCandidates);
        }
        this.m_fileTypeToCandidates.get(fileType).add(candidate);
    }

    public List<ImportQualityModelCandidate> getCandidates() {
        ArrayList<ImportQualityModelCandidate> candidates = new ArrayList<ImportQualityModelCandidate>();
        for (List<ImportQualityModelCandidate> nextCandidates : this.m_fileTypeToCandidates.values()) {
            candidates.addAll(nextCandidates);
        }
        Collections.sort(candidates, ImportQualityModel.getQualityModelCandidateComparator(ImportQualityModel.getModifiableFileComparator()));
        return candidates;
    }

    public List<ImportQualityModelCandidate> getCandidatesByFileType(IFileType fileType) {
        assert (fileType != null) : "Parameter 'fileType' of method 'getCandidatesByFileType' must not be null";
        for (Map.Entry<IFileType, List<ImportQualityModelCandidate>> nextCandidatesEntry : this.m_fileTypeToCandidates.entrySet()) {
            if (!nextCandidatesEntry.getKey().equals(fileType)) continue;
            ArrayList<ImportQualityModelCandidate> candidates = new ArrayList<ImportQualityModelCandidate>((Collection)nextCandidatesEntry.getValue());
            Collections.sort(candidates, ImportQualityModel.getQualityModelCandidateComparator(ImportQualityModel.getModifiableFileComparator()));
            return candidates;
        }
        return Collections.emptyList();
    }

    public boolean hasContent() {
        for (ImportQualityModelCandidate next : this.getCandidates()) {
            if (!next.isIncluded()) continue;
            return true;
        }
        return false;
    }

    public boolean isValid() {
        return this.hasContent();
    }

    public void setDiscardCurrentContent(boolean discardCurrentContent) {
        this.m_discardCurrentContent = discardCurrentContent;
    }

    public boolean discardCurrentContent() {
        return this.m_discardCurrentContent;
    }

    public CandidateState verifyState(ImportQualityModelCandidate candidate) {
        assert (candidate != null) : "Parameter 'candidate' of method 'verifyState' must not be null";
        for (IModifiableFile nextAvailableFile : this.getAvailableModifiableFiles()) {
            if (!candidate.getModifiableFile().getIdentifyingPath().equals(nextAvailableFile.getIdentifyingPath())) continue;
            candidate.setCandidateState(CandidateState.OVERWRITES);
            if (!nextAvailableFile.needsSave()) continue;
            candidate.setCandidateState(CandidateState.OVERWRITES_MODIFIED);
        }
        return candidate.getCandidateState();
    }

    public static enum CandidateState {
        NO_CONFLICT,
        OVERWRITES,
        OVERWRITES_MODIFIED;

    }

    public static final class ImportQualityModelCandidate {
        private final IModifiableFile m_modifiableFile;
        private boolean m_isIncluded = true;
        private final boolean m_isAlreadyInModel;
        private CandidateState m_candidateState = CandidateState.NO_CONFLICT;
        private final String m_description;

        public ImportQualityModelCandidate(IModifiableFile modifiableFile, boolean isIncluded, boolean isAlreadyInModel, String description) {
            assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'ImportQualityModelCandidate' must not be null";
            this.m_modifiableFile = modifiableFile;
            this.m_isIncluded = isIncluded;
            this.m_isAlreadyInModel = isAlreadyInModel;
            this.m_description = description;
        }

        public IModifiableFile getModifiableFile() {
            return this.m_modifiableFile;
        }

        public boolean isIncluded() {
            return this.m_isIncluded;
        }

        public void toggleIncludedState() {
            this.m_isIncluded = !this.m_isIncluded;
        }

        public void setIncluded(boolean included) {
            this.m_isIncluded = included;
        }

        CandidateState getCandidateState() {
            return this.m_candidateState;
        }

        void setCandidateState(CandidateState candidateState) {
            this.m_candidateState = candidateState;
        }

        public boolean isAlreadyInModel() {
            return this.m_isAlreadyInModel;
        }

        public String getDescription() {
            return this.m_description;
        }
    }
}

