/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.issuehierarchy;

public final class IssueCountInfo {
    private int m_affectedElementCount;
    private int m_errors;
    private int m_warnings;
    private int m_infos;
    private int m_nones;

    IssueCountInfo() {
        this(0, 0, 0, 0, 0);
    }

    public IssueCountInfo(int affectedElementCount, int errors, int warnings, int infos, int nones) {
        this.m_affectedElementCount = affectedElementCount;
        this.m_errors = errors;
        this.m_warnings = warnings;
        this.m_infos = infos;
        this.m_nones = nones;
    }

    public int getAffectedElementCount() {
        return this.m_affectedElementCount;
    }

    public int getErrors() {
        return this.m_errors;
    }

    public int getWarnings() {
        return this.m_warnings;
    }

    public int getInfos() {
        return this.m_infos;
    }

    public int getNones() {
        return this.m_nones;
    }

    void setAffectedElementCount(int affectedElementCount) {
        assert (affectedElementCount > 0) : "Unexpected value: " + affectedElementCount;
        this.m_affectedElementCount = affectedElementCount;
    }

    void increaseErrorCount() {
        ++this.m_errors;
    }

    void increaseWarningCount() {
        ++this.m_warnings;
    }

    void increaseInfoCount() {
        ++this.m_infos;
    }

    void increaseNoneCount() {
        ++this.m_nones;
    }

    public String toString() {
        return "IssueCountInfo [m_affectedElementCount=" + this.m_affectedElementCount + ", m_errors=" + this.m_errors + ", m_warnings=" + this.m_warnings + ", m_infos=" + this.m_infos + ", m_nones=" + this.m_nones + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_affectedElementCount;
        result = 31 * result + this.m_errors;
        result = 31 * result + this.m_infos;
        result = 31 * result + this.m_nones;
        result = 31 * result + this.m_warnings;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IssueCountInfo other = (IssueCountInfo)obj;
        if (this.m_affectedElementCount != other.m_affectedElementCount) {
            return false;
        }
        if (this.m_errors != other.m_errors) {
            return false;
        }
        if (this.m_warnings != other.m_warnings) {
            return false;
        }
        if (this.m_infos != other.m_infos) {
            return false;
        }
        return this.m_nones == other.m_nones;
    }

    public String toPresentationString() {
        StringBuilder info = new StringBuilder();
        info.append("[affectedElementCount:").append(this.m_affectedElementCount).append(", e:").append(this.m_errors).append(", w:").append(this.m_warnings).append(", i:").append(this.m_infos).append(", n:").append(this.m_nones).append("]");
        return info.toString();
    }

    public boolean isEmpty() {
        return this.m_errors + this.m_warnings + this.m_infos + this.m_nones == 0;
    }
}

