/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.analysis;

import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurationCreator;
import com.hello2morrow.sonargraph.core.model.analysis.ScriptRunnerData;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ScriptRunnerConfiguration
extends AnalyzerConfiguration {
    public static final String DEFAULT_RUN_CONFIGURATION_STANDARD_NAME = "Default";
    public static final String DEFAULT_RUN_CONFIGURATION_PRESENTATION_NAME = "[Default]";
    private static final String ENTRY_SEPARATOR = ":";
    static final IConfigurationCreator CREATOR = new IConfigurationCreator(){

        @Override
        public AnalyzerConfiguration create(NamedElement parent, IAnalyzerId analyzerId) {
            return new ScriptRunnerConfiguration(parent, analyzerId);
        }

        @Override
        public String getImageResourceName() {
            return "ScriptRunnerConfiguration";
        }
    };
    private final Map<String, String> m_nameToWarning = new HashMap<String, String>();

    public ScriptRunnerConfiguration(NamedElement parent, IAnalyzerId analyzerId) {
        super(parent, analyzerId);
    }

    private ScriptRunnerConfiguration(ScriptRunnerConfiguration configuration) {
        super(configuration);
        assert (configuration != null) : "Parameter 'configuration' of method 'ScriptRunnerConfiguration' must not be null";
        this.m_nameToWarning.putAll(configuration.m_nameToWarning);
    }

    @Override
    public ScriptRunnerConfiguration copy() {
        return new ScriptRunnerConfiguration(this);
    }

    private String getScriptName(String key) {
        String scriptPath;
        assert (key != null && key.length() > 0) : "Parameter 'key' of method 'getScriptName' must not be empty";
        int pos = key.indexOf(ENTRY_SEPARATOR);
        if (pos != -1 && !(scriptPath = key.substring(pos + 1)).isEmpty()) {
            return scriptPath;
        }
        return null;
    }

    public List<ScriptRunnerData> getScriptRunnerData() {
        Map<String, Object> valueMap = this.getValueMap();
        ArrayList<ScriptRunnerData> data = new ArrayList<ScriptRunnerData>(valueMap.size());
        for (Map.Entry<String, Object> entry : valueMap.entrySet()) {
            ScriptRunnerData next;
            String nextScriptName = this.getScriptName(entry.getKey());
            if (nextScriptName == null || nextScriptName.isEmpty()) continue;
            String nextRunConfigurationName = (String)entry.getValue();
            if (nextRunConfigurationName == null || nextRunConfigurationName.isEmpty() || nextRunConfigurationName.equals(DEFAULT_RUN_CONFIGURATION_STANDARD_NAME)) {
                nextRunConfigurationName = DEFAULT_RUN_CONFIGURATION_PRESENTATION_NAME;
            }
            if (data.contains(next = new ScriptRunnerData(nextScriptName, nextRunConfigurationName))) continue;
            data.add(next);
        }
        return data;
    }

    public void setScriptRunnerData(List<ScriptRunnerData> data) {
        assert (data != null) : "Parameter 'data' of method 'setScriptRunnerData' must not be null";
        this.reset();
        int index = 0;
        for (ScriptRunnerData scriptData : data) {
            String indexAndScript = index + ENTRY_SEPARATOR + scriptData.getIdentifyingScriptPath();
            String nextRunConfigurationName = scriptData.getRunConfigurationName();
            if (nextRunConfigurationName.equals(DEFAULT_RUN_CONFIGURATION_PRESENTATION_NAME)) {
                nextRunConfigurationName = DEFAULT_RUN_CONFIGURATION_STANDARD_NAME;
            }
            this.setValue(indexAndScript, nextRunConfigurationName);
            ++index;
        }
    }

    public void setWarning(String identifyingScriptPath, String runConfigurationName, String warning) {
        assert (identifyingScriptPath != null && identifyingScriptPath.length() > 0) : "Parameter 'identifyingScriptPath' of method 'setWarning' must not be empty";
        assert (runConfigurationName != null && runConfigurationName.length() > 0) : "Parameter 'runConfigurationName' of method 'setWarning' must not be empty";
        assert (warning != null && warning.length() > 0) : "Parameter 'warning' of method 'setWarning' must not be empty";
        this.m_nameToWarning.put(identifyingScriptPath + ENTRY_SEPARATOR + runConfigurationName, warning);
    }

    public String getWarning(String identifyingScriptPath, String runConfigurationName) {
        assert (identifyingScriptPath != null && identifyingScriptPath.length() > 0) : "Parameter 'identifyingScriptPath' of method 'getWarning' must not be empty";
        assert (runConfigurationName != null && runConfigurationName.length() > 0) : "Parameter 'runConfigurationName' of method 'getWarning' must not be empty";
        return this.m_nameToWarning.get(identifyingScriptPath + ENTRY_SEPARATOR + runConfigurationName);
    }

    public void resetWarnings() {
        this.m_nameToWarning.clear();
    }

    @Override
    public void reset() {
        this.resetWarnings();
        super.reset();
    }

    public boolean isAutomated(String identifyingPath, String runConfigurationName) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'isAutomatedScriptWithRunConfiguration' must not be empty";
        for (ScriptRunnerData next : this.getScriptRunnerData()) {
            if (!next.getIdentifyingScriptPath().equals(identifyingPath) || runConfigurationName != null && !next.getRunConfigurationName().equals(runConfigurationName)) continue;
            return true;
        }
        return false;
    }

    public List<String> getAutomatedRunConfigurations(String identifyingPath) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'isAutomatedScriptWithRunConfiguration' must not be empty";
        ArrayList<String> runConfigurations = new ArrayList<String>();
        for (ScriptRunnerData next : this.getScriptRunnerData()) {
            if (!next.getIdentifyingScriptPath().equals(identifyingPath)) continue;
            runConfigurations.add(next.getRunConfigurationName());
        }
        return runConfigurations;
    }
}

