/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.analysis;

import com.hello2morrow.sonargraph.core.model.analysis.IMetricCategory;
import com.hello2morrow.sonargraph.core.model.analysis.MetricScope;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

public interface IMetricId
extends IStandardEnumeration {
    public static final /* synthetic */ int[] $SWITCH_TABLE$com$hello2morrow$sonargraph$core$model$analysis$IMetricId$StandardSorting;

    public IProviderId getProvider();

    public String getDescription();

    public boolean isFloat();

    public MetricScope getMetricScope();

    public List<IMetricCategory> getCategories();

    default public Optional<Number> getBestValue() {
        switch (this.getSorting()) {
            case INDIFFERENT: {
                return Optional.of(Double.NaN);
            }
            case HIGHER_WORSE: {
                return Optional.of(this.getRange().getMinValue());
            }
            case LOWER_WORSE: {
                return Optional.of(this.getRange().getMaxValue());
            }
            case OPTIMUM_AT_ZERO: {
                return Optional.of(0);
            }
        }
        return Optional.empty();
    }

    default public Optional<Number> getWorstValue() {
        switch (this.getSorting()) {
            case INDIFFERENT: {
                return Optional.of(Double.NaN);
            }
            case HIGHER_WORSE: {
                return Optional.of(this.getRange().getMaxValue());
            }
            case LOWER_WORSE: {
                return Optional.of(this.getRange().getMinValue());
            }
            case OPTIMUM_AT_ZERO: {
                return Optional.of(Double.NaN);
            }
        }
        return Optional.of(Double.POSITIVE_INFINITY);
    }

    public IMetricRange getRange();

    public StandardSorting getSorting();

    public static interface IMetricRange
    extends IStandardEnumeration {
        public double getMinValue();

        public double getMaxValue();
    }

    public static final class IdComparator
    implements Comparator<IMetricId> {
        @Override
        public int compare(IMetricId id1, IMetricId id2) {
            return id1.getStandardName().compareTo(id2.getStandardName());
        }
    }

    public static enum MetricRange implements IMetricRange
    {
        NULL_OR_POSITIVE(0.0, Double.POSITIVE_INFINITY),
        PERCENTAGE(0.0, 100.0),
        ZERO_TO_ONE(0.0, 1.0),
        MINUS_ONE_TO_ONE(-1.0, 1.0);

        private final double m_minValue;
        private final double m_maxValue;

        private MetricRange(Double minValue, Double maxValue) {
            this.m_minValue = minValue;
            this.m_maxValue = maxValue;
        }

        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }

        @Override
        public double getMinValue() {
            return this.m_minValue;
        }

        @Override
        public double getMaxValue() {
            return this.m_maxValue;
        }
    }

    public static enum StandardSorting implements IStandardEnumeration
    {
        INDIFFERENT,
        HIGHER_WORSE,
        LOWER_WORSE,
        OPTIMUM_AT_ZERO;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }
}

