/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.analysis;

import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurationCreator;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;

public final class CycleAnalyzerConfiguration
extends AnalyzerConfiguration {
    public static final IConfigurationCreator CREATOR_MODULE_CYCLES = new IConfigurationCreator(){

        @Override
        public AnalyzerConfiguration create(NamedElement parent, IAnalyzerId analyzerId) {
            return new CycleAnalyzerConfiguration(parent, analyzerId, ConfigurationEntryDescriptor.CRITICAL_MODULE_CYCLE_SIZE);
        }

        @Override
        public String getImageResourceName() {
            return "CriticalCycleGroupSizeConfiguration";
        }
    };
    public static final IConfigurationCreator CREATOR_NAMESPACE_CYCLES = new IConfigurationCreator(){

        @Override
        public AnalyzerConfiguration create(NamedElement parent, IAnalyzerId analyzerId) {
            return new CycleAnalyzerConfiguration(parent, analyzerId, ConfigurationEntryDescriptor.CRITICAL_NAMESPACE_CYCLE_SIZE);
        }

        @Override
        public String getImageResourceName() {
            return "CriticalCycleGroupSizeConfiguration";
        }
    };
    public static final IConfigurationCreator CREATOR_COMPONENT_CYCLES = new IConfigurationCreator(){

        @Override
        public AnalyzerConfiguration create(NamedElement parent, IAnalyzerId analyzerId) {
            return new CycleAnalyzerConfiguration(parent, analyzerId, ConfigurationEntryDescriptor.CRITICAL_COMPONENT_CYCLE_SIZE);
        }

        @Override
        public String getImageResourceName() {
            return "CriticalCycleGroupSizeConfiguration";
        }
    };
    public static final IConfigurationCreator CREATOR_DIRECTORY_CYCLES = new IConfigurationCreator(){

        @Override
        public AnalyzerConfiguration create(NamedElement parent, IAnalyzerId analyzerId) {
            return new CycleAnalyzerConfiguration(parent, analyzerId, ConfigurationEntryDescriptor.CRITICAL_DIRECTORY_CYCLE_SIZE);
        }

        @Override
        public String getImageResourceName() {
            return "CriticalCycleGroupSizeConfiguration";
        }
    };
    private final ConfigurationEntryDescriptor m_entryDescriptor;

    public CycleAnalyzerConfiguration(NamedElement parent, IAnalyzerId analyzerId, ConfigurationEntryDescriptor descriptor) {
        super(parent, analyzerId);
        assert (descriptor != null) : "Parameter 'descriptor' of method 'CycleAnalyzerConfiguration' must not be null";
        this.m_entryDescriptor = descriptor;
        this.addValue(descriptor.getStandardName(), descriptor.getDefaultValue());
    }

    @Override
    public void reset() {
        super.reset();
        this.addValue(this.m_entryDescriptor.getStandardName(), this.m_entryDescriptor.getDefaultValue());
    }

    private CycleAnalyzerConfiguration(CycleAnalyzerConfiguration configuration) {
        super(configuration);
        assert (configuration != null) : "Parameter 'configuration' of method 'CycleAnalyzerConfiguration' must not be null";
        this.m_entryDescriptor = configuration.m_entryDescriptor;
    }

    @Override
    public AnalyzerConfiguration copy() {
        return new CycleAnalyzerConfiguration(this);
    }

    @Property
    public int getCriticalCycleGroupSize() {
        return (Integer)this.getValue(this.m_entryDescriptor.getStandardName());
    }

    public void setCriticalCycleGroupSize(int criticalCycleGroupSize) {
        this.setValue(this.m_entryDescriptor.getStandardName(), criticalCycleGroupSize);
    }

    @Property
    public int getDefaultValue() {
        return this.m_entryDescriptor.getDefaultValue();
    }

    public AnalyzerConfiguration.IIntegerConfigurationEntryDescriptor getDescriptor() {
        return this.m_entryDescriptor;
    }

    private static final class ConfigurationEntryDescriptor
    extends Enum<ConfigurationEntryDescriptor>
    implements AnalyzerConfiguration.IIntegerConfigurationEntryDescriptor {
        public static final /* enum */ ConfigurationEntryDescriptor CRITICAL_COMPONENT_CYCLE_SIZE = new ConfigurationEntryDescriptor(6, 2, 9999999, "Critical Cycle Group Size: Component cycle groups with this number of elements or more are marked as critcal (error marker).");
        public static final /* enum */ ConfigurationEntryDescriptor CRITICAL_NAMESPACE_CYCLE_SIZE = new ConfigurationEntryDescriptor(6, 2, 9999999, "Critical Cycle Group Size: Package or namespace cycle groups with this number of elements or more are marked as critical (error marker).");
        public static final /* enum */ ConfigurationEntryDescriptor CRITICAL_DIRECTORY_CYCLE_SIZE = new ConfigurationEntryDescriptor(6, 2, 9999999, "Critical Cycle Group Size: Directory cycle groups with this number of elements or more are marked as critical (error marker).");
        public static final /* enum */ ConfigurationEntryDescriptor CRITICAL_MODULE_CYCLE_SIZE = new ConfigurationEntryDescriptor(2, 2, 9999999, "Critical Cycle Group Size: Module cycle groups with this number of elements or more are marked as critical (error marker).");
        private final int m_defaultValue;
        private final int m_minimalValue;
        private final int m_maximalValue;
        private final String m_description;
        private static final /* synthetic */ ConfigurationEntryDescriptor[] ENUM$VALUES;

        static {
            ENUM$VALUES = new ConfigurationEntryDescriptor[]{CRITICAL_COMPONENT_CYCLE_SIZE, CRITICAL_NAMESPACE_CYCLE_SIZE, CRITICAL_DIRECTORY_CYCLE_SIZE, CRITICAL_MODULE_CYCLE_SIZE};
        }

        private ConfigurationEntryDescriptor(int defaultValue, int minimalValue, int maximalValue, String description) {
            assert (description != null && description.length() > 0) : "Parameter 'description' of method 'ConfigurationEntryDescriptor' must not be empty";
            this.m_defaultValue = defaultValue;
            this.m_description = description;
            this.m_minimalValue = minimalValue;
            this.m_maximalValue = maximalValue;
        }

        @Override
        public Integer getDefaultValue() {
            return this.m_defaultValue;
        }

        @Override
        public int getMaxValue() {
            return this.m_maximalValue;
        }

        @Override
        public int getMinValue() {
            return this.m_minimalValue;
        }

        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return this.m_description;
        }

        public static ConfigurationEntryDescriptor[] values() {
            ConfigurationEntryDescriptor[] configurationEntryDescriptorArray = ENUM$VALUES;
            int n = configurationEntryDescriptorArray.length;
            ConfigurationEntryDescriptor[] configurationEntryDescriptorArray2 = new ConfigurationEntryDescriptor[n];
            System.arraycopy(ENUM$VALUES, 0, configurationEntryDescriptorArray2, 0, n);
            return configurationEntryDescriptorArray2;
        }

        public static ConfigurationEntryDescriptor valueOf(String string) {
            return Enum.valueOf(ConfigurationEntryDescriptor.class, string);
        }
    }
}

