/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.representation;

import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.controller.system.representation.ConnectedNodeRunnerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.representation.ConnectedProgrammingElementCollector;
import com.hello2morrow.sonargraph.core.controller.system.representation.IncomingConnectedProgrammingCollector;
import com.hello2morrow.sonargraph.core.foundation.common.graph.IConnectedNodeRunnerAdapter;
import com.hello2morrow.sonargraph.core.model.programming.DependencyEndpointCollector;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyEdgeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import java.util.Iterator;
import java.util.Set;

public final class IncomingConnectedNodeRunnerAdapter
extends ConnectedNodeRunnerAdapter {
    public IncomingConnectedNodeRunnerAdapter(IWorkerContext workerContext, Set<NodeAdapter> startNodes, DependencyEndpointCollector collector, Set<IParserDependencyType> allowedDependencyTypes, Set<NodeAdapter> connectedNodesCollector, ConnectedNodeRunnerAdapter.NodeRunnerMode nodeRunnerMode) {
        super(workerContext, startNodes, collector, allowedDependencyTypes, connectedNodesCollector, nodeRunnerMode);
    }

    @Override
    public IConnectedNodeRunnerAdapter.Mode getMode() {
        return IConnectedNodeRunnerAdapter.Mode.IN;
    }

    @Override
    protected ConnectedProgrammingElementCollector createConnectedProgramminElementCollector() {
        return new IncomingConnectedProgrammingCollector();
    }

    @Override
    protected boolean keep(ProgrammingElement programmingElement, Set<ProgrammingElement> programmingElements) {
        assert (programmingElement != null) : "Parameter 'programmingElement' of method 'keep' must not be null";
        assert (programmingElements != null) : "'m_programmingElements' of method 'keep' must not be null";
        boolean atLeastOneDependencyRemained = false;
        for (ParserDependency nextOut : programmingElement.getOutgoingDependencies(new IParserDependencyType[0])) {
            if (!this.isAllowed(nextOut) || !programmingElements.contains(nextOut.getTo())) continue;
            atLeastOneDependencyRemained = true;
            break;
        }
        return atLeastOneDependencyRemained;
    }

    @Override
    protected boolean processEdges(ParserDependencyNodeAdapter node, Set<ProgrammingElement> programmingElements, Set<ProgrammingElement> entryPointsOfNextLevel, Set<ParserDependencyEdgeAdapter<ParserDependencyNodeAdapter>> toBeRemovedEdgesCollector) {
        assert (node != null) : "Parameter 'node' of method 'processEdges' must not be null";
        assert (programmingElements != null) : "Parameter 'programmingElements' of method 'processEdges' must not be null";
        assert (entryPointsOfNextLevel != null) : "Parameter 'entryPointsOfNextLevel' of method 'processEdges' must not be null";
        assert (toBeRemovedEdgesCollector != null) : "Parameter 'toBeRemovedEdgesCollector' of method 'processEdges' must not be null";
        boolean atLeastOneInEdgeRemained = false;
        for (ParserDependencyEdgeAdapter<ParserDependencyNodeAdapter> nextInEdge : node.getIncomingEdges()) {
            Iterator<ParserDependency> iterator = nextInEdge.getDependenciesIterator();
            while (iterator.hasNext()) {
                ParserDependency nextParserDependency = iterator.next();
                ProgrammingElement nextTo = nextParserDependency.getTo();
                if (!programmingElements.contains(nextTo)) {
                    iterator.remove();
                    continue;
                }
                entryPointsOfNextLevel.add(nextParserDependency.getFrom());
            }
            if (nextInEdge.getNumberOfDependencies() > 0) {
                atLeastOneInEdgeRemained = true;
                continue;
            }
            toBeRemovedEdgesCollector.add(nextInEdge);
        }
        return atLeastOneInEdgeRemained;
    }
}

