/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.representation;

import com.hello2morrow.sonargraph.core.controller.system.representation.AssignedComponentCollector;
import com.hello2morrow.sonargraph.core.controller.system.representation.RepresentationDescriptorCalculator;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureBaseElement;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureElementContainer;
import com.hello2morrow.sonargraph.core.model.architecture.AssignedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.representation.NodeType;
import com.hello2morrow.sonargraph.core.model.representation.Representation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ArchitectureRepresentationDescriptorCalculator<T extends Representation>
extends RepresentationDescriptorCalculator<T> {
    private Map<String, List<String>> m_originalInputPhysicalElementToComponentsDescriptors;

    public ArchitectureRepresentationDescriptorCalculator(T representation) {
        super(representation);
    }

    @Override
    protected void finishInitialization() {
        super.finishInitialization();
        this.m_originalInputPhysicalElementToComponentsDescriptors = new HashMap<String, List<String>>();
    }

    private String getDescriptorForArchitectureBaseElement(ArchitectureBaseElement architectureBaseElement) {
        assert (architectureBaseElement != null) : "Parameter 'architectureBaseElement' of method 'getDescriptorForArchitectureBaseElement' must not be null";
        StringBuilder descriptorBuilder = new StringBuilder();
        NamedElement parent = architectureBaseElement;
        while (parent != null && parent instanceof ArchitectureBaseElement) {
            descriptorBuilder.insert(0, parent.getShortName() + NamedElement.DESCRIPTOR_NAME_PARTS_SEPARATOR);
            parent = parent.getParent();
        }
        String descriptor = descriptorBuilder.toString();
        return (String)descriptor.subSequence(0, descriptor.length() - 1);
    }

    protected final void saveDescriptors(Set<NamedElement> elements, Map<String, List<String>> physicalElementToComponentsDescriptors, NodeType nodeType) {
        assert (elements != null) : "Parameter 'elements' of method 'saveDescriptors' must not be null";
        assert (physicalElementToComponentsDescriptors != null) : "Parameter 'physicalElementToComponentsDescriptors' of method 'saveDescriptors' must not be null";
        assert (nodeType != null) : "Parameter 'nodeType' of method 'saveDescriptors' must not be null";
        ArrayList<AssignedElement> components = new ArrayList<AssignedElement>();
        ArrayList<ArchitectureBaseElement> architectureBaseElements = new ArrayList<ArchitectureBaseElement>();
        ArrayList<ArchitectureElementContainer> architectureComponentContainers = new ArrayList<ArchitectureElementContainer>();
        for (NamedElement namedElement : elements) {
            if (namedElement instanceof AssignedElement) {
                components.add((AssignedElement)namedElement);
                continue;
            }
            if (namedElement instanceof ArchitectureBaseElement) {
                architectureBaseElements.add((ArchitectureBaseElement)namedElement);
                continue;
            }
            assert (namedElement != null && namedElement instanceof ArchitectureElementContainer) : "Unexpected class in method 'saveDescriptors': " + String.valueOf(namedElement);
            architectureComponentContainers.add((ArchitectureElementContainer)namedElement);
        }
        this.addDescriptors(AssignedElement.class, components.stream().map(AssignedElement::getRepresentedElement).map(NamedElement::getOriginal).map(NamedElement::getOriginalFullyQualifiedName), nodeType);
        this.addDescriptors(ArchitectureBaseElement.class, architectureBaseElements.stream().map(architectureBaseElement -> this.getDescriptorForArchitectureBaseElement((ArchitectureBaseElement)architectureBaseElement)), nodeType);
        HashMap<ArchitectureElementContainer, Set<AssignedElement>> architectureElementsToAssignedComponents = new HashMap<ArchitectureElementContainer, Set<AssignedElement>>();
        for (ArchitectureElementContainer architectureElementContainer : architectureComponentContainers) {
            AssignedComponentCollector collector = new AssignedComponentCollector(architectureElementContainer, elements);
            architectureElementContainer.accept(collector);
            architectureElementsToAssignedComponents.put(architectureElementContainer, collector.getUnderlyingComponents());
        }
        for (Map.Entry entry : architectureElementsToAssignedComponents.entrySet()) {
            ArchitectureElementContainer architectureComponentContainer = (ArchitectureElementContainer)entry.getKey();
            Set assignedComponents = (Set)entry.getValue();
            physicalElementToComponentsDescriptors.put(((NamedElement)architectureComponentContainer.getRepresentedElement()).getOriginal().getOriginalFullyQualifiedName(), assignedComponents.stream().map(AssignedElement::getRepresentedElement).map(NamedElement::getOriginal).map(NamedElement::getOriginalFullyQualifiedName).collect(Collectors.toList()));
        }
    }

    public Map<String, List<String>> getDescriptorsForArchitectureBaseElements(NodeType nodeType) {
        return switch (nodeType) {
            case NodeType.ORIGINAL -> this.m_originalInputPhysicalElementToComponentsDescriptors;
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Unexpected 'nodeType': " + String.valueOf((Object)nodeType)));
                }
                yield null;
            }
        };
    }

    @Override
    protected void saveDescriptors(T representation) {
        assert (representation != null) : "Parameter 'representation' of method 'saveDescriptors' must not be null";
        this.saveDescriptors(((Representation)representation).getOriginalNodes(), this.m_originalInputPhysicalElementToComponentsDescriptors, NodeType.ORIGINAL);
    }
}

