/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewElementResolver;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArtifactHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.FilterHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.IExplorationViewRepresentationHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ModificationHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.OperationExecutor;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.OperationHandler;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewArtifactOperationAvailability;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFile;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewState;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableNode;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableTargetInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.CreateArtifactFromElementsOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.CreateArtifactOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.CreateArtifactsForElementsOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.EditCreateArtifactFromElementsOperationInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.EditCreateArtifactOperationInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.EditCreateArtifactsForElementsOperationInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.EditOperationInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewFocus;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.IAssignableTarget;
import com.hello2morrow.sonargraph.core.model.explorationview.ProgrammingElementAggregatingNode;
import com.hello2morrow.sonargraph.core.model.explorationview.TargetParentOperation;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EditOperationHandler
implements IExplorationViewRepresentationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditOperationHandler.class);

    public static EditCreateArtifactOperationInfo isEditCreateArtifactOperationPossible(ArchitecturalViewOperation operation, ExplorationViewRepresentation representation) {
        assert (operation != null) : "Parameter 'operation' of method 'isEditCreateArtifactOperationPossible' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'isEditCreateArtifactOperationPossible' must not be null";
        return operation instanceof CreateArtifactOperation ? new EditCreateArtifactOperationInfo(representation, (CreateArtifactOperation)operation) : null;
    }

    public static EditCreateArtifactFromElementsOperationInfo isEditCreateArtifactFromElementsOperationPossible(ArchitecturalViewOperation operation, ExplorationViewRepresentation representation) {
        assert (operation != null) : "Parameter 'operation' of method 'isEditCreateArtifactFromElementsOperationPossible' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'isEditCreateArtifactFromElementsOperationPossible' must not be null";
        return operation instanceof CreateArtifactFromElementsOperation ? new EditCreateArtifactFromElementsOperationInfo(representation, (CreateArtifactFromElementsOperation)operation) : null;
    }

    public static EditCreateArtifactsForElementsOperationInfo isEditCreateArtifactsForElementsOperationPossible(ArchitecturalViewOperation operation, ExplorationViewRepresentation representation) {
        assert (operation != null) : "Parameter 'operation' of method 'isEditCreateArtifactFromElementsOperationPossible' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'isEditCreateArtifactFromElementsOperationPossible' must not be null";
        return operation instanceof CreateArtifactsForElementsOperation ? new EditCreateArtifactsForElementsOperationInfo(representation, (CreateArtifactsForElementsOperation)operation) : null;
    }

    private static AssignableTargetInfo getAssignableTargetInfo(TargetParentOperation operation, ArchitecturalViewArtifactOperationAvailability availability, ExplorationViewRepresentation representation) {
        assert (operation != null) : "Parameter 'operation' of method 'getAssignableTargetInfo' must not be null";
        assert (availability != null) : "Parameter 'availability' of method 'getAssignableTargetInfo' must not be null";
        assert (availability.isAvailable());
        assert (representation != null) : "Parameter 'representation' of method 'getAssignableTargetInfo' must not be null";
        int targetPos = -1;
        IAssignableTarget targetParent = ArchitecturalViewElementResolver.resolve(operation.getTargetParent(), IAssignableTarget.class, representation, true);
        if (targetParent == null) {
            targetParent = availability.getAssignableTarget();
        } else {
            List<ArtifactNode> artifactNodeChildren;
            int targetPosFromOperation = operation.getTargetPos();
            if (targetPosFromOperation != -1 && targetPosFromOperation < (artifactNodeChildren = targetParent.getArchitecturalViewElement().getChildren(ArtifactNode.class)).size()) {
                targetPos = targetPosFromOperation;
            }
        }
        return new AssignableTargetInfo(targetParent, targetPos);
    }

    public static void startEditOperation(IWorkerContext workerContext, EditOperationInfo info) {
        assert (info != null) : "Parameter 'info' of method 'startEditOperation' must not be null";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'startEditOperation' must not be null";
        ExplorationViewRepresentation representation = info.getRepresentation();
        ArchitecturalViewFile file = representation.getParent(ArchitecturalViewFile.class, new Class[0]);
        assert (file != null) : "'file' of method 'startEditOperation' must not be null";
        ArchitecturalViewOperation operation = info.getOperation();
        LOGGER.debug("Start edit operation '" + info.getOperation().getClass().getName() + "'");
        representation.setInEditOperation(true);
        info.setFocusAndState(ModificationHandler.startModification(representation));
        OperationExecutor.applyOperations(workerContext, file, representation, operation.getIndex() - 1);
        ModificationHandler.finishModification(workerContext, representation, null, null, null, null);
        if (operation instanceof CreateArtifactOperation) {
            assert (info != null && info instanceof EditCreateArtifactOperationInfo) : "Unexpected class in method 'startEditOperation': " + String.valueOf(info);
            CreateArtifactOperation createArtifactOperation = (CreateArtifactOperation)operation;
            String targetParent = createArtifactOperation.getTargetParent();
            IAssignableTarget resolved = ArchitecturalViewElementResolver.resolve(targetParent, IAssignableTarget.class, representation, true);
            if (resolved == null) {
                resolved = representation;
            }
            ((EditCreateArtifactOperationInfo)info).setData(resolved, FilterHandler.createFilter(representation, createArtifactOperation.getManualFilter()));
        } else if (operation instanceof CreateArtifactFromElementsOperation) {
            CreateArtifactFromElementsOperation createArtifactFromElementsOperation;
            List<ProgrammingElementAggregatingNode> elements;
            assert (info != null && info instanceof EditCreateArtifactFromElementsOperationInfo) : "Unexpected class in method 'startEditOperation': " + String.valueOf(info);
            if (PresentationMode.HIERARCHICAL != representation.getPresentationMode()) {
                OperationHandler.changePresentationMode(EditCreateArtifactFromElementsOperationInfo.DEFAULT_PRESENTATION_MODE, representation);
            }
            if ((elements = ArchitecturalViewElementResolver.resolve((createArtifactFromElementsOperation = (CreateArtifactFromElementsOperation)operation).getFromElements(), ProgrammingElementAggregatingNode.class, representation, true)).isEmpty()) {
                ProgrammingElementAggregatingNode first = representation.getFirstChild(ProgrammingElementAggregatingNode.class);
                assert (first != null) : "'first' of method 'startEditOperation' must not be null";
                elements.add(first);
            }
            assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'startEditOperation' must not be empty";
            ArchitecturalViewArtifactOperationAvailability availability = ArtifactHandler.isCreateArtifactFromElementsPossible(representation.getPresentationMode(), elements);
            assert (availability.isAvailable()) : "Not available: " + String.valueOf(availability);
            ((EditCreateArtifactFromElementsOperationInfo)info).setData(EditOperationHandler.getAssignableTargetInfo(createArtifactFromElementsOperation, availability, representation), availability.getIgnoreSubTrees(), elements);
        } else if (operation instanceof CreateArtifactsForElementsOperation) {
            List<AssignableNode> elements;
            assert (info != null && info instanceof EditCreateArtifactsForElementsOperationInfo) : "Unexpected class in method 'startEditOperation': " + String.valueOf(info);
            CreateArtifactsForElementsOperation createArtifactsForElementsOperation = (CreateArtifactsForElementsOperation)operation;
            PresentationMode presentationModeFromOperation = createArtifactsForElementsOperation.getPresentationMode();
            if (!presentationModeFromOperation.equals((Object)representation.getPresentationMode())) {
                OperationHandler.changePresentationMode(presentationModeFromOperation, representation);
            }
            if ((elements = ArchitecturalViewElementResolver.resolve(createArtifactsForElementsOperation.getForElements(), AssignableNode.class, representation, true)).isEmpty()) {
                AssignableNode first = representation.getFirstChild(AssignableNode.class);
                if (first == null) {
                    first = representation.getFirstChildRecursively(NamedElement.ACCEPT_ALL, AssignableNode.class, new Class[0]);
                }
                assert (first != null) : "'first' of method 'startEditOperation' must not be null";
                elements.add(first);
            }
            assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'startEditOperation' must not be empty";
            ArchitecturalViewArtifactOperationAvailability availability = ArtifactHandler.isCreateArtifactsForElementsPossible(representation.getPresentationMode(), elements);
            assert (availability.isAvailable()) : "Not available: " + String.valueOf(availability);
            ((EditCreateArtifactsForElementsOperationInfo)info).setData(EditOperationHandler.getAssignableTargetInfo(createArtifactsForElementsOperation, availability, representation), availability.getIgnoreSubTrees(), elements);
        } else assert (false) : "Unhandled operation: " + String.valueOf(operation);
        LOGGER.debug("Start edit operation '" + info.getOperation().getClass().getName() + "' - done");
    }

    public static void setPresentationModeInEditOperation(EditOperationInfo info, PresentationMode presentationMode) {
        assert (info != null) : "Parameter 'info' of method 'setPresentationModeInEditCreateArtifactsForElementsOperation' must not be null";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'setPresentationModeInEditCreateArtifactsForElementsOperation' must not be null";
        ExplorationViewRepresentation representation = info.getRepresentation();
        assert (!representation.getPresentationMode().equals((Object)presentationMode)) : "Presentation mode already set";
        LOGGER.debug("Switching presentation mode in edit '" + info.getOperation().getClass().getName() + "' to '" + String.valueOf((Object)presentationMode) + "'");
        OperationHandler.changePresentationMode(presentationMode, representation);
        LOGGER.debug("Switching presentation mode in edit '" + info.getOperation().getClass().getName() + "' to '" + String.valueOf((Object)presentationMode) + "' - done");
        if (info instanceof EditCreateArtifactsForElementsOperationInfo) {
            ((EditCreateArtifactsForElementsOperationInfo)info).setPresentationModeToBeSetInOperation(presentationMode);
        } else if (!(info instanceof EditCreateArtifactFromElementsOperationInfo)) assert (false) : "Presentation mode switch not supported for: " + info.getClass().getName();
    }

    public static ArchitecturalViewFile finishEditOperation(IWorkerContext workerContext, EditOperationInfo info) {
        assert (info != null) : "Parameter 'info' of method 'finishEditOperation' must not be null";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'finishEditOperation' must not be null";
        LOGGER.debug("Finish edit operation '" + info.getOperation().getClass().getName() + "'");
        ExplorationViewRepresentation representation = info.getRepresentation();
        ArchitecturalViewFile file = representation.getParent(ArchitecturalViewFile.class, new Class[0]);
        assert (file != null) : "'file' of method 'startEditOperation' must not be null";
        ModificationHandler.startModification(representation);
        OperationExecutor.applyOperations(workerContext, file, representation);
        Pair<ExplorationViewFocus, ArchitecturalViewState> focusAndState = info.getFocusAndState();
        ModificationHandler.finishModification(workerContext, representation, (ExplorationViewFocus)focusAndState.getFirst(), (ArchitecturalViewState)focusAndState.getSecond(), null, null);
        PresentationMode presentationMode = info.getPresentationModeOnStartEditOperation();
        if (!presentationMode.equals((Object)representation.getPresentationMode())) {
            LOGGER.debug("Switching back to presentation mode '" + String.valueOf((Object)presentationMode) + "'");
            OperationHandler.changePresentationMode(presentationMode, representation);
            LOGGER.debug("Switching back to presentation mode '" + String.valueOf((Object)presentationMode) + "' - done");
        }
        representation.setInEditOperation(false);
        LOGGER.debug("Finish edit operation '" + info.getOperation().getClass().getName() + "' - done");
        return file;
    }
}

