/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.diff;

import com.hello2morrow.sonargraph.core.controller.system.diff.AbstractDiffProcessor;
import com.hello2morrow.sonargraph.core.controller.system.diff.IResolutionChangeProvider;
import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionKind;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.IIssueDiff;
import com.hello2morrow.sonargraph.foundation.utilities.Iso8601DateFormat;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.integration.access.controller.ISystemInfoProcessor;
import com.hello2morrow.sonargraph.integration.access.model.IIssue;
import com.hello2morrow.sonargraph.integration.access.model.IResolution;
import com.hello2morrow.sonargraph.integration.access.model.ISoftwareSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

abstract class AbstractIssueDiffProcessor<B extends IIssue, C extends Issue>
extends AbstractDiffProcessor
implements IResolutionChangeProvider<B, C> {
    private final Class<B> m_baselineIssueClass;
    private final Class<C> m_currentIssueClass;
    private final Set<Issue> m_allCurrentIssues;
    private final Map<NamedElement, String> m_namedElementToFqNameCache;
    private final Set<IIssue> m_allBaselineIssues;

    public AbstractIssueDiffProcessor(ISoftwareSystem baselineSystem, ISystemInfoProcessor baselineSystemInfoProcessor, Set<IIssue> allBaselineIssues, SoftwareSystem currentSystem, Set<Issue> allCurrentIssues, Map<NamedElement, String> namedElementToFqNameCache, Class<B> baselineIssueClass, Class<C> currentIssueClass) {
        super(baselineSystem, baselineSystemInfoProcessor, currentSystem);
        this.m_allBaselineIssues = allBaselineIssues;
        this.m_allCurrentIssues = allCurrentIssues;
        this.m_namedElementToFqNameCache = namedElementToFqNameCache;
        this.m_baselineIssueClass = baselineIssueClass;
        this.m_currentIssueClass = currentIssueClass;
    }

    @Override
    public final void process(NamedElement parent) {
        assert (parent != null) : "Parameter 'parent' of method 'process' must not be null";
        ArrayList<B> baselineIssues = new ArrayList<B>(this.getBaselineIssues(this.getBaselineSystemInfoProcessor(), this.getAdditionalBaselineFilter()));
        ArrayList<C> currentIssues = new ArrayList<C>(this.getCurrentIssues(this.getAdditionalCurrentFilter()));
        Collections.sort(baselineIssues, new ISystemInfoProcessor.IIssueComparator());
        Collections.sort(currentIssues, new IssueComparator());
        this.computeDiffs(parent, baselineIssues, currentIssues);
        this.m_allBaselineIssues.removeAll(baselineIssues);
        this.m_allCurrentIssues.removeAll(currentIssues);
    }

    protected final List<B> getBaselineIssues(ISystemInfoProcessor systemInfoProcessor, Predicate<B> filter) {
        assert (systemInfoProcessor != null) : "Parameter 'systemInfoProcessor' of method 'getBaselineIssues' must not be null";
        assert (filter != null) : "Parameter 'filter' of method 'getBaselineIssues' must not be null";
        Set toleratedIssueCategoryNames = this.getToleratedIssueCategories().stream().map(cat -> cat.getStandardName()).collect(Collectors.toSet());
        Set ignoredIssueCategoryNames = this.getIgnoredIssueCategories().stream().map(cat -> cat.getStandardName()).collect(Collectors.toSet());
        List baselineIssues = systemInfoProcessor.getIssues(this.m_allBaselineIssues, i -> {
            if (!this.m_baselineIssueClass.isAssignableFrom(i.getClass())) {
                return false;
            }
            IIssue baselineIssue = i;
            if (!filter.test(baselineIssue)) {
                return false;
            }
            assert (this.m_baselineIssueClass.isAssignableFrom(i.getClass())) : "Filtering incomplete, unexpected baseline issue type detected: " + i.getClass().getCanonicalName();
            String categoryName = baselineIssue.getIssueType().getCategory().getName();
            if (toleratedIssueCategoryNames.size() > 0 && !toleratedIssueCategoryNames.contains(categoryName)) {
                return false;
            }
            boolean tolerated = !ignoredIssueCategoryNames.contains(categoryName);
            return tolerated;
        });
        List matchingBaselineIssues = baselineIssues.stream().map(i -> i).collect(Collectors.toList());
        return matchingBaselineIssues;
    }

    protected final List<C> getCurrentIssues(Predicate<C> filter) {
        assert (filter != null) : "Parameter 'filter' of method 'getCurrentIssues' must not be null";
        List currentIssues = this.m_allCurrentIssues.stream().filter(i -> {
            if (!this.m_currentIssueClass.isAssignableFrom(i.getClass())) {
                return false;
            }
            Issue currentIssue = i;
            if (!filter.test(currentIssue)) {
                return false;
            }
            assert (this.m_currentIssueClass.isAssignableFrom(i.getClass())) : "Filtering incomplete, unexpected current issue type detected: " + i.getClass().getCanonicalName();
            IssueCategory issueCategory = currentIssue.getId().getCategory();
            if (this.getToleratedIssueCategories().size() > 0 && !this.getToleratedIssueCategories().contains((Object)issueCategory)) {
                return false;
            }
            return !this.getIgnoredIssueCategories().contains((Object)issueCategory);
        }).collect(Collectors.toList());
        List matchingCurrentIssues = currentIssues.stream().map(i -> i).collect(Collectors.toList());
        return matchingCurrentIssues;
    }

    protected Predicate<B> getAdditionalBaselineFilter() {
        return i -> true;
    }

    protected Predicate<C> getAdditionalCurrentFilter() {
        return i -> true;
    }

    protected Set<IssueCategory> getIgnoredIssueCategories() {
        return Collections.emptySet();
    }

    protected Set<IssueCategory> getToleratedIssueCategories() {
        return Collections.emptySet();
    }

    public final String getOrCreateFqNameFromCachedElement(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'getOrCreateFqNameFromCachedElement' must not be null";
        String originalFqName = this.m_namedElementToFqNameCache.get(namedElement);
        if (originalFqName == null) {
            originalFqName = namedElement.getOriginalFullyQualifiedName();
            this.m_namedElementToFqNameCache.put(namedElement, originalFqName);
        }
        return originalFqName;
    }

    protected abstract void computeDiffs(NamedElement var1, List<B> var2, List<C> var3);

    @Override
    public final Pair<IDiffElement.Change, String> determineResolutionChange(B baselineIssue, C currentIssue) {
        assert (baselineIssue != null) : "Parameter 'baselineIssue' of method 'determineResolutionChange' must not be null";
        assert (currentIssue != null) : "Parameter 'currentIssue' of method 'determineResolutionChange' must not be null";
        com.hello2morrow.sonargraph.core.model.element.IResolution currentResolution = ((Issue)currentIssue).getResolution();
        if (!baselineIssue.hasResolution() && currentResolution == null) {
            return new Pair((Object)IDiffElement.Change.UNMODIFIED, (Object)"");
        }
        if (!baselineIssue.hasResolution() && currentResolution != null) {
            assert (currentResolution != null && currentResolution instanceof Resolution) : "Unexpected class in method 'determineResolutionChange': " + String.valueOf(currentResolution);
            Resolution resolution = (Resolution)currentResolution;
            StringBuilder description = new StringBuilder("Resolution added: ");
            description.append(this.createResolutionDescription(resolution.getKind().getPresentationName(), resolution.getPriority().getPresentationName(), resolution.getAssignee(), Iso8601DateFormat.formatDateAndTime((Date)resolution.getDate())));
            description.append(" ");
            return new Pair((Object)IDiffElement.Change.RESOLUTION_ADDED, (Object)description.toString());
        }
        IResolution baselineResolution = this.getBaselineSystemInfoProcessor().getResolution(baselineIssue);
        String baselineType = baselineResolution.getType().getPresentationName();
        if (baselineIssue.hasResolution() && currentResolution == null) {
            StringBuilder description = new StringBuilder("Resolution removed: ");
            description.append(this.createResolutionDescription(baselineType, baselineResolution.getPriority().getPresentationName(), baselineResolution.getAssignee(), baselineResolution.getDate()));
            description.append(" ");
            return new Pair((Object)IDiffElement.Change.RESOLUTION_REMOVED, (Object)description.toString());
        }
        if (baselineIssue.hasResolution() && currentResolution != null) {
            assert (currentResolution != null && currentResolution instanceof Resolution) : "Unexpected class in method 'determineResolutionChange': " + String.valueOf(currentResolution);
            Resolution resolution = (Resolution)currentResolution;
            ResolutionKind baselineKind = IIssueDiff.convertResolutionType(baselineResolution.getType());
            if (baselineKind == resolution.getKind()) {
                return new Pair((Object)IDiffElement.Change.UNMODIFIED, (Object)"");
            }
            StringBuilder description = new StringBuilder("");
            description.append(baselineKind.getPresentationName());
            description.append(" -> ");
            description.append(resolution.getKind().getPresentationName());
            return new Pair((Object)IDiffElement.Change.MODIFIED, (Object)description.toString());
        }
        assert (false) : "Not expected to be reached. All cases should have been handled above for baselineResolution '" + String.valueOf(baselineResolution) + "', currentResolution '" + String.valueOf(currentResolution) + "'";
        return null;
    }

    protected String createResolutionDescription(String kind, String priority, String assignee, String created) {
        StringBuilder description = new StringBuilder();
        description.append(kind);
        description.append(" [");
        description.append("Priority: ").append(priority).append(", ");
        if (!assignee.isEmpty()) {
            description.append("Assignee: ").append(assignee).append(", ");
        }
        description.append("Created: ").append(created);
        description.append("]");
        return description.toString();
    }

    protected static final class IssueComparator
    implements Comparator<Issue> {
        @Override
        public int compare(Issue i1, Issue i2) {
            assert (i1 != null) : "Parameter 'i1' of method 'compare' must not be null";
            assert (i2 != null) : "Parameter 'i2' of method 'compare' must not be null";
            if (i1 == i2) {
                return 0;
            }
            int compared = Integer.compare(i1.getLineNumber(), i2.getLineNumber());
            if (compared == 0 && (compared = Integer.compare(i1.getColumn(), i2.getColumn())) == 0 && (compared = i1.getName().compareToIgnoreCase(i2.getName())) == 0) {
                compared = Integer.compare(i1.hashCode(), i2.hashCode());
            }
            return compared;
        }
    }
}

