/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.api;

import com.hello2morrow.sonargraph.core.api.controller.IBaseVisitor;
import com.hello2morrow.sonargraph.core.api.model.ElementAccess;
import com.hello2morrow.sonargraph.core.controller.system.api.ElementClosure;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class BaseVisitor
extends NamedElementVisitor
implements IBaseVisitor {
    private final List<ElementClosure> m_closures = new ArrayList<ElementClosure>();
    private final ElementAccess.IAccessFactory m_factory;

    public BaseVisitor(ElementAccess.IAccessFactory factory) {
        assert (factory != null) : "Parameter 'factory' of method 'BaseVisitor' must not be null";
        this.m_factory = factory;
    }

    protected void addClosure(Class<?> cls, Closure<?> closure) {
        this.m_closures.add(new ElementClosure(this.m_factory, cls, closure));
        HashMap<String, BaseVisitor> extraVariables = new HashMap<String, BaseVisitor>(2);
        extraVariables.put("visitor", this);
        extraVariables.put("thisVisitor", this);
        closure.setDelegate(extraVariables);
    }

    protected boolean executeMatching(ElementAccess<? extends NamedElement> elementAccess) {
        assert (elementAccess != null) : "Parameter 'elementAccess' of method 'executeMatching' must not be null";
        Class<?> modelClass = elementAccess.getElement().getClass();
        boolean atLeastOneExecuted = false;
        for (ElementClosure nextElementClosure : this.m_closures) {
            if (!nextElementClosure.matches(modelClass)) continue;
            nextElementClosure.execute(elementAccess);
            atLeastOneExecuted = true;
        }
        return atLeastOneExecuted;
    }

    protected boolean executeMatching(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'executeMatching' must not be null";
        Class<?> modelClass = element.getClass();
        boolean atLeastOneExecuted = false;
        for (ElementClosure nextElementClosure : this.m_closures) {
            if (!nextElementClosure.matches(modelClass)) continue;
            nextElementClosure.execute(element);
            atLeastOneExecuted = true;
        }
        return atLeastOneExecuted;
    }

    @Override
    public final boolean callElementClosures(ElementAccess<? extends NamedElement> elementAccess) {
        return elementAccess != null ? this.executeMatching(elementAccess) : false;
    }

    @Override
    public final void visitNamedElement(NamedElement element) {
        if (!this.executeMatching(element)) {
            this.visitChildrenOf(element);
        }
    }

    @Override
    public void visitChildrenOf(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitChildrenOf' must not be null";
        if (element instanceof LogicalNamespace || element instanceof LogicalProgrammingElement) {
            for (NamedElement namedElement : element.getAllChildren()) {
                namedElement.accept(this);
            }
        } else {
            super.visitChildrenOf(element);
        }
    }

    @Override
    public final void visitChildren(ElementAccess<? extends NamedElement> accessObject) {
        if (accessObject != null) {
            this.visitChildrenOf(accessObject.getElement());
        }
    }

    @Override
    public final void removeAllClosures() {
        this.m_closures.clear();
    }
}

