/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.base;

import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerResultReader;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerResultWriter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerResultConsumer;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IThresholdController;
import com.hello2morrow.sonargraph.core.controller.system.base.IMetricAwareLanguageProvider;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.analysis.Analyzer;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfigurationFile;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerJobElement;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerState;
import com.hello2morrow.sonargraph.core.model.analysis.Analyzers;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricThreshold;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.core.model.analysis.MetricProvider;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerResultAvailableEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerResultStateChangedEvent;
import com.hello2morrow.sonargraph.core.model.metrics.FloatValueList;
import com.hello2morrow.sonargraph.core.model.metrics.IntegerValueList;
import com.hello2morrow.sonargraph.core.model.metrics.MetricDescriptor;
import com.hello2morrow.sonargraph.core.model.metrics.MetricValue;
import com.hello2morrow.sonargraph.core.model.metrics.ValueList;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.resolution.IssueFilter;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemMode;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import com.hello2morrow.sonargraph.foundation.event.Event;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.persistence.RestoreException;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AnalyzerAdapter
implements IAnalyzerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalyzerAdapter.class);
    private final Set<IMetricDescriptor> m_metricDescriptors = new LinkedHashSet<IMetricDescriptor>();
    private final Map<IMetricDescriptor, List<ValueList>> m_metricDescriptorToValueList = new THashMap();
    private final Set<AnalyzerAdapter> m_dependsUponAdapters = new THashSet();
    private final IAnalyzerController m_controller;
    private final Analyzer m_analyzer;
    private IAnalyzerResultConsumer m_consumer;
    private IThresholdController m_thresholdController;
    private Map<IMetricDescriptor, IMetricThreshold> m_thresholdMap;
    private Throwable m_threadCreationInfo;
    private boolean m_metricValueAdded;
    private boolean m_metricDescriptorAdded;
    private boolean m_readFromSnapshot;
    private long m_lastModifiedTimestamp = -1L;

    protected AnalyzerAdapter(IAnalyzerController controller, IConfigurableAnalyzerId analyzerId) {
        assert (controller != null) : "Parameter 'controller' of method 'AnalysisAdapter' must not be null";
        assert (analyzerId != null) : "Parameter 'analyzerId' of method 'AnalysisAdapter' must not be null";
        this.m_controller = controller;
        Analyzers analyzers = controller.getSoftwareSystem().getUniqueExistingChild(Files.class).getAnalyzers();
        Analyzer analyzer = null;
        for (Analyzer nextAnalyzer : analyzers.getChildren(Analyzer.class)) {
            if (!nextAnalyzer.getId().equals(analyzerId)) continue;
            analyzer = nextAnalyzer;
            break;
        }
        assert (analyzer != null) : "'analyzer' of method 'AnalysisAdapter' must not be null";
        this.m_analyzer = analyzer;
    }

    protected final List<AnalyzerResult> getRequiredResults() {
        ArrayList<AnalyzerResult> requiredResults = new ArrayList<AnalyzerResult>();
        for (AnalyzerAdapter next : this.m_dependsUponAdapters) {
            AnalyzerResult analyzerResult = this.getController().getResultFor(next.getAnalyzerId());
            if (analyzerResult == null) continue;
            requiredResults.add(analyzerResult);
        }
        return requiredResults;
    }

    public final void addDependsUponAdapter(AnalyzerAdapter adapter) {
        assert (adapter != null) : "Parameter 'adapter' of method 'addDependingAdapter' must not be null";
        if (this != adapter) {
            this.m_dependsUponAdapters.add(adapter);
        }
    }

    public final Set<AnalyzerAdapter> getDependsUponAdapters() {
        return Collections.unmodifiableSet(this.m_dependsUponAdapters);
    }

    public final void clearDependsUpon() {
        this.m_dependsUponAdapters.clear();
    }

    protected final IAnalyzerController getController() {
        return this.m_controller;
    }

    protected final Installation getInstallation() {
        return this.m_controller.getInstallation();
    }

    protected final SoftwareSystem getSoftwareSystem() {
        return this.m_controller.getSoftwareSystem();
    }

    protected final VirtualModel getCurrentModel() {
        VirtualModel vm = this.getSoftwareSystem().getCurrentModel(VirtualModel.class);
        assert (vm != null) : "Parameter 'vm' of method 'getCurrentModel' must not be null";
        return vm;
    }

    protected final IThresholdController getThresholdController() {
        if (this.m_thresholdController == null) {
            this.m_thresholdController = this.getSoftwareSystem().getExtension(IThresholdController.class);
            assert (this.m_thresholdController != null) : "'m_thresholdController' of method 'getThresholdController' must not be null";
        }
        return this.m_thresholdController;
    }

    protected final void checkValue(IMetricThreshold th, IMetricValue value) {
        assert (th != null) : "Parameter 'th' of method 'checkValue' must not be null";
        assert (value != null) : "Parameter 'value' of method 'checkValue' must not be null";
        this.getThresholdController().checkValueOfAnalyzerBasedMetricValue(th, value);
    }

    protected final void metricValueAdded() {
        this.m_metricValueAdded = true;
    }

    protected final void metricDescriptorAdded() {
        this.m_metricDescriptorAdded = true;
    }

    @Override
    public final void storeMetricValue(AnalyzerResult result, NamedElement element, Number value, IMetricDescriptor descriptor) {
        assert (result != null) : "Parameter 'result' of method 'storeMetricValue' must not be null";
        assert (value != null) : "Parameter 'value' of method 'storeMetricValue' must not be null";
        assert (element != null) : "Parameter 'element' of method 'storeMetricValue' must not be null";
        assert (descriptor != null) : "Parameter 'descriptor' of method 'storeMetricValue' must not be null";
        assert (this.m_thresholdMap != null) : "'m_thresholdMap' of method 'storeMetricValue' must not be null";
        MetricValue metricValue = new MetricValue(result, element, value, descriptor);
        result.addChild(metricValue);
        IMetricThreshold th = this.m_thresholdMap.get(descriptor);
        if (th != null) {
            this.checkValue(th, metricValue);
        }
        this.metricValueAdded();
    }

    public final IConfigurableAnalyzerId getAnalyzerId() {
        return this.m_analyzer.getId();
    }

    public final Analyzer getAnalyzer() {
        return this.m_analyzer;
    }

    public final AnalyzerGroup getGroup() {
        return this.m_analyzer.getId().getGroup();
    }

    private void setConsumer(IAnalyzerResultConsumer consumer) {
        this.m_consumer = consumer;
    }

    protected final IMetricDescriptor findMetricDescriptor(MetricProvider metricProvider, IMetricId id, IMetricLevel level) {
        assert (metricProvider != null) : "Parameter 'metricProvider' of method 'findMetricDescriptor' must not be null";
        assert (id != null) : "Parameter 'id' of method 'findMetricDescriptor' must not be null";
        assert (level != null) : "Parameter 'level' of method 'findMetricDescriptor' must not be null";
        for (IMetricDescriptor nextMetricDescriptor : metricProvider.getChildren(IMetricDescriptor.class)) {
            if (nextMetricDescriptor.getMetricId() != id || nextMetricDescriptor.getLevel() != level) continue;
            return nextMetricDescriptor;
        }
        return null;
    }

    protected final IMetricDescriptor addMetricDescriptorIfNotExistent(MetricProvider mp, IMetricId id, IMetricLevel level, Predicate<NamedElement> elementFilter, Language language) {
        assert (mp != null) : "Parameter 'mp' of method 'addMetricDescriptorIfNotExistent' must not be null";
        assert (id != null) : "Parameter 'id' of method 'addMetricDescriptorIfNotExistent' must not be null";
        assert (level != null) : "Parameter 'level' of method 'addMetricDescriptorIfNotExistent' must not be null";
        IMetricDescriptor descriptor = this.findMetricDescriptor(mp, id, level);
        if (descriptor == null) {
            MetricDescriptor md = new MetricDescriptor(mp, id, level, this.getAnalyzer().getId(), elementFilter, language);
            descriptor = md;
            mp.addChild(md);
        }
        this.m_metricDescriptors.add(descriptor);
        return descriptor;
    }

    protected final IMetricDescriptor addMetricDescriptorIfNotExistent(MetricProvider mp, IMetricId id, IMetricLevel level, Predicate<NamedElement> elementFilter) {
        assert (mp != null) : "Parameter 'mp' of method 'addMetricDescriptorIfNotExistent' must not be null";
        assert (id != null) : "Parameter 'id' of method 'addMetricDescriptorIfNotExistent' must not be null";
        assert (level != null) : "Parameter 'level' of method 'addMetricDescriptorIfNotExistent' must not be null";
        return this.addMetricDescriptorIfNotExistent(mp, id, level, elementFilter, mp.getLanguage());
    }

    protected final IMetricDescriptor addMetricDescriptorIfNotExistent(MetricProvider mp, IMetricId id, IMetricLevel level) {
        assert (mp != null) : "Parameter 'mp' of method 'addMetricDescriptorIfNotExistent' must not be null";
        assert (id != null) : "Parameter 'id' of method 'addMetricDescriptorIfNotExistent' must not be null";
        assert (level != null) : "Parameter 'level' of method 'addMetricDescriptorIfNotExistent' must not be null";
        return this.addMetricDescriptorIfNotExistent(mp, id, level, null, mp.getLanguage());
    }

    protected final void addMetricDescriptor(IMetricDescriptor md) {
        assert (md != null) : "Parameter 'md' of method 'addMetricDescriptor' must not be null";
        this.m_metricDescriptors.add(md);
    }

    protected final ValueList createValueList(AnalyzerResult result, IMetricDescriptor descriptor, NamedElement root) {
        assert (result != null) : "Parameter 'result' of method 'createValueList' must not be null";
        assert (descriptor != null) : "Parameter 'descriptor' of method 'createValueList' must not be null";
        assert (this.m_metricDescriptors.contains(descriptor)) : "Unknown metric descriptor: " + String.valueOf(descriptor);
        ValueList valueList = descriptor.isFloat() ? new FloatValueList(result, descriptor) : new IntegerValueList(result, descriptor, root);
        result.addChild(valueList);
        List<ValueList> valueLists = this.m_metricDescriptorToValueList.get(descriptor);
        if (valueLists == null) {
            valueLists = new ArrayList<ValueList>();
            this.m_metricDescriptorToValueList.put(descriptor, valueLists);
        }
        valueLists.add(valueList);
        this.metricValueAdded();
        return valueList;
    }

    protected boolean clearResult(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'clearResult' must not be null";
        LOGGER.debug("AnalyzerAdapter.clearResult(result) : " + String.valueOf(this.getAnalyzerId()));
        IssueFilter filter = this.getIssueFilter(result);
        if (filter != null && !filter.isEmpty()) {
            this.getCurrentModel().removeElementIssues(issue -> filter.accept((Issue)issue));
        }
        this.getThresholdController().removeThresholdViolationsFor(this.m_metricDescriptors);
        boolean reset = result.clear();
        this.m_metricValueAdded = false;
        this.m_metricDescriptorAdded = false;
        return reset;
    }

    protected List<IIssueId> getIssueIds(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'getIssueIds' must not be null";
        return Collections.emptyList();
    }

    protected IssueFilter getIssueFilter(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'getIssueFilter' must not be null";
        IssueFilter filter = new IssueFilter(new IStandardEnumeration[0]);
        this.getIssueIds(result).stream().filter(id -> id != CoreIssueId.THRESHOLD_VIOLATION).forEach(id -> filter.add(id));
        filter.addIgnore(issue -> issue.getId() == CoreIssueId.THRESHOLD_VIOLATION);
        return filter;
    }

    private List<Issue> getIssues(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'getIssues' must not be null";
        IssueFilter filter = this.getIssueFilter(result);
        if (filter == null || filter.isEmpty()) {
            return Collections.emptyList();
        }
        return this.getCurrentModel().getIssueList(filter).getIssues();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean reset() {
        AnalyzerResult result;
        LOGGER.debug("AnalyzerAdapter.reset(result) : " + String.valueOf(this.getAnalyzerId()));
        AnalyzerResult analyzerResult = result = this.m_analyzer.getResult();
        synchronized (analyzerResult) {
            switch (result.getState()) {
                case FINISHED: 
                case INACTIVE: 
                case ERROR: 
                case CANCELLED: {
                    boolean isReset = this.clearResult(result);
                    result.removeChildren(new Class[0]);
                    result.resetFrozen();
                    result.setState(AnalyzerState.HAS_NOT_BEEN_RUN);
                    result.notifyAll();
                    return isReset;
                }
                case HAS_NOT_BEEN_RUN: {
                    break;
                }
                case RUNNING: {
                    assert (false) : String.valueOf(this.getAnalyzerId()) + " is still running: " + String.valueOf(result);
                    break;
                }
                default: {
                    assert (false) : "Unhandled state: " + String.valueOf((Object)result.getState());
                    break;
                }
            }
        }
        return false;
    }

    protected abstract void runJobs(AnalyzerResult var1);

    protected void finished(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'finished' must not be null";
        if (this.canStoreResult() && !this.m_readFromSnapshot) {
            this.saveResult(result);
        }
        this.m_readFromSnapshot = false;
        this.m_lastModifiedTimestamp = -1L;
        result.finished();
    }

    protected AnalyzerResultWriter createWriter(AnalyzerResult result) {
        return new AnalyzerResultWriter(result, this.getController());
    }

    protected AnalyzerResultReader createReader(AnalyzerResult result) {
        return new AnalyzerResultReader(result, this.getController());
    }

    private TFile getAnalyzerResultFile(TFile dir) {
        return new TFile((File)dir, this.getAnalyzerId().getStandardName() + CoreFileType.SNAPSHOT.getDefaultExtension());
    }

    protected void saveResult(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'saveResult' must not be null";
        AnalyzerResultWriter writer = this.createWriter(result);
        TFile file = this.getAnalyzerResultFile(this.m_controller.getAnalyzerResultStorageDirectory());
        try {
            writer.storeChildrenAndAdditionalObjects(file, this.getIssues(result));
        }
        catch (Exception e) {
            LOGGER.error("Error while writing analyzer result: ", (Throwable)e);
        }
    }

    protected long getLastModifiedTimestamp() {
        AnalyzerConfigurationFile configFile = this.getController().getAnalyzerConfigurationFile(this.getAnalyzerId());
        long result = configFile != null && configFile.existsOnDisk() ? configFile.getFile().lastModified() : 0L;
        for (AnalyzerAdapter dependsUpon : this.m_dependsUponAdapters) {
            result = Long.max(result, dependsUpon.getLastModified());
        }
        return result;
    }

    private long getLastModified() {
        if (this.m_lastModifiedTimestamp == -1L) {
            this.m_lastModifiedTimestamp = this.getLastModifiedTimestamp();
        }
        return this.m_lastModifiedTimestamp;
    }

    protected void resultSuccessfullyRestored(AnalyzerResult result) throws RestoreException {
        assert (result != null) : "Parameter 'result' of method 'resultSuccessfullyRestored' must not be null";
    }

    private boolean readResult(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'readResult' must not be null";
        assert (this.canStoreResult());
        TFile file = this.getAnalyzerResultFile(this.m_controller.getAnalyzerResultReadDirectory());
        TFile datFile = new TFile((File)file, "model.dat");
        if (file.exists() && this.getLastModified() < datFile.lastModified()) {
            AnalyzerResultReader reader = this.createReader(result);
            try {
                reader.retrieve(file);
                result.finished();
                this.resultSuccessfullyRestored(result);
                this.m_readFromSnapshot = true;
                for (ValueList nextValueList : result.getChildren(ValueList.class)) {
                    List<ValueList> valueLists;
                    IMetricDescriptor nextListItemMetricDescriptor;
                    IMetricDescriptor nextValueMetricDescriptor = nextValueList.getValueMetricDescriptor();
                    if (nextValueMetricDescriptor != (nextListItemMetricDescriptor = nextValueList.getListItemMetricDescriptor())) {
                        LOGGER.warn("Different descriptors: " + String.valueOf(nextValueMetricDescriptor) + "/" + String.valueOf(nextListItemMetricDescriptor));
                    }
                    if ((valueLists = this.m_metricDescriptorToValueList.get(nextListItemMetricDescriptor)) == null) {
                        valueLists = new ArrayList<ValueList>();
                        this.m_metricDescriptorToValueList.put(nextListItemMetricDescriptor, valueLists);
                    }
                    valueLists.add(nextValueList);
                }
                for (MetricValue nextMetricValue : result.getChildren(MetricValue.class)) {
                    IMetricThreshold nextThreshold = this.m_thresholdMap.get(nextMetricValue.getMetricDescriptor());
                    if (nextThreshold == null) continue;
                    this.checkValue(nextThreshold, nextMetricValue);
                }
                return true;
            }
            catch (Throwable t) {
                LOGGER.warn("[" + this.getAnalyzer().getName() + "] failed to restore analyzer result from '" + file.getPath() + "'", t);
                result.forgetChildren(true);
            }
        }
        return false;
    }

    public boolean canStoreResult() {
        return false;
    }

    private void checkValueListThresholdViolations() {
        if (!this.m_metricDescriptorToValueList.isEmpty()) {
            Map<IMetricDescriptor, IMetricThreshold> thresholdMap = this.getThresholdController().getThresholdsFor(this.m_metricDescriptorToValueList.keySet());
            for (List<ValueList> nextLists : this.m_metricDescriptorToValueList.values()) {
                for (ValueList nextList : nextLists) {
                    IMetricDescriptor descriptor = nextList.getListItemMetricDescriptor();
                    IMetricThreshold th = thresholdMap.get(descriptor);
                    if (th == null) continue;
                    nextList.processValues(null, v -> this.checkValue(th, v));
                }
            }
            this.m_metricDescriptorToValueList.clear();
        }
    }

    public boolean isEnabled() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void run(boolean loadResultIfPresent, boolean canRun) {
        Object object;
        SoftwareSystem softwareSystem = this.getSoftwareSystem();
        AnalyzerResult result = this.m_analyzer.getResult();
        assert (result != null) : "Parameter 'result' of method 'run' must not be null";
        ISoftwareSystemProvider provider = softwareSystem.getExtension(ISoftwareSystemProvider.class);
        boolean resultLoaded = false;
        IConfigurableAnalyzerId analyzerId = this.getAnalyzerId();
        try {
            try {
                List<NamedElement> analyzerResultChildren = result.getChildrenList();
                for (NamedElement nextChild : analyzerResultChildren) {
                    LOGGER.error("Unexpected child of analyzer result '" + String.valueOf(analyzerId) + "': " + nextChild.getClass().getName());
                }
                assert (analyzerResultChildren.isEmpty()) : "Analyzer result not cleared: " + String.valueOf(analyzerId);
                assert (!this.m_metricValueAdded) : "Metric value added not reset: " + String.valueOf(analyzerId);
                assert (!this.m_metricDescriptorAdded) : "Metric descriptor added not reset: " + String.valueOf(analyzerId);
                EventManager.getInstance().dispatch((Object)this, (Event)new AnalyzerResultStateChangedEvent(provider, result, AnalyzerState.RUNNING));
                this.m_thresholdMap = this.getThresholdController().getThresholdsFor(this.m_metricDescriptors);
                boolean runJobs = true;
                if (this.canStoreResult() && loadResultIfPresent) {
                    resultLoaded = this.readResult(result);
                    boolean bl = runJobs = !resultLoaded;
                }
                if (runJobs && canRun) {
                    this.runJobs(result);
                    object = result;
                    synchronized (object) {
                        while (result.getNumberOfRunningJobs() > 0) {
                            result.wait();
                        }
                    }
                }
                this.checkValueListThresholdViolations();
                this.m_thresholdMap = null;
            }
            catch (Throwable t) {
                this.m_controller.jobControllerFinished(this.m_threadCreationInfo, this.m_analyzer.getId(), this.m_metricValueAdded, this.m_metricDescriptorAdded);
                AnalyzerResult runJobs = result;
                synchronized (runJobs) {
                    result.setState(AnalyzerState.CANCELLED);
                    result.notifyAll();
                }
                this.getController().exceptionCaught("Exception in AnalyzerAdapter.run() [1] in analyzer '" + analyzerId.getStandardName() + "'", t);
                LOGGER.error("Set state to CANCELLED because of exception for: " + String.valueOf(analyzerId), t);
                this.m_thresholdMap = null;
                return;
            }
        }
        finally {
            this.m_thresholdMap = null;
        }
        try {
            try {
                AnalyzerState newState;
                boolean cancelled = false;
                object = result;
                synchronized (object) {
                    if (result.getErrorMessage() == null && canRun) {
                        for (AnalyzerJobElement node : result.getChildren(AnalyzerJobElement.class)) {
                            AnalyzerState state = node.getState();
                            if (state == AnalyzerState.FINISHED) continue;
                            cancelled = true;
                            break;
                        }
                    }
                    if (cancelled) {
                        LOGGER.debug("Set state to CANCELLED for: " + String.valueOf(analyzerId) + " (not all analyzer job elements were finished)");
                        newState = AnalyzerState.CANCELLED;
                        result.setState(newState);
                    } else if (result.getErrorMessage() == null) {
                        if (canRun || resultLoaded) {
                            newState = AnalyzerState.FINISHED;
                            result.setState(newState);
                            this.finished(result);
                        } else {
                            newState = AnalyzerState.INACTIVE;
                            result.setState(newState);
                        }
                    } else {
                        newState = AnalyzerState.ERROR;
                        result.setState(newState);
                        cancelled = true;
                    }
                    result.notifyAll();
                }
                EventManager.getInstance().dispatch((Object)this, (Event)new AnalyzerResultStateChangedEvent(provider, result, newState));
                object = result;
                synchronized (object) {
                    for (AnalyzerJobElement job : result.getChildren(AnalyzerJobElement.class)) {
                        job.remove();
                    }
                    if (cancelled) {
                        result.clear();
                    }
                }
                if (!cancelled) {
                    EventManager.getInstance().dispatch((Object)this, (Event)new AnalyzerResultAvailableEvent(provider, result, this.m_consumer != null ? this.m_consumer.getOriginator() : null));
                    if (this.m_consumer != null) {
                        this.m_consumer.consume(result);
                    }
                }
            }
            catch (Throwable t) {
                this.getController().exceptionCaught("Exception in AnalyzerAdapter.run() [2] in analyzer '" + analyzerId.getStandardName() + "'", t);
                this.setConsumer(null);
                this.m_controller.jobControllerFinished(this.m_threadCreationInfo, this.m_analyzer.getId(), this.m_metricValueAdded, this.m_metricDescriptorAdded);
            }
        }
        finally {
            this.setConsumer(null);
            this.m_controller.jobControllerFinished(this.m_threadCreationInfo, this.m_analyzer.getId(), this.m_metricValueAdded, this.m_metricDescriptorAdded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean startJobsIfNotRunning(AnalyzerResult result, IAnalyzerResultConsumer consumer, boolean loadResultIfPresent) {
        assert (result != null) : "Parameter 'result' of method 'startJobsIfNotRunning' must not be null";
        if (!this.m_analyzer.getId().getExecutionLevel().matchesOrIsLowerThan(this.m_controller.getAnalyzerExecutionLevel()) || !this.isEnabled()) {
            return false;
        }
        boolean consume = false;
        boolean startJobController = false;
        AnalyzerResult analyzerResult = result;
        synchronized (analyzerResult) {
            AnalyzerState state = result.getState();
            assert (state != AnalyzerState.CANCELLED) : "Wrong state 'CANCELLED' for: " + String.valueOf(this.getAnalyzerId());
            if (state == AnalyzerState.HAS_NOT_BEEN_RUN) {
                SoftwareSystemMode mode = this.getController().getSoftwareSystem().getMode();
                boolean canRun = this.canRun();
                if (canRun || mode != SoftwareSystemMode.SYSTEM) {
                    if (LOGGER.isTraceEnabled()) {
                        this.m_threadCreationInfo = new Throwable();
                    }
                    Thread jobManager = new Thread(() -> this.run(loadResultIfPresent, canRun), "Manager: " + this.m_analyzer.getId().getPresentationName());
                    jobManager.setUncaughtExceptionHandler(this.m_controller);
                    startJobController = true;
                    result.setState(AnalyzerState.RUNNING);
                    this.setConsumer(consumer);
                    jobManager.start();
                } else {
                    result.setState(AnalyzerState.INACTIVE);
                    result.notifyAll();
                }
            } else if (state == AnalyzerState.RUNNING) {
                if (consumer != null) {
                    this.setConsumer(consumer);
                }
            } else if (consumer != null && state == AnalyzerState.FINISHED) {
                consume = true;
            }
        }
        if (startJobController) {
            this.m_controller.jobControllerStarted(this.m_analyzer.getId());
        }
        if (consume) {
            assert (consumer != null);
            consumer.consume(result);
        }
        return true;
    }

    protected boolean canRun() {
        return true;
    }

    public void aboutToBeRemoved() {
        if (!this.m_metricDescriptors.isEmpty()) {
            this.getThresholdController().aboutToBeRemoved(this.m_metricDescriptors);
        }
    }

    protected final void remove(Collection<IMetricDescriptor> metricDescriptors) {
        assert (metricDescriptors != null && !metricDescriptors.isEmpty()) : "Parameter 'metricDescriptors' of method 'remove' must not be empty";
        this.getThresholdController().aboutToBeRemoved(metricDescriptors);
        for (IMetricDescriptor nextMetricDescriptor : metricDescriptors) {
            boolean success = this.m_metricDescriptors.remove(nextMetricDescriptor);
            assert (success) : "'success' of method 'remove' must true";
            nextMetricDescriptor.getNamedElement().remove();
            this.m_metricDescriptorToValueList.remove(nextMetricDescriptor);
        }
    }

    public void languageAdded(IMetricAwareLanguageProvider languageProvider) {
        assert (languageProvider != null) : "Parameter 'languageProvider' of method 'languageAdded' must not be null";
    }

    public void languageRemoved(IMetricAwareLanguageProvider languageProvider) {
        assert (languageProvider != null) : "Parameter 'languageProvider' of method 'languageRemoved' must not be null";
    }

    public final String toString() {
        return this.m_analyzer.getName();
    }

    public void systemSavedAs(boolean baseDirectoryChanged) {
    }
}

