/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryDoesNotExist;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.RootPathNoReadPermission;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import de.schlichtherle.truezip.file.TFile;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RootDirectoryPathValidator
implements IPathValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(RootDirectoryPathValidator.class);
    private final List<Module> m_modules;
    private final IPathValidator.PathType m_pathType;
    private final Class<? extends RootDirectoryPath> m_clazz;

    public RootDirectoryPathValidator(List<Module> modules, IPathValidator.PathType pathType, Class<? extends RootDirectoryPath> clazz) {
        assert (modules != null && !modules.isEmpty()) : "Parameter 'modules' of method 'RootDirectoryPathValidator' must not be empty";
        assert (pathType != null) : "Parameter 'pathType' of method 'RootDirectoryPathValidator' must not be null";
        assert (pathType == IPathValidator.PathType.DIRECTORY || pathType == IPathValidator.PathType.ARCHIVE_OR_DIRECTORY) : "Unexpected root path type: " + String.valueOf((Object)pathType);
        assert (clazz != null) : "Parameter 'clazz' of method 'RootDirectoryPathValidator' must not be null";
        this.m_modules = new ArrayList<Module>(modules);
        this.m_pathType = pathType;
        this.m_clazz = clazz;
    }

    @Override
    public IPathValidator.PathType getType() {
        return this.m_pathType;
    }

    @Override
    public ValidationResult isValid(TFile currentInput, TFile newInput) {
        ValidationResult result = new ValidationResult(!FileUtility.areEqual((TFile)currentInput, (TFile)newInput));
        if (newInput == null || newInput.getPath().isEmpty()) {
            result.addError("Must not be empty");
        } else {
            if (!newInput.exists()) {
                result.addWarning("Root path does not exist");
            } else if (this.m_pathType == IPathValidator.PathType.ARCHIVE_OR_DIRECTORY) {
                if (!newInput.isDirectory() && !FileUtility.isArchive((TFile)newInput)) {
                    result.addWarning("Neither an archive nor a directory");
                }
            } else if (!newInput.isDirectory()) {
                result.addWarning("Not a directory");
            }
            for (Module nextModule : this.m_modules) {
                for (RootDirectoryPath rootDirectoryPath : nextModule.getChildren(this.m_clazz, true)) {
                    if (!FileUtility.areEqual((TFile)newInput, (TFile)rootDirectoryPath.getDirectoryFile())) continue;
                    result.addError("Root path already present in module: '" + nextModule.getName() + "'");
                }
            }
        }
        return result;
    }

    public static void removeIssues(RootDirectoryPath path) {
        assert (path != null) : "Parameter 'path' of method 'removeIssues' must not be null";
        path.removeIssues(CoreIssueId.ROOT_PATH_DOES_NOT_EXIST, CoreIssueId.ROOT_PATH_NO_READ_PERMISSION);
    }

    public static boolean validate(RootDirectoryPath path) {
        assert (path != null) : "Parameter 'path' of method 'validate' must not be null";
        RootDirectoryPathValidator.removeIssues(path);
        boolean result = true;
        try {
            TFile rootDir = path.getFile();
            if (rootDir.isDirectory()) {
                if (!rootDir.canRead()) {
                    path.addIssue(new RootPathNoReadPermission(path));
                    result = false;
                }
            } else {
                path.addIssue(new RootDirectoryDoesNotExist(path));
                result = false;
            }
        }
        catch (InvalidPathException ex) {
            LOGGER.error("Failed to validate path: ", (Throwable)ex);
            path.addIssue(new RootDirectoryDoesNotExist(path));
        }
        return result;
    }
}

