/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.foundation.common.base.RelevantSourceFile;
import com.hello2morrow.sonargraph.core.model.system.IRelevantSourceFileIterator;
import java.util.LinkedList;
import java.util.List;

public final class RelevantSoftwareSystemSourceFileIterator
implements IRelevantSourceFileIterator {
    private final LinkedList<IRelevantSourceFileIterator> m_iteratorQueue = new LinkedList();
    private final int m_totalNumberOfSourceFiles;
    private IRelevantSourceFileIterator m_currentIterator;

    public RelevantSoftwareSystemSourceFileIterator(List<IRelevantSourceFileIterator> iterators) {
        assert (iterators != null) : "Parameter 'iterators' of method 'RelevantSoftwareSystemSourceFileIterator' must not be null";
        int totalNumberOfSourceFiles = 0;
        if (!iterators.isEmpty()) {
            for (IRelevantSourceFileIterator nextIterator : iterators) {
                this.m_iteratorQueue.push(nextIterator);
                totalNumberOfSourceFiles += nextIterator.getTotalNumberOfRelevantSourceFiles();
            }
        }
        this.m_totalNumberOfSourceFiles = totalNumberOfSourceFiles;
    }

    @Override
    public boolean hasNext() {
        if (this.m_currentIterator == null) {
            while (!this.m_iteratorQueue.isEmpty() && this.m_currentIterator == null) {
                this.m_currentIterator = this.m_iteratorQueue.pop();
                if (this.m_currentIterator.hasNext()) continue;
                this.m_currentIterator = null;
            }
        }
        return this.m_currentIterator != null;
    }

    @Override
    public RelevantSourceFile next() {
        assert (this.m_currentIterator != null) : "Parameter 'm_currentIterator' of method 'next' must not be null";
        RelevantSourceFile next = (RelevantSourceFile)this.m_currentIterator.next();
        if (!this.m_currentIterator.hasNext()) {
            this.m_currentIterator = null;
        }
        return next;
    }

    @Override
    public void remove() {
        assert (false) : "Remove not supported";
    }

    @Override
    public int getTotalNumberOfRelevantSourceFiles() {
        return this.m_totalNumberOfSourceFiles;
    }
}

