/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.model.element.IRecursiveElement;
import com.hello2morrow.sonargraph.core.model.element.IRefactoringTarget;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementUtility;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MoveRenameElementCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoveRenameElementCheck.class);

    private MoveRenameElementCheck() {
    }

    public static boolean check(List<NamedElement> toBeMovedAndOrRenamed, NamedElement target, IConsumer consumer) {
        assert (toBeMovedAndOrRenamed != null && !toBeMovedAndOrRenamed.isEmpty()) : "Parameter 'toBeMovedAndOrRenamed' of method 'check' must not be empty";
        assert (consumer != null) : "Parameter 'consumer' of method 'check' must not be null";
        Map<NamedElement, NamedElement> childrenToParent = NamedElementUtility.detectChildren(toBeMovedAndOrRenamed);
        if (!childrenToParent.isEmpty()) {
            for (Map.Entry<NamedElement, NamedElement> nextEntry : childrenToParent.entrySet()) {
                consumer.elementsInvalid("Contains '" + nextEntry.getKey().getRawPresentationName(false) + "' and its parent '" + nextEntry.getValue().getRawPresentationName(false) + "'");
            }
            return false;
        }
        if (target != null) {
            LOGGER.debug("Check move refactoring elements");
            boolean elementsValid = true;
            for (NamedElement next : toBeMovedAndOrRenamed) {
                if (target == next) {
                    consumer.elementsInvalid("Target '" + next.getRawPresentationName(false) + "' contained in elements");
                    elementsValid = false;
                    continue;
                }
                if (!target.hasAsParent(next, false)) continue;
                consumer.elementsInvalid("'" + next.getRawPresentationName(false) + "' is a parent of '" + target.getRawPresentationName(false) + "'");
                elementsValid = false;
            }
            LOGGER.debug("Check move refactoring elements - done");
            return elementsValid;
        }
        return true;
    }

    public static boolean checkRecursiveElement(IRecursiveElement recursiveElement, String targetName, IRefactoringTarget targetParent, IConsumer consumer) {
        assert (recursiveElement != null) : "Parameter 'recursiveElement' of method 'checkRecursiveElement' must not be null";
        assert (targetName != null && targetName.length() > 0) : "Parameter 'targetName' of method 'checkRecursiveElement' must not be empty";
        assert (targetParent != null) : "Parameter 'targetParent' of method 'checkRecursiveElement' must not be null";
        assert (consumer != null) : "Parameter 'consumer' of method 'checkRecursiveElement' must not be null";
        NamedElement recursiveNamedElement = recursiveElement.getNamedElement();
        NamedElement targetParentNamedElement = targetParent.getNamedElement();
        String fromName = recursiveNamedElement.getRawPresentationName(false);
        Object toName = targetParentNamedElement instanceof IRecursiveElement ? targetParentNamedElement.getRawPresentationName(false) + recursiveElement.getSeparator() + targetName : targetName;
        LOGGER.debug("Check recursive element: " + recursiveNamedElement.getRawPresentationName(false) + ", target name: " + targetName + ", target parent: " + targetParentNamedElement.getRawPresentationName(false) + "['" + fromName + "' -> '" + (String)toName + "'");
        if (((String)toName).toLowerCase().equals(fromName.toLowerCase())) {
            String info = "Target '" + (String)toName + "' contained in elements";
            consumer.elementsInvalid(info);
            LOGGER.debug(info);
            return false;
        }
        if (((String)toName).toLowerCase().startsWith(fromName.toLowerCase() + recursiveElement.getSeparator())) {
            String info = "'" + fromName + "' is a parent of '" + (String)toName + "'";
            consumer.elementsInvalid(info);
            LOGGER.debug(info);
            return false;
        }
        return true;
    }

    public static interface IConsumer {
        public void elementsInvalid(String var1);
    }
}

