/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.ArchitectureExtension;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.PluginAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.base.IMetricAwareLanguageProvider;
import com.hello2morrow.sonargraph.core.model.analysis.ConfigurableAnalyzerIdComparator;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.LanguageBasedMetricProvider;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemMessageCause;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFile;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemFile;
import com.hello2morrow.sonargraph.core.model.plugin.PluginConfigurationFile;
import com.hello2morrow.sonargraph.core.model.script.FileBasedRunConfiguration;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.IAnalyzerProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.WorkspaceProfile;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapFile;
import com.hello2morrow.sonargraph.foundation.collections.MultipleValueMap;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.TrueZipFacade;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.set.hash.THashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AnalyzerAdapterUtitity {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalyzerAdapterUtitity.class);

    private AnalyzerAdapterUtitity() {
    }

    private static String discardPersistedAnalyzerResults(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'discardPersistedAnalyzerResults' must not be null";
        List<IModifiableFile> modifiableFilesNeedingSave = softwareSystem.getUniqueExistingChild(Files.class).getModifiableFilesNeedingSave();
        if (!modifiableFilesNeedingSave.isEmpty()) {
            TreeSet<IModifiableFile> unsavedRelevant = new TreeSet<IModifiableFile>(new Comparator<IModifiableFile>(){

                @Override
                public int compare(IModifiableFile f1, IModifiableFile f2) {
                    if (!$assertionsDisabled && f1 == null) {
                        throw new AssertionError((Object)"Parameter 'f1' of method 'compare' must not be null");
                    }
                    if (!$assertionsDisabled && f2 == null) {
                        throw new AssertionError((Object)"Parameter 'f2' of method 'compare' must not be null");
                    }
                    return f1.getIdentifyingPath().compareToIgnoreCase(f2.getIdentifyingPath());
                }
            });
            ArchitectureExtension architectureExtension = softwareSystem.getExtension(ArchitectureExtension.class);
            for (IModifiableFile next : modifiableFilesNeedingSave) {
                if (next instanceof TreeMapFile || next instanceof ArchitecturalViewFile || next instanceof WorkspaceProfile || next instanceof SoftwareSystemFile || next instanceof PluginConfigurationFile || next instanceof FileBasedRunConfiguration && !((FileBasedRunConfiguration)next).isAutomated()) continue;
                if (next instanceof ArchitectureFile) {
                    ArchitectureFile archFile = (ArchitectureFile)next;
                    if (!archFile.isChecked() && !archFile.usedInApplyOrRequire()) continue;
                    if (archFile.isChecked()) {
                        LOGGER.debug("Architecture file '{}' is modified - analyzer results will be discarded.", (Object)archFile.getIdentifyingPath());
                        unsavedRelevant.add(archFile);
                        continue;
                    }
                    THashSet applyingOrRequiringFiles = new THashSet();
                    architectureExtension.getApplyingAndRequiringFilesRecursively(archFile, (Set<ArchitectureFile>)applyingOrRequiringFiles);
                    for (ArchitectureFile nextArchFile : applyingOrRequiringFiles) {
                        if (!nextArchFile.isChecked()) continue;
                        LOGGER.debug("Architecture file '{}' is modified and referenced by checked '{}' architecture file - analyzer results will be discarded.", (Object)archFile.getIdentifyingPath(), (Object)nextArchFile.getIdentifyingPath());
                        unsavedRelevant.add(nextArchFile);
                    }
                    continue;
                }
                LOGGER.debug("File '{}' is modified - analyzer results will be discarded.", (Object)next.getIdentifyingPath());
                unsavedRelevant.add(next);
            }
            if (!unsavedRelevant.isEmpty()) {
                StringBuilder builder = new StringBuilder("");
                builder.append("Because ").append(unsavedRelevant.size()).append(" configuration file(s) modified but not saved:");
                for (IModifiableFile next : unsavedRelevant) {
                    builder.append("\n - ").append(next.getIdentifyingPath());
                }
                return builder.toString();
            }
        }
        return null;
    }

    static final void finishLanguageRemoved(Installation installation, IMetricAwareLanguageProvider languageProvider) {
        assert (installation != null) : "Parameter 'installation' of method 'finishLanguageRemoved' must not be null";
        assert (languageProvider != null) : "Parameter 'languageProvider' of method 'finishLanguageRemoved' must not be null";
        for (LanguageBasedMetricProvider next : installation.getMetricProviders().getChildren(LanguageBasedMetricProvider.class)) {
            if (next.getLanguage() != languageProvider.getLanguage()) continue;
            next.forgetChildren(true);
            installation.metricDescriptorsChanged();
            break;
        }
    }

    static final void finishSoftwareSystemClose(Installation installation, SoftwareSystem softwareSystem, IAnalyzerProvider analyzerProvider, boolean snapshotDeleted, OperationResult result) {
        String info;
        assert (installation != null) : "Parameter 'installation' of method 'finishSoftwareSystemClose' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'finishSoftwareSystemClose' must not be null";
        assert (analyzerProvider != null) : "Parameter 'analyzerProvider' of method 'finishSoftwareSystemClose' must not be null";
        assert (result != null) : "Parameter 'result' of method 'finishSoftwareSystemClose' must not be null";
        String string = info = snapshotDeleted ? "Because snapshot has been deleted." : AnalyzerAdapterUtitity.discardPersistedAnalyzerResults(softwareSystem);
        if (info != null && !info.isEmpty()) {
            LOGGER.debug("Deleting persisted analyzer results");
            TFile storageDir = analyzerProvider.getAnalyzerResultStorageDirectory();
            TrueZipFacade.clear();
            if (storageDir.exists() && storageDir.isDirectory()) {
                try {
                    FileUtility.deleteRecursively((String)storageDir.getNormalizedAbsolutePath());
                    result.addInfo((OperationResult.IMessageCause)SoftwareSystemMessageCause.ANALYZER_RESULTS_DELETED, "\n" + info);
                }
                catch (IOException e) {
                    LOGGER.error("Failed to delete persisted analyzer results", (Throwable)e);
                }
            }
        }
        installation.getMetricProviders().getChildren(LanguageBasedMetricProvider.class).forEach(mp -> {
            List<NamedElement> list = mp.forgetChildren(true);
        });
        installation.metricDescriptorsChanged();
    }

    static void calculateAndSetAdapterDependencies(Collection<AnalyzerAdapter> adapters, MultipleValueMap<AnalyzerGroup, AnalyzerAdapter> groups) {
        assert (adapters != null) : "Parameter 'adapters' of method 'calculateAndSetAdapterDependencies' must not be null";
        assert (groups != null) : "Parameter 'groups' of method 'calculateAndSetAdapterDependencies' must not be null";
        if (!adapters.isEmpty()) {
            LOGGER.debug("Calculate and set analyzer adapter dependencies");
            adapters.forEach(a -> a.clearDependsUpon());
            ArrayList<PluginAnalyzerAdapter> pluginAnalyzerAdapters = new ArrayList<PluginAnalyzerAdapter>();
            ArrayList<AnalyzerAdapter> dependOnPluginAnalyzerAadpters = new ArrayList<AnalyzerAdapter>();
            for (AnalyzerAdapter nextAdapter : adapters) {
                IConfigurableAnalyzerId nextIdToCheck;
                IConfigurableAnalyzerId nextId = nextAdapter.getAnalyzerId();
                AnalyzerGroup nextGroup = nextId.getGroup();
                if (nextAdapter instanceof PluginAnalyzerAdapter) {
                    pluginAnalyzerAdapters.add((PluginAnalyzerAdapter)nextAdapter);
                }
                for (AnalyzerGroup nextGroupToCheck : nextId.getAffectedGroups()) {
                    if (nextGroupToCheck == nextGroup) continue;
                    for (AnalyzerAdapter nextAdapterToCheck : groups.get((Object)nextGroupToCheck)) {
                        assert (!(nextAdapter instanceof PluginAnalyzerAdapter)) : "Dependency to plugin: " + String.valueOf(nextAdapterToCheck.getAnalyzerId()) + " -> " + String.valueOf(nextId);
                        nextAdapterToCheck.addDependsUponAdapter(nextAdapter);
                    }
                }
                if (nextId == CoreAnalyzerId.SCRIPT_RUNNER) {
                    for (AnalyzerAdapter nextAdapterToCheck : adapters) {
                        nextIdToCheck = nextAdapterToCheck.getAnalyzerId();
                        if (nextIdToCheck == CoreAnalyzerId.ISSUE_DENSITY || nextIdToCheck == CoreAnalyzerId.QUALITY_GATES || nextIdToCheck == CoreAnalyzerId.SYSTEM_DIFF || nextIdToCheck == CoreAnalyzerId.ISSUE_RANKING || nextAdapterToCheck instanceof PluginAnalyzerAdapter) continue;
                        nextAdapter.addDependsUponAdapter(nextAdapterToCheck);
                    }
                    dependOnPluginAnalyzerAadpters.add(nextAdapter);
                    continue;
                }
                if (nextId == CoreAnalyzerId.ISSUE_DENSITY) {
                    for (AnalyzerAdapter nextAdapterToCheck : adapters) {
                        nextIdToCheck = nextAdapterToCheck.getAnalyzerId();
                        if (nextIdToCheck == CoreAnalyzerId.QUALITY_GATES || nextIdToCheck == CoreAnalyzerId.SYSTEM_DIFF || nextIdToCheck == CoreAnalyzerId.ISSUE_RANKING || nextAdapterToCheck instanceof PluginAnalyzerAdapter) continue;
                        nextAdapter.addDependsUponAdapter(nextAdapterToCheck);
                    }
                    dependOnPluginAnalyzerAadpters.add(nextAdapter);
                    continue;
                }
                if (nextId == CoreAnalyzerId.ISSUE_RANKING) {
                    for (AnalyzerAdapter nextAdapterToCheck : adapters) {
                        nextIdToCheck = nextAdapterToCheck.getAnalyzerId();
                        if (nextIdToCheck == CoreAnalyzerId.QUALITY_GATES || nextAdapterToCheck instanceof PluginAnalyzerAdapter) continue;
                        nextAdapter.addDependsUponAdapter(nextAdapterToCheck);
                    }
                    dependOnPluginAnalyzerAadpters.add(nextAdapter);
                    continue;
                }
                if (nextId == CoreAnalyzerId.SYSTEM_DIFF) {
                    dependOnPluginAnalyzerAadpters.add(nextAdapter);
                    continue;
                }
                if (nextId != CoreAnalyzerId.QUALITY_GATES) continue;
                dependOnPluginAnalyzerAadpters.add(nextAdapter);
            }
            if (!pluginAnalyzerAdapters.isEmpty() && !dependOnPluginAnalyzerAadpters.isEmpty()) {
                for (AnalyzerAdapter next : dependOnPluginAnalyzerAadpters) {
                    for (PluginAnalyzerAdapter nextPluginAnalyzerAdapter : pluginAnalyzerAdapters) {
                        next.addDependsUponAdapter(nextPluginAnalyzerAdapter);
                    }
                }
            }
            if (LOGGER.isDebugEnabled()) {
                for (AnalyzerAdapter next : adapters) {
                    Set<AnalyzerAdapter> nextDependsUponAdapters = next.getDependsUponAdapters();
                    LOGGER.debug("[" + String.valueOf((Object)next.getGroup()) + "] " + String.valueOf(next.getAnalyzerId()));
                    if (!nextDependsUponAdapters.isEmpty()) {
                        TreeSet<IConfigurableAnalyzerId> dependsUpon = new TreeSet<IConfigurableAnalyzerId>(new ConfigurableAnalyzerIdComparator());
                        nextDependsUponAdapters.forEach(d -> {
                            boolean bl = dependsUpon.add(d.getAnalyzerId());
                        });
                        for (IConfigurableAnalyzerId nextDependsUpon : dependsUpon) {
                            LOGGER.debug(" -> " + String.valueOf(nextDependsUpon));
                        }
                        continue;
                    }
                    LOGGER.debug(" <no dependencies>");
                }
            }
            LOGGER.debug("Calculate and set analyzer adapter dependencies - done");
        }
    }
}

