/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.ICycleElementMetricsExtension;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.CycleElementMetrics;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import java.util.List;

public final class CalculateCycleElementMetricsCommand
extends SoftwareSystemBasedCommand<IInteraction> {
    private List<CycleElementMetrics> m_metrics;

    public CalculateCycleElementMetricsCommand(ISoftwareSystemProvider provider, IInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public final ICommandId getId() {
        return CoreCommandId.COMPUTE_CYCLE_ELEMENT_METRICS;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    public ActivityMode getActivityMode() {
        return ActivityMode.NONE;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        Data data = new Data();
        if (((IInteraction)this.getInteraction()).collect(data)) {
            this.m_metrics = this.getSoftwareSystem().getExtension(ICycleElementMetricsExtension.class).calculateElementMetrics(workerContext, data.getAnalyzerCycleGroup());
        }
    }

    public List<CycleElementMetrics> getMetrics() {
        return this.m_metrics;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    public static final class Data
    implements ICommandInteractionData {
        private AnalyzerCycleGroup m_analyzerCycleGroup;

        Data() {
        }

        public void setAnalyzerCycleGroup(AnalyzerCycleGroup analyzerCycleGroup) {
            assert (analyzerCycleGroup != null) : "Parameter 'analyzerCycleGroup' of method 'setAnalyzerCycleGroup' must not be null";
            this.m_analyzerCycleGroup = analyzerCycleGroup;
        }

        AnalyzerCycleGroup getAnalyzerCycleGroup() {
            assert (this.m_analyzerCycleGroup != null) : "Parameter 'm_analyzerCycleGroup' of method 'getAnalyzerCycleGroup' must not be null";
            return this.m_analyzerCycleGroup;
        }
    }

    public static interface IInteraction
    extends ICommandInteraction {
        public boolean collect(Data var1);
    }
}

