/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.api.model;

import com.hello2morrow.sonargraph.api.DependencyKind;
import com.hello2morrow.sonargraph.api.IDependencyKind;
import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.model.programming.CoreParserDependencyType;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import java.io.IOException;

public final class PluginDependency
extends ParserDependency {
    private String m_pluginId;
    private String m_type;
    private boolean m_isCompileTimeDependency;
    private boolean m_isArchitectureRelevant;
    private boolean m_includeInCycleAnalysis;

    public PluginDependency(ProgrammingElement from) {
        super(from);
    }

    public PluginDependency(ProgrammingElement from, ProgrammingElement to, String pluginId, String type, boolean isCompileTimeDependency, boolean isArchitectureRelevant, boolean includeInCycleAnalysis) {
        super(from, to);
        assert (pluginId != null && pluginId.length() > 0) : "Parameter 'pluginId' of method 'PluginDependency' must not be empty";
        assert (type != null && type.length() > 0) : "Parameter 'type' of method 'PluginDependency' must not be empty";
        this.m_pluginId = pluginId;
        this.m_type = type;
        this.m_isCompileTimeDependency = isCompileTimeDependency;
        this.m_isArchitectureRelevant = isArchitectureRelevant;
        this.m_includeInCycleAnalysis = includeInCycleAnalysis;
    }

    public final String getPluginId() {
        return this.m_pluginId;
    }

    public final String getType() {
        return this.m_type;
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeString(this.m_pluginId);
        writer.writeString(this.m_type);
        writer.writeBoolean(this.m_isCompileTimeDependency);
        writer.writeBoolean(this.m_isArchitectureRelevant);
        writer.writeBoolean(this.m_includeInCycleAnalysis);
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_pluginId = reader.readString();
        this.m_type = reader.readString();
        this.m_isCompileTimeDependency = reader.readBoolean();
        this.m_isArchitectureRelevant = reader.readBoolean();
        this.m_includeInCycleAnalysis = reader.readBoolean();
    }

    @Override
    public boolean isCompileTimeDependency() {
        return this.m_isCompileTimeDependency;
    }

    @Override
    public boolean isArchitectureRelevant() {
        return this.m_isArchitectureRelevant;
    }

    @Override
    public boolean includeInCycleAnalysis() {
        return this.m_includeInCycleAnalysis;
    }

    @Override
    public IParserDependencyType getDependencyType() {
        return new IParserDependencyType(){

            public String getStandardName() {
                return PluginDependency.this.getType();
            }

            public String getPresentationName() {
                return PluginDependency.this.getType();
            }

            public IDependencyKind getKind() {
                return DependencyKind.USES;
            }

            public String getDescription() {
                return "Dependency added by model plugin '" + PluginDependency.this.getPluginId() + "'";
            }

            public IParserDependencyType getGenericDependencyType() {
                return CoreParserDependencyType.USES;
            }
        };
    }

    @Override
    public String getDependencyInfo() {
        return this.m_type + " [" + this.m_pluginId + "]";
    }
}

