/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.api.model;

import com.hello2morrow.sonargraph.api.Aggregator;
import com.hello2morrow.sonargraph.core.api.model.IAggregator;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.IField;
import com.hello2morrow.sonargraph.core.model.programming.IMethod;
import com.hello2morrow.sonargraph.core.model.programming.IRoutine;
import com.hello2morrow.sonargraph.core.model.programming.IType;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespace;
import com.hello2morrow.sonargraph.core.model.programming.NamespaceFragment;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import java.util.HashMap;
import java.util.Map;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class AggregatorImpl
extends Enum<AggregatorImpl>
implements IAggregator {
    public static final /* enum */ AggregatorImpl ELEMENT = new AggregatorImpl(Aggregator.ELEMENT){

        @Override
        public NamedElement aggregateTo(NamedElement from) {
            return from;
        }
    };
    public static final /* enum */ AggregatorImpl TYPE = new AggregatorImpl(Aggregator.TYPE){

        @Override
        public NamedElement aggregateTo(NamedElement from) {
            IType type = from.getParent(IType.class, ParentMode.SELF_OR_FIRST_PARENT);
            return (NamedElement)((Object)type);
        }
    };
    public static final /* enum */ AggregatorImpl NAMED_TYPE = new AggregatorImpl(Aggregator.NAMED_TYPE){

        /*
         * Unable to fully structure code
         */
        @Override
        public NamedElement aggregateTo(NamedElement from) {
            type = from.getParent(IType.class, ParentMode.SELF_OR_FIRST_PARENT);
            if (type != null) ** GOTO lbl5
            return null;
lbl-1000:
            // 1 sources

            {
                type = ((ProgrammingElement)type).getParent(IType.class, new Class[0]);
lbl5:
                // 2 sources

                ** while (type.isAnonymous())
            }
lbl6:
            // 1 sources

            return (NamedElement)type;
        }
    };
    public static final /* enum */ AggregatorImpl TOPLEVEL_TYPE = new AggregatorImpl(Aggregator.TOPLEVEL_TYPE){

        @Override
        public NamedElement aggregateTo(NamedElement from) {
            IType type = from.getParent(IType.class, ParentMode.TOPMOST_PARENT_OR_SELF);
            return (NamedElement)((Object)type);
        }
    };
    public static final /* enum */ AggregatorImpl METHOD = new AggregatorImpl(Aggregator.METHOD){

        @Override
        public NamedElement aggregateTo(NamedElement from) {
            IMethod type = from.getParent(IMethod.class, ParentMode.SELF_OR_FIRST_PARENT);
            return (NamedElement)((Object)type);
        }
    };
    public static final /* enum */ AggregatorImpl ROUTINE = new AggregatorImpl(Aggregator.ROUTINE){

        @Override
        public NamedElement aggregateTo(NamedElement from) {
            IRoutine type = from.getParent(IRoutine.class, ParentMode.SELF_OR_FIRST_PARENT);
            return (NamedElement)((Object)type);
        }
    };
    public static final /* enum */ AggregatorImpl FIELD = new AggregatorImpl(Aggregator.FIELD){

        @Override
        public NamedElement aggregateTo(NamedElement from) {
            IField type = from.getParent(IField.class, ParentMode.SELF_OR_FIRST_PARENT);
            return (NamedElement)((Object)type);
        }
    };
    public static final /* enum */ AggregatorImpl SYSTEM_NAMESPACE = new AggregatorImpl(Aggregator.SYSTEM_NAMESPACE){

        @Override
        public NamedElement aggregateTo(NamedElement from) {
            LogicalNamespace.ISourceNamespace frag = from.getParent(NamespaceFragment.class, ParentMode.SELF_OR_FIRST_PARENT);
            if (frag == null) {
                return null;
            }
            return frag.getSystemNamespace();
        }
    };
    public static final /* enum */ AggregatorImpl MODULE_NAMESPACE = new AggregatorImpl(Aggregator.MODULE_NAMESPACE){

        @Override
        public NamedElement aggregateTo(NamedElement from) {
            LogicalNamespace.ISourceNamespace frag = from.getParent(NamespaceFragment.class, ParentMode.SELF_OR_FIRST_PARENT);
            if (frag == null) {
                return null;
            }
            return frag.getModuleNamespace();
        }
    };
    public static final /* enum */ AggregatorImpl MODULE = new AggregatorImpl(Aggregator.MODULE){

        @Override
        public NamedElement aggregateTo(NamedElement from) {
            Module module = from.getParent(Module.class, ParentMode.SELF_OR_FIRST_PARENT);
            return module;
        }
    };
    public static final /* enum */ AggregatorImpl SOURCE_FILE = new AggregatorImpl(Aggregator.SOURCE_FILE){

        @Override
        public NamedElement aggregateTo(NamedElement from) {
            if (!$assertionsDisabled && from == null) {
                throw new AssertionError((Object)"Parameter 'from' of method 'enclosing_method' must not be null");
            }
            return from.getParent(SourceFile.class, ParentMode.SELF_OR_FIRST_PARENT);
        }
    };
    public static final /* enum */ AggregatorImpl COMPONENT = new AggregatorImpl(Aggregator.COMPONENT){

        @Override
        public NamedElement aggregateTo(NamedElement from) {
            if (!$assertionsDisabled && from == null) {
                throw new AssertionError((Object)"Parameter 'from' of method 'enclosing_method' must not be null");
            }
            IComponent component = from.getParent(IComponent.class, ParentMode.SELF_OR_FIRST_PARENT);
            return component != null ? component.getNamedElement() : null;
        }
    };
    private static Map<Aggregator, IAggregator> s_aggregatorMap;
    private final Aggregator m_aggregator;
    private static final /* synthetic */ AggregatorImpl[] ENUM$VALUES;

    static {
        ENUM$VALUES = new AggregatorImpl[]{ELEMENT, TYPE, NAMED_TYPE, TOPLEVEL_TYPE, METHOD, ROUTINE, FIELD, SYSTEM_NAMESPACE, MODULE_NAMESPACE, MODULE, SOURCE_FILE, COMPONENT};
        s_aggregatorMap = new HashMap<Aggregator, IAggregator>();
    }

    private AggregatorImpl(Aggregator aggr) {
        this.m_aggregator = aggr;
    }

    @Override
    public abstract NamedElement aggregateTo(NamedElement var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IAggregator map(Aggregator aggr) {
        assert (aggr != null) : "Parameter 'aggr' of method 'map' must not be null";
        Map<Aggregator, IAggregator> map = s_aggregatorMap;
        synchronized (map) {
            if (s_aggregatorMap.isEmpty()) {
                AggregatorImpl[] aggregatorImplArray = AggregatorImpl.values();
                int n = aggregatorImplArray.length;
                int n2 = 0;
                while (n2 < n) {
                    AggregatorImpl impl = aggregatorImplArray[n2];
                    s_aggregatorMap.put(impl.m_aggregator, impl);
                    ++n2;
                }
            }
        }
        IAggregator result = s_aggregatorMap.get(aggr);
        assert (result != null);
        return result;
    }

    public static AggregatorImpl[] values() {
        AggregatorImpl[] aggregatorImplArray = ENUM$VALUES;
        int n = aggregatorImplArray.length;
        AggregatorImpl[] aggregatorImplArray2 = new AggregatorImpl[n];
        System.arraycopy(ENUM$VALUES, 0, aggregatorImplArray2, 0, n);
        return aggregatorImplArray2;
    }

    public static AggregatorImpl valueOf(String string) {
        return Enum.valueOf(AggregatorImpl.class, string);
    }
}

