/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.csharp.model.programming;

import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.foundation.utilities.Joiner;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpProgrammingElement;
import java.io.IOException;

public abstract class CSharpGenericProgrammingElement
extends CSharpProgrammingElement {
    private static String[] emptyArray = new String[0];
    private String[] m_typeParameters;

    public CSharpGenericProgrammingElement(IModelServiceProvider msp, NamedElement parent, String name, String[] typeParameters) {
        super(msp, parent, name);
        this.m_typeParameters = typeParameters == null ? emptyArray : typeParameters;
    }

    public CSharpGenericProgrammingElement(NamedElement parent) {
        super(parent);
    }

    public String[] getTypeParameters() {
        return this.m_typeParameters;
    }

    public String getShortName() {
        Object result = super.getShortName();
        if (this.m_typeParameters.length > 0) {
            result = (String)result + "<" + Joiner.join((Object[])this.m_typeParameters) + ">";
        }
        return result;
    }

    public int getNumberOfGenericTypeParameters() {
        return this.m_typeParameters.length;
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeByte((byte)this.m_typeParameters.length);
        String[] stringArray = this.m_typeParameters;
        int n = this.m_typeParameters.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            writer.writeString(p);
            ++n2;
        }
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        int length = reader.readByte();
        this.m_typeParameters = length == 0 ? emptyArray : new String[length];
        int i = 0;
        while (i < length) {
            this.m_typeParameters[i] = reader.readString();
            ++i;
        }
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitCSharpGenericProgrammingElement(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor {
        public void visitCSharpGenericProgrammingElement(CSharpGenericProgrammingElement var1);
    }
}

