/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser;

import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.programming.IType;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.AbstractPythonVisitor;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.ClassScope;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.DependencyCreator;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.IPythonImporter;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.LhsNameCollector;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.NameResolver;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.PythonParser;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.Scope;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.ScopeItem;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.TypeClass;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.TypeVisitor;
import com.hello2morrow.sonargraph.languageprovider.python.model.element.PythonParserWarning;
import com.hello2morrow.sonargraph.languageprovider.python.model.programming.IPythonRoutine;
import com.hello2morrow.sonargraph.languageprovider.python.model.programming.PythonClass;
import com.hello2morrow.sonargraph.languageprovider.python.model.programming.PythonDependencyType;
import com.hello2morrow.sonargraph.languageprovider.python.model.programming.PythonField;
import com.hello2morrow.sonargraph.languageprovider.python.model.programming.PythonFunction;
import com.hello2morrow.sonargraph.languageprovider.python.model.programming.PythonMethod;
import com.hello2morrow.sonargraph.languageprovider.python.model.programming.PythonSourceFile;
import com.hello2morrow.sonargraph.languageprovider.python.model.programming.PythonVariable;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonVisitor
extends AbstractPythonVisitor<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PythonVisitor.class);
    private final IModelServiceProvider m_msp;
    private final IPythonImporter m_importer;
    private final IWorkerContext m_workerContext;

    public PythonVisitor(IWorkerContext workerContext, IModelServiceProvider msp, IPythonImporter importer, Scope currentScope) {
        super(currentScope, (PythonSourceFile)currentScope.getModelObject(), false);
        assert (workerContext != null) : "Parameter 'workerContext' of method 'PythonVisitor' must not be null";
        assert (msp != null) : "Parameter 'msp' of method 'PythonDefinitionVisitor' must not be null";
        assert (importer != null) : "Parameter 'importer' of method 'PythonVisitor' must not be null";
        this.m_workerContext = workerContext;
        this.m_msp = msp;
        this.m_importer = importer;
    }

    private void processDecorators(Scope scope, List<PythonParser.Named_expressionContext> decorators) {
        assert (scope != null) : "Parameter 'scope' of method 'processDecorators' must not be null";
        assert (decorators != null) : "Parameter 'decorators' of method 'processDecorators' must not be null";
        NamedElement fromObject = scope.getModelObject();
        assert (fromObject != null);
        for (PythonParser.Named_expressionContext ctx : decorators) {
            List<ScopeItem> resolvedItems;
            ScopeItem decorator;
            NamedElement modelObject;
            NameResolver resolver = new NameResolver(scope, this.m_source, true);
            ctx.accept(resolver);
            if (resolver.getUnresolvedNames().size() != 0 || (modelObject = (decorator = (resolvedItems = resolver.getResolvedItems()).get(resolvedItems.size() - 1)).getModelObject()) == null) continue;
            DependencyCreator.createDependency(fromObject, modelObject, PythonDependencyType.DECORATED_BY, ctx.start.getLine());
            if (!(fromObject instanceof PythonMethod)) continue;
            PythonMethod m = (PythonMethod)fromObject;
            if (modelObject.getShortName().equals("staticmethod")) {
                m.setKind(PythonMethod.Kind.STATIC_METHOD);
                continue;
            }
            if (!modelObject.getShortName().equals("classmethod")) continue;
            m.setKind(PythonMethod.Kind.CLASS_METHOD);
        }
    }

    @Override
    public Void visitFunction_def(PythonParser.Function_defContext ctx) {
        Scope scope;
        this.visitChildren((RuleNode)ctx);
        if (ctx.decorators() != null && !this.m_source.isExternal() && (scope = ctx.function_def_raw().m_scope) != null) {
            this.processDecorators(scope, ctx.decorators().named_expression());
        }
        return null;
    }

    @Override
    public Void visitFunction_def_raw(PythonParser.Function_def_rawContext ctx) {
        if (this.m_workerContext.hasBeenCanceled()) {
            return null;
        }
        Token tok = ctx.NAME().getSymbol();
        NamedElement parent = this.m_currentScope.getModelObject();
        String name = tok.getText();
        int serialNumber = parent.getChildren(c -> c.getShortName().equals(name), ProgrammingElement.class).size();
        IPythonRoutine newElement = this.m_currentScope.getModelObject() instanceof IType ? new PythonMethod(this.m_msp, parent, tok.getText(), tok.getLine(), serialNumber) : new PythonFunction(this.m_msp, parent, tok.getText(), tok.getLine(), serialNumber);
        parent.addChild((NamedElement)newElement);
        Scope parentScope = this.m_currentScope;
        this.m_currentScope = new Scope(parentScope.getInstanceScope(), (NamedElement)newElement);
        parentScope.addChild(this.m_currentScope);
        if (!newElement.isExternal()) {
            ctx.m_scope = this.m_currentScope;
        }
        if (this.m_workerContext.hasBeenCanceled()) {
            return null;
        }
        this.visitChildren((RuleNode)ctx);
        this.m_currentScope = parentScope;
        return null;
    }

    @Override
    public Void visitClass_def(PythonParser.Class_defContext ctx) {
        Scope scope;
        this.visitChildren((RuleNode)ctx);
        if (ctx.decorators() != null && !this.m_source.isExternal() && (scope = ctx.class_def_raw().m_scope) != null) {
            this.processDecorators(scope, ctx.decorators().named_expression());
        }
        return null;
    }

    @Override
    public Void visitClass_def_raw(PythonParser.Class_def_rawContext ctx) {
        if (this.m_workerContext.hasBeenCanceled()) {
            return null;
        }
        Token tok = ctx.NAME().getSymbol();
        NamedElement parent = this.m_currentScope.getModelObject();
        String name = tok.getText();
        int serialNumber = parent.getChildren(c -> c.getShortName().equals(name), ProgrammingElement.class).size();
        PythonClass cls = new PythonClass(this.m_msp, this.m_currentScope.getModelObject(), name, tok.getLine(), serialNumber);
        Scope parentScope = this.m_currentScope;
        this.m_currentScope.getModelObject().addChild((NamedElement)cls);
        ClassScope current = new ClassScope(parentScope, cls);
        this.m_currentScope = current;
        parentScope.addChild(this.m_currentScope);
        if (!name.equals("object")) {
            PythonParser.ArgsContext args = ctx.arguments() == null ? null : ctx.arguments().args();
            BaseClassResolver resolver = new BaseClassResolver(this.m_source, parentScope, current, args, tok.getLine());
            resolver.process(this.m_workerContext);
        }
        if (!cls.isExternal()) {
            ctx.m_scope = this.m_currentScope;
        }
        if (this.m_workerContext.hasBeenCanceled()) {
            return null;
        }
        if (ctx.block() != null) {
            ctx.block().accept(this);
        }
        this.m_currentScope = parentScope;
        return null;
    }

    @Override
    public Void visitGlobal_stmt(PythonParser.Global_stmtContext ctx) {
        for (TerminalNode node : ctx.NAME()) {
            if (this.m_workerContext.hasBeenCanceled()) {
                return null;
            }
            this.m_currentScope.addGlobalName(node.getText());
        }
        return null;
    }

    @Override
    public Void visitNonlocal_stmt(PythonParser.Nonlocal_stmtContext ctx) {
        for (TerminalNode node : ctx.NAME()) {
            if (this.m_workerContext.hasBeenCanceled()) {
                return null;
            }
            this.m_currentScope.addNonlocalName(node.getText());
        }
        return null;
    }

    private void createDependency(NamedElement to, PythonDependencyType type, int line) {
        NamedElement fromObject = this.getFromObject();
        if (fromObject != null) {
            DependencyCreator.createDependency(fromObject, to, type, line);
        }
    }

    @Override
    public Void visitAssignment(PythonParser.AssignmentContext ctx) {
        boolean hasEqual;
        if (ctx.augassign() != null) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>();
        LhsNameCollector collector = new LhsNameCollector(this.m_currentScope, this.m_source, names);
        ClassScope typeHint = null;
        boolean createWriteDependency = false;
        boolean bl = hasEqual = ctx.EQUAL() != null && ctx.EQUAL().size() > 0;
        if (ctx.NAME() != null) {
            names.add(ctx.NAME().getText());
            tv = new TypeVisitor(this.m_currentScope, this.m_source, false, true);
            ctx.expression().accept(tv);
            typeHint = tv.getResult();
            createWriteDependency = hasEqual;
        } else {
            ctx.accept(collector);
            if (ctx.single_subscript_attribute_target() != null || ctx.single_target() != null) {
                tv = new TypeVisitor(this.m_currentScope, this.m_source, false, true);
                ctx.expression().accept(tv);
                typeHint = tv.getResult();
            }
        }
        int line = ctx.start.getLine();
        Scope scope = this.m_currentScope;
        for (String name : names) {
            ScopeItem item;
            Object existing;
            if (this.m_currentScope.isNonlocalName(name) || this.m_currentScope.isGlobalName(name)) continue;
            NamedElement parent = this.m_currentScope.getModelObject();
            Object modelObject = null;
            if (this.m_currentScope.isClassScope()) {
                if (!hasEqual) {
                    scope = scope.getInstanceScope();
                    parent = scope.getModelObject();
                }
                if ((existing = (PythonField)((Object)parent.getFirstChild(c -> c.getShortName().equals(name), PythonField.class))) == null) {
                    modelObject = new PythonField(this.m_msp, parent, name, true, line);
                }
            } else if (this.m_currentScope.isMethodScope()) {
                if (collector.isField(name)) {
                    ScopeItem item2;
                    existing = (PythonField)((Object)(parent = parent.getParent()).getFirstChild(c -> c.getShortName().equals(name), PythonField.class));
                    if (existing == null && (item2 = this.m_currentScope.getParent().getInstanceScope().lookupMember(name, this.m_source, line, true)) == null) {
                        PythonField field = new PythonField(this.m_msp, parent, name, false, line);
                        parent.addChild((NamedElement)field);
                        this.m_currentScope.getParent().getInstanceScope().addItem((NamedElement)field);
                    }
                } else {
                    item = this.m_currentScope.lookupLocal(name);
                    if (item == null) {
                        item = this.m_currentScope.addLocalName(name, line);
                    }
                    if (typeHint != null) {
                        item.setTypeHint(new TypeClass(typeHint));
                    }
                }
            } else if (this.m_currentScope.isFunctionScope()) {
                item = this.m_currentScope.lookupLocal(name);
                if (item == null) {
                    item = this.m_currentScope.addLocalName(name, line);
                }
                if (typeHint != null) {
                    item.setTypeHint(new TypeClass(typeHint));
                }
            } else if (!this.m_currentScope.isPackage() && (existing = (PythonVariable)((Object)parent.getFirstChild(c -> c.getShortName().equals(name), PythonVariable.class))) == null) {
                modelObject = new PythonVariable(this.m_msp, parent, name, line);
            }
            if (modelObject == null) continue;
            parent.addChild(modelObject);
            item = scope.addItem((NamedElement)modelObject);
            if (typeHint != null) {
                item.setTypeHint(new TypeClass(typeHint));
            }
            if (!createWriteDependency) continue;
            this.createDependency((NamedElement)modelObject, PythonDependencyType.WRITE, line);
        }
        if (this.m_workerContext.hasBeenCanceled()) {
            return null;
        }
        return (Void)super.visitAssignment(ctx);
    }

    @Override
    public Void visitImport_name(PythonParser.Import_nameContext ctx) {
        for (PythonParser.Dotted_as_nameContext d : ctx.dotted_as_names().dotted_as_name()) {
            if (this.m_workerContext.hasBeenCanceled()) {
                return null;
            }
            TerminalNode asNameNode = d.NAME();
            String asName = asNameNode == null ? null : asNameNode.getText();
            this.m_importer.importModule(this.m_workerContext, this.m_currentScope, d.dotted_name().getText(), asName, d.dotted_name().getStart().getLine());
        }
        return null;
    }

    private String calculatePrefix(String dottedName, int levelUps) {
        String[] parts = dottedName.split("\\.");
        int len = parts.length;
        if (levelUps >= len) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < len - levelUps) {
            sb.append(parts[i]).append('.');
            ++i;
        }
        return sb.toString();
    }

    @Override
    public Void visitImport_from(PythonParser.Import_fromContext ctx) {
        assert (ctx != null) : "Parameter 'ctx' of method 'visitImport_from' must not be null";
        if (this.m_workerContext.hasBeenCanceled()) {
            return null;
        }
        RootDirectoryPath parent = (RootDirectoryPath)this.m_source.getParent(RootDirectoryPath.class, new Class[0]);
        int levelUps = 0;
        levelUps += 3 * ctx.ELLIPSIS().size();
        levelUps += ctx.DOT().size();
        if (ctx.dotted_name() != null) {
            String dottedName = ctx.dotted_name().getText();
            Object importName = levelUps == 0 ? dottedName : this.calculatePrefix(this.m_source.getPythonModuleName(), levelUps) + dottedName;
            int importLine = ctx.dotted_name().getStart().getLine();
            LOGGER.debug(String.format("Importing '%s' from %s:%d", importName, this.m_source.getName(), importLine));
            Scope module = this.m_importer.importModule(this.m_workerContext, this.m_currentScope, parent, (String)importName, importLine);
            if (module != null) {
                PythonParser.Import_from_as_namesContext ctx2 = ctx.import_from_targets().import_from_as_names();
                if (ctx2 != null) {
                    for (PythonParser.Import_from_as_nameContext importAs : ctx2.import_from_as_name()) {
                        if (this.m_workerContext.hasBeenCanceled()) {
                            return null;
                        }
                        TerminalNode nameNode = importAs.NAME(0);
                        TerminalNode asNode = importAs.NAME(1);
                        String name = nameNode.getText();
                        int line = nameNode.getSymbol().getLine();
                        String asName = asNode == null ? name : asNode.getText();
                        ImportMemberImporter importer = new ImportMemberImporter(this.m_currentScope, module, name, asName, line);
                        if (module.hasBeenParsed()) {
                            importer.process(this.m_workerContext);
                            continue;
                        }
                        this.m_importer.addProcessor(importer);
                    }
                } else if (module.hasBeenParsed()) {
                    this.m_currentScope.importAllFrom(this.m_workerContext, module, importLine);
                } else {
                    this.m_importer.addProcessor(new ImportAllImporter(this.m_currentScope, module, importLine));
                }
            }
        } else if (levelUps > 0) {
            int line = ctx.getStart().getLine();
            String prefix = this.calculatePrefix(this.m_source.getPythonModuleName(), levelUps);
            if (prefix.length() > 0) {
                Scope module;
                if (prefix.endsWith(".")) {
                    prefix = prefix.substring(0, prefix.length() - 1);
                }
                if ((module = this.m_importer.importModule(this.m_workerContext, this.m_currentScope, parent, prefix, line)) == null) {
                    return null;
                }
                PythonParser.Import_from_as_namesContext ctx2 = ctx.import_from_targets().import_from_as_names();
                if (ctx2 == null) {
                    if (module.hasBeenParsed()) {
                        this.m_currentScope.importAllFrom(this.m_workerContext, module, line);
                    } else {
                        this.m_importer.addProcessor(new ImportAllImporter(this.m_currentScope, module, line));
                    }
                    return null;
                }
                for (PythonParser.Import_from_as_nameContext importAs : ctx2.import_from_as_name()) {
                    if (this.m_workerContext.hasBeenCanceled()) {
                        return null;
                    }
                    TerminalNode nameNode = importAs.NAME(0);
                    TerminalNode asNode = importAs.NAME(1);
                    String name = nameNode.getText();
                    String asName = asNode == null ? name : asNode.getText();
                    ImportMemberImporter importer = new ImportMemberImporter(this.m_currentScope, module, name, asName, line);
                    if (module.hasBeenParsed()) {
                        importer.process(this.m_workerContext);
                        continue;
                    }
                    this.m_importer.addProcessor(importer);
                }
            } else {
                PythonParser.Import_from_as_namesContext ctx2 = ctx.import_from_targets().import_from_as_names();
                for (PythonParser.Import_from_as_nameContext importAs : ctx2.import_from_as_name()) {
                    if (this.m_workerContext.hasBeenCanceled()) {
                        return null;
                    }
                    TerminalNode nameNode = importAs.NAME(0);
                    TerminalNode asNode = importAs.NAME(1);
                    String name = nameNode.getText();
                    String asName = asNode == null ? name : asNode.getText();
                    this.m_importer.importModule(this.m_workerContext, this.m_currentScope, parent, name, asName, line);
                }
            }
        } else {
            this.m_source.addIssue((Issue)new PythonParserWarning((NamedElement)this.m_source, "Bad import statement", ctx.start.getLine()));
        }
        return null;
    }

    @Override
    public Void visitFile_input(PythonParser.File_inputContext ctx) {
        if (this.m_workerContext.hasBeenCanceled()) {
            return null;
        }
        this.visitChildren((RuleNode)ctx);
        this.m_currentScope.parsingFinished();
        return null;
    }

    private static class BaseClassResolver
    implements IPythonImporter.IProcessor {
        private final PythonSourceFile m_source;
        private final Scope m_scope;
        private final ClassScope m_class;
        private final PythonParser.ArgsContext m_argList;
        private final int m_line;

        private BaseClassResolver(PythonSourceFile source, Scope scope, ClassScope cls, PythonParser.ArgsContext argList, int line) {
            this.m_source = source;
            this.m_scope = scope;
            this.m_class = cls;
            this.m_argList = argList;
            this.m_line = line;
        }

        @Override
        public void process(IWorkerContext workerContext) {
            ScopeItem objectAsItem;
            assert (workerContext != null) : "Parameter 'workerContext' of method 'process' must not be null";
            int baseClassesFound = 0;
            if (this.m_argList != null) {
                for (PythonParser.ExpressionContext arg : this.m_argList.expression()) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    if (arg.getChildCount() > 1) continue;
                    TypeVisitor tv = new TypeVisitor(this.m_scope, this.m_source, false, false);
                    if (arg.disjunction().size() > 0) {
                        arg.disjunction(0).accept(tv);
                        if (tv.getResult() != null) {
                            this.m_class.addBaseClass(tv.getResult(), arg.start.getLine());
                            ++baseClassesFound;
                        } else if (!this.m_source.isExternal()) {
                            String clsName = arg.getText();
                            String msg = String.format("Cannot resolve base class '%s'", clsName);
                            this.m_source.addIssue((Issue)new PythonParserWarning((NamedElement)this.m_source, msg, arg.start.getLine()));
                        }
                    }
                    arg.m_checked = true;
                }
            }
            if (baseClassesFound == 0 && (objectAsItem = this.m_scope.lookup("object", this.m_source, 999999, false)) instanceof ClassScope && objectAsItem.getParent().getName().equals("builtins")) {
                this.m_class.addBaseClass((ClassScope)objectAsItem, this.m_line);
            }
        }
    }

    private static class ImportAllImporter
    implements IPythonImporter.IProcessor {
        private final Scope m_current;
        private final Scope m_from;
        private final int m_line;

        private ImportAllImporter(Scope current, Scope from, int line) {
            this.m_current = current;
            this.m_from = from;
            this.m_line = line;
        }

        @Override
        public void process(IWorkerContext workerContext) {
            this.m_current.importAllFrom(workerContext, this.m_from, this.m_line);
        }
    }

    private static class ImportMemberImporter
    implements IPythonImporter.IProcessor {
        private final Scope m_current;
        private final Scope m_from;
        private final String m_name;
        private final String m_asName;
        private final int m_line;

        private ImportMemberImporter(Scope current, Scope from, String name, String asName, int line) {
            assert (current != null) : "Parameter 'current' of method 'ImportMemberImporter' must not be null";
            assert (from != null) : "Parameter 'from' of method 'ImportMemberImporter' must not be null";
            assert (name != null && name.length() > 0) : "Parameter 'name' of method 'ImportMemberImporter' must not be empty";
            assert (asName != null && asName.length() > 0) : "Parameter 'asName' of method 'ImportMemberImporter' must not be empty";
            this.m_current = current;
            this.m_from = from;
            this.m_name = name;
            this.m_asName = asName;
            this.m_line = line;
        }

        @Override
        public void process(IWorkerContext workerContext) {
            assert (workerContext != null) : "Parameter 'workerContext' of method 'process' must not be null";
            ScopeItem item = this.m_from.lookupLocal(this.m_name);
            if (item != null) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                if (item.isPackage()) {
                    item = ((Scope)item).lookupLocal("__init__");
                }
                DependencyCreator.createDependency(this.m_current.getModelObject(), item.getModelObject(), PythonDependencyType.IMPORT, this.m_line);
                this.m_current.importScopeItem(this.m_asName, item);
            }
        }
    }
}

