/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.client.detector;

import com.hello2morrow.sonargraph.build.client.detector.ProjectUnit;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ProjectFolder {
    private final List<ProjectUnit> m_units = new ArrayList<ProjectUnit>();
    private final File m_root;
    private final String m_name;

    public ProjectFolder(File root) {
        this(root, root.getName());
    }

    public ProjectFolder(File root, String name) {
        assert (root != null) : "Parameter 'root' of method 'ProjectFolder' must not be null";
        assert (root.isDirectory());
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'ProjectFolder' must not be empty";
        this.m_root = root;
        this.m_name = name;
    }

    public File getRoot() {
        return this.m_root;
    }

    public String getName() {
        return this.m_name;
    }

    public void addUnit(ProjectUnit unit) {
        assert (unit != null) : "Parameter 'unit' of method 'addUnit' must not be null";
        this.m_units.add(unit);
    }

    public List<ProjectUnit> getUnits() {
        return Collections.unmodifiableList(this.m_units);
    }

    public boolean isEmpty() {
        return this.m_units.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append(":\n");
        for (ProjectUnit unit : this.m_units) {
            sb.append(unit.toString());
        }
        return sb.toString();
    }
}

