/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.foundation.common;

import java.util.Set;
import java.util.StringTokenizer;

public final class JavaNameUtility {
    public static final char NESTED_TYPE_CHAR = '$';
    public static final String BYTECODE_CONSTRUCTOR_NAME = "<init>";
    public static final String BYTECODE_STATIC_BLOCK_NAME = "<clinit>";
    public static final String BLOCK = "{...}";
    public static final String JAVA_LANG = "java.lang";
    public static final String JAVA_LANG_CLASS = "java.lang.Class";
    public static final String JAVA_LANG_SYSTEM = "java.lang.System";
    public static final String JAVA_LANG_OBJECT = "java.lang.Object";
    public static final String JAVA_LANG_ENUM = "java.lang.Enum";
    public static final String JAVA_LANG_STRING = "java.lang.String";

    private JavaNameUtility() {
    }

    private static boolean isValidIdentifier(String identifier, Set<String> keywords) {
        assert (identifier != null && identifier.length() > 0) : "Parameter 'identifier' of method 'isValidIdentifier' must not be empty";
        assert (keywords != null) : "Parameter 'keywords' of method 'isValidIdentifier' must not be null";
        if (keywords.contains(identifier)) {
            return false;
        }
        char[] c = identifier.toCharArray();
        if (!Character.isJavaIdentifierStart(c[0])) {
            return false;
        }
        int i = 1;
        while (i < c.length) {
            if (!Character.isJavaIdentifierPart(c[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isValidPackageName(String identifier, Set<String> keywords) {
        assert (keywords != null) : "Parameter 'keywords' of method 'isValidPackageName' must not be null";
        if (identifier == null || identifier.length() == 0 || identifier.startsWith(".") || identifier.endsWith(".")) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(identifier, ".");
        while (tokenizer.hasMoreTokens()) {
            String nextPartName = tokenizer.nextToken();
            if (JavaNameUtility.isValidIdentifier(nextPartName, keywords)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidPackagePartName(String identifier, Set<String> keywords) {
        assert (keywords != null) : "Parameter 'keywords' of method 'isValidPackagePartName' must not be null";
        if (identifier == null || identifier.length() == 0) {
            return false;
        }
        return JavaNameUtility.isValidIdentifier(identifier, keywords);
    }

    public static boolean isValidCompilationUnitName(String identifier, Set<String> keywords) {
        assert (keywords != null) : "Parameter 'keywords' of method 'isValidCompilationUnitName' must not be null";
        if (identifier == null || identifier.length() == 0) {
            return false;
        }
        return JavaNameUtility.isValidIdentifier(identifier, keywords);
    }

    public static boolean isValidTypeName(String identifier, Set<String> keywords) {
        assert (keywords != null) : "Parameter 'keywords' of method 'isValidTypeName' must not be null";
        if (identifier == null || identifier.length() == 0) {
            return false;
        }
        return JavaNameUtility.isValidIdentifier(identifier, keywords);
    }

    public static String getRelativePath(String packageName, String fileName) {
        assert (packageName != null) : "'packageName' must not be null";
        assert (fileName != null) : "'fileName' must not be null";
        assert (fileName.length() > 0) : "'fileName' must not be empty";
        StringBuilder buffer = new StringBuilder(".");
        buffer.append('/');
        if (packageName.length() > 0) {
            buffer.append(packageName.replace('.', '/'));
            buffer.append('/');
        }
        buffer.append(fileName);
        return buffer.toString();
    }

    public static String getPackageNameFromRelativeFilePath(String relativeFilePath) {
        assert (relativeFilePath != null && relativeFilePath.length() > 0) : "Parameter 'relativeFilePath' of method 'getPackageNameFromRelativeFilePath' must not be empty";
        String packageName = relativeFilePath;
        int pos = packageName.lastIndexOf("/");
        if (pos == -1) {
            return "";
        }
        if ((packageName = packageName.substring(0, pos)).startsWith(".")) {
            packageName = packageName.substring(".".length(), packageName.length());
        }
        if (packageName.startsWith("/")) {
            packageName = packageName.substring("/".length(), packageName.length());
        }
        packageName = packageName.replace('/', '.');
        return packageName;
    }

    public static String getRelativeDirectoryPathFromPackageName(String packageName) {
        assert (packageName != null) : "Parameter 'packageName' of method 'getRelativeDirectoryPathFromPackageName' must not be null";
        return packageName.replace('.', '/');
    }

    public static String getPackageNameFromFullyQualifiedTypeName(String fqTypeName) {
        assert (fqTypeName != null) : "'fqname' must not be null";
        int pos = fqTypeName.lastIndexOf(46);
        if (pos != -1) {
            return fqTypeName.substring(0, pos);
        }
        return "";
    }

    public static String getTypeNameFromFqTypeName(String fqTypeName) {
        assert (fqTypeName != null && fqTypeName.length() > 0) : "Parameter 'fqTypeName' of method 'getTypeNameFromFqTypeName' must not be empty";
        String typeName = fqTypeName;
        int pos = fqTypeName.lastIndexOf(46);
        if (pos != -1) {
            typeName = fqTypeName.substring(pos + 1);
        }
        return typeName;
    }

    public static String getMainTypeName(String fqTypeName) {
        assert (fqTypeName != null && fqTypeName.length() > 0) : "Parameter 'fqTypeName' of method 'getMainTypeName' must not be empty";
        String typeName = fqTypeName;
        int pos = fqTypeName.lastIndexOf(46);
        if (pos != -1) {
            typeName = typeName.substring(pos + 1);
        }
        if ((pos = typeName.indexOf(36)) > 0) {
            typeName = typeName.substring(0, pos);
        }
        return typeName;
    }

    public static boolean isPotentialNestedType(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'getMainTypeName' must not be empty";
        return name.lastIndexOf(36) != -1;
    }

    public static boolean isPotentialAnonymousType(String fqTypeName) {
        assert (fqTypeName != null && fqTypeName.length() > 0) : "Parameter 'fqTypeName' of method 'isPotentialAnonymousType' must not be empty";
        int pos = fqTypeName.lastIndexOf(36);
        if (pos == -1) {
            return false;
        }
        String potentialNumberPart = fqTypeName.substring(pos + 1);
        if (potentialNumberPart.isEmpty()) {
            return false;
        }
        int i = 0;
        while (i < potentialNumberPart.length()) {
            char nextChar = potentialNumberPart.charAt(i);
            if (!Character.isDigit(nextChar)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String getNameOfEnclosingTypeOfPotentialNestedType(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'getMainTypeName' must not be empty";
        int pos = name.lastIndexOf(36);
        assert (pos != -1) : "Not a nested type: " + name;
        return name.substring(0, pos);
    }
}

