/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.virtualmodel;

import com.hello2morrow.sonargraph.core.model.analysis.DynamicIssueType;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureCheckIssueId;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.IssueType;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.Priority;
import com.hello2morrow.sonargraph.core.model.element.pattern.DependencyWildcardPattern;
import com.hello2morrow.sonargraph.core.model.element.pattern.LineBasedContextSimilarityMatchPattern;
import com.hello2morrow.sonargraph.core.model.element.pattern.NamedElementFullyQualifiedNamePattern;
import com.hello2morrow.sonargraph.core.model.element.pattern.NamedElementWildcardPattern;
import com.hello2morrow.sonargraph.core.model.element.pattern.ParserDependencyEndpointPattern;
import com.hello2morrow.sonargraph.core.model.plugin.PluginIssueId;
import com.hello2morrow.sonargraph.core.model.refactoring.DeleteRefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.LanguageSpecificRefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRenameRefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRenameRefactoringElementType;
import com.hello2morrow.sonargraph.core.model.refactoring.RenameRefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.resolution.FixDefinition;
import com.hello2morrow.sonargraph.core.model.resolution.IgnoreDefinition;
import com.hello2morrow.sonargraph.core.model.resolution.Matching;
import com.hello2morrow.sonargraph.core.model.resolution.PatternBasedCycleIgnoreFilter;
import com.hello2morrow.sonargraph.core.model.resolution.PatternBasedCycleIgnoreFilterData;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.resolution.TaskDefinition;
import com.hello2morrow.sonargraph.core.model.resolution.ToDoDefinition;
import com.hello2morrow.sonargraph.core.model.script.ScriptIssueId;
import com.hello2morrow.sonargraph.core.model.system.IPersistableVirtualModel;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.AbstractVirtualModelIO;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.ObjectFactory;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.XsdDeleteResolution;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.XsdDependencyPattern;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.XsdDependencyPatternType;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.XsdElementPattern;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.XsdElementPatternType;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.XsdIncludePattern;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.XsdIssueType;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.XsdLanguageSpecificRefactoringDefinition;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.XsdMatching;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.XsdMoveRenameResolution;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.XsdMoveResolution;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.XsdPatternFilter;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.XsdPriority;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.XsdRefactoringElementType;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.XsdRenameResolution;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.XsdResolution;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.XsdResolutions;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.XsdTaskResolution;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.XsdVirtualModel;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.text.IntBasedHash;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.Version;
import com.hello2morrow.sonargraph.integration.access.foundation.AggregatingClassLoader;
import com.hello2morrow.sonargraph.integration.access.persistence.XmlPersistenceContext;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;

final class VirtualModelWriter
extends AbstractVirtualModelIO {
    private final ObjectFactory m_xsdFactory = new ObjectFactory();

    VirtualModelWriter(Version productVersion, AggregatingClassLoader aggregatingClassLoader, XmlPersistenceContext persistenceContext) {
        super(productVersion, aggregatingClassLoader, persistenceContext);
    }

    OperationResult save(IPersistableVirtualModel persistableVirtualModel) {
        assert (persistableVirtualModel != null) : "Parameter 'persistableVirtualModel' of method 'save' must not be null";
        try {
            JAXBElement<XsdVirtualModel> xsdModel = this.createXsdModel(persistableVirtualModel);
            TFile file = persistableVirtualModel.getFile();
            TFile modelsDir = file.getParentFile();
            if (!modelsDir.exists() || !modelsDir.isDirectory()) {
                modelsDir.mkdir();
            }
            OperationResult result = new OperationResult("Persist virtual model '" + FileUtility.getFileNameWithoutExtension((TFile)file) + "'");
            try {
                Throwable throwable = null;
                Object var7_11 = null;
                try (TFileOutputStream outputStream = new TFileOutputStream((File)file);){
                    this.createJaxbAadpter().save(xsdModel, (OutputStream)outputStream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, (Throwable)ex, "Failed to save virtual model to file '" + file.getNormalizedAbsolutePath() + "'", new Object[0]);
            }
            return result;
        }
        catch (DatatypeConfigurationException ex) {
            OperationResult result = new OperationResult("Persist virtual model '" + persistableVirtualModel.getName() + "'");
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, (Throwable)ex);
            return result;
        }
    }

    private JAXBElement<XsdVirtualModel> createXsdModel(IPersistableVirtualModel model) throws DatatypeConfigurationException {
        assert (model != null) : "Parameter 'model' of method 'persist' must not be null";
        XsdVirtualModel xsdVirtualModel = this.m_xsdFactory.createXsdVirtualModel();
        JAXBElement<XsdVirtualModel> element = this.m_xsdFactory.createVirtualModel(xsdVirtualModel);
        xsdVirtualModel.setVersion(this.getProductVersion().toString());
        String basedOn = model.getBasedOnPersistableVirtualModel();
        if (basedOn != null && !basedOn.isEmpty()) {
            xsdVirtualModel.setBasedOn(basedOn);
        }
        NamedElement modelAsNamedElement = model.getNamedElement();
        xsdVirtualModel.setDescription(modelAsNamedElement.getDescription());
        XsdResolutions xsdResolutions = this.m_xsdFactory.createXsdResolutions();
        xsdVirtualModel.setResolutions(xsdResolutions);
        DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
        for (Resolution resolution : modelAsNamedElement.getChildren(Resolution.class)) {
            XsdResolution xsdResolution = null;
            if (resolution instanceof IgnoreDefinition) {
                xsdResolution = this.m_xsdFactory.createXsdIgnoreResolution();
                this.addCoreResolutionInfoToXml(datatypeFactory, resolution, xsdResolution);
            } else if (resolution instanceof FixDefinition) {
                xsdResolution = this.m_xsdFactory.createXsdFixResolution();
                this.addTaskResolutionInfoToXml(datatypeFactory, (TaskDefinition)resolution, (XsdTaskResolution)xsdResolution);
            } else if (resolution instanceof ToDoDefinition) {
                xsdResolution = this.m_xsdFactory.createXsdToDoResolution();
                this.addTaskResolutionInfoToXml(datatypeFactory, (TaskDefinition)resolution, (XsdTaskResolution)xsdResolution);
            } else if (resolution instanceof DeleteRefactoringDefinition) {
                XsdDeleteResolution xsdDelete = this.m_xsdFactory.createXsdDeleteResolution();
                DeleteRefactoringDefinition delete = (DeleteRefactoringDefinition)resolution;
                this.addTaskResolutionInfoToXml(datatypeFactory, delete, xsdDelete);
                if (delete.isIncludingRecursiveElementChildren()) {
                    xsdDelete.setIncludeRecursiveElementChildren(Boolean.TRUE);
                }
                xsdResolution = xsdDelete;
            } else if (resolution instanceof MoveRenameRefactoringDefinition) {
                MoveRenameRefactoringDefinition moveRename = (MoveRenameRefactoringDefinition)resolution;
                XsdMoveRenameResolution xsdMoveRename = this.m_xsdFactory.createXsdMoveRenameResolution();
                this.addTaskResolutionInfoToXml(datatypeFactory, moveRename, xsdMoveRename);
                this.addLanguageSpecificRefactoringDefinitionInfoToXml(moveRename, xsdMoveRename);
                xsdMoveRename.setTargetRootDirectory(moveRename.getTargetRootDirectoryFqName());
                xsdMoveRename.setMoveToParentName(moveRename.getMoveToParentName());
                xsdMoveRename.setNewName(moveRename.getNewName());
                xsdResolution = xsdMoveRename;
            } else if (resolution instanceof MoveRefactoringDefinition) {
                XsdMoveResolution xsdMove = this.m_xsdFactory.createXsdMoveResolution();
                MoveRefactoringDefinition move = (MoveRefactoringDefinition)resolution;
                this.addTaskResolutionInfoToXml(datatypeFactory, move, xsdMove);
                this.addLanguageSpecificRefactoringDefinitionInfoToXml(move, xsdMove);
                xsdMove.setTargetRootDirectory(move.getTargetRootDirectoryFqName());
                xsdMove.setMoveToParentName(move.getMoveToParentName());
                xsdResolution = xsdMove;
            } else if (resolution instanceof RenameRefactoringDefinition) {
                XsdRenameResolution xsdRename = this.m_xsdFactory.createXsdRenameResolution();
                RenameRefactoringDefinition rename = (RenameRefactoringDefinition)resolution;
                this.addTaskResolutionInfoToXml(datatypeFactory, rename, xsdRename);
                this.addLanguageSpecificRefactoringDefinitionInfoToXml(rename, xsdRename);
                xsdRename.setNewName(rename.getNewName());
                xsdResolution = xsdRename;
            } else assert (false) : "Unsupported resolution type '" + resolution.getClass().getName() + "'";
            assert (xsdResolution != null) : "xsdResolution must not be null!";
            xsdResolutions.getIgnoreOrFixOrTodo().add(xsdResolution);
        }
        return element;
    }

    private void addTaskResolutionInfoToXml(DatatypeFactory datatypeFactory, TaskDefinition resolution, XsdTaskResolution xsdResolution) {
        this.addCoreResolutionInfoToXml(datatypeFactory, resolution, xsdResolution);
        xsdResolution.setAssignedTo(resolution.getAssignee());
        Priority priority = resolution.getPriority();
        switch (priority) {
            case LOW: {
                xsdResolution.setPriority(XsdPriority.LOW);
                break;
            }
            case MEDIUM: {
                xsdResolution.setPriority(XsdPriority.MEDIUM);
                break;
            }
            case HIGH: {
                xsdResolution.setPriority(XsdPriority.HIGH);
                break;
            }
            case NONE: {
                xsdResolution.setPriority(XsdPriority.NONE);
                break;
            }
            default: {
                assert (false) : "Unhandled priority: " + String.valueOf((Object)priority);
                break;
            }
        }
    }

    private void addLanguageSpecificRefactoringDefinitionInfoToXml(LanguageSpecificRefactoringDefinition definition, XsdLanguageSpecificRefactoringDefinition xsdDefinition) {
        assert (definition != null) : "Parameter 'definition' of method 'addLanguageSpecificRefactoringDefinitionInfoToXml' must not be null";
        assert (xsdDefinition != null) : "Parameter 'xsdDefinition' of method 'addLanguageSpecificRefactoringDefinitionInfoToXml' must not be null";
        xsdDefinition.setLanguage(definition.getDefinedForLanguage());
        MoveRenameRefactoringElementType type = definition.getRefactoringElementType();
        switch (type) {
            case ELEMENT: {
                xsdDefinition.setElementType(XsdRefactoringElementType.ELEMENT);
                break;
            }
            case COMPONENT: {
                xsdDefinition.setElementType(XsdRefactoringElementType.COMPONENT);
                break;
            }
            case DIRECTORY: {
                xsdDefinition.setElementType(XsdRefactoringElementType.DIRECTORY);
                break;
            }
            case NAMESPACE: {
                xsdDefinition.setElementType(XsdRefactoringElementType.NAMESPACE);
                break;
            }
            default: {
                assert (false) : "Unhandled refactoring element type: " + String.valueOf((Object)type);
                break;
            }
        }
    }

    private void addCoreResolutionInfoToXml(DatatypeFactory datatypeFactory, Resolution resolution, XsdResolution xsdResolution) {
        Object xsdPattern;
        assert (datatypeFactory != null) : "Parameter 'datatypeFactory' of method 'addCoreResolutionInfoToXml' must not be null";
        assert (resolution != null) : "Parameter 'resolution' of method 'addCoreResolutionInfoToXml' must not be null";
        assert (xsdResolution != null) : "Parameter 'xsdResolution' of method 'addCoreResolutionInfoToXml' must not be null";
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        calendar.setTime(resolution.getDate());
        xsdResolution.setDate(datatypeFactory.newXMLGregorianCalendar(calendar));
        xsdResolution.setDescription(resolution.getDescription());
        Matching matchingInfo = resolution.getUniqueChild(Matching.class);
        if (matchingInfo != null) {
            XsdMatching xsdMatching = this.m_xsdFactory.createXsdMatching();
            xsdMatching.setInfo(matchingInfo.getInformation());
            for (Pair<String, IntBasedHash> next : matchingInfo.getElementFqNamesAndHashs()) {
                XsdElementPattern xsdElementPattern = this.m_xsdFactory.createXsdElementPattern();
                xsdElementPattern.setType(XsdElementPatternType.FULLY_QUALIFIED_NAME);
                xsdElementPattern.setValue((String)next.getFirst());
                if (next.getSecond() != null) {
                    xsdElementPattern.setHash(IntBasedHash.encode((IntBasedHash)((IntBasedHash)next.getSecond())));
                }
                xsdMatching.getElementPattern().add(xsdElementPattern);
            }
            xsdResolution.setMatching(xsdMatching);
        }
        IssueType type = resolution.getUniqueChild(IssueType.class);
        XsdIssueType xsdIssueType = this.m_xsdFactory.createXsdIssueType();
        if (type instanceof DynamicIssueType) {
            DynamicIssueType dynamicIssueType = (DynamicIssueType)type;
            if (type.getIssueId().getClass().equals(ScriptIssueId.class)) {
                xsdIssueType.setClazz("Script");
                xsdIssueType.setName(type.getIssueId().getStandardName());
                List<Severity> supportedSeverities = type.getIssueId().getSupportedSeverities();
                assert (supportedSeverities.size() == 1) : "Unexpected severities for script issue: " + String.valueOf(supportedSeverities);
                xsdIssueType.setDescriptor(dynamicIssueType.getIssueProviderIdStandardName() + ENTRY_SEPARATOR + supportedSeverities.get(0).getStandardName());
            } else if (type.getIssueId().getClass().equals(PluginIssueId.class)) {
                PluginIssueId pluginIssueId = (PluginIssueId)type.getIssueId();
                xsdIssueType.setClazz("Plugin");
                xsdIssueType.setName(pluginIssueId.getStandardName());
                xsdIssueType.setDescriptor(dynamicIssueType.getKey());
            } else if (type.getIssueId() instanceof ArchitectureCheckIssueId) {
                xsdIssueType.setClazz("Architecture");
                xsdIssueType.setName(type.getIssueId().getStandardName());
                xsdIssueType.setDescriptor(dynamicIssueType.getKey());
            } else assert (false) : "Unhandled dynamic issue type: " + String.valueOf(dynamicIssueType);
        } else {
            xsdIssueType.setClazz(type.getIssueId().getClass().getCanonicalName());
            String string = type.getIssueId().getStandardName();
            xsdIssueType.setName(string);
            if (!type.getKey().equals(type.getIssueId().getStandardName())) {
                xsdIssueType.setDescriptor(type.getKey());
            }
        }
        xsdResolution.setType(xsdIssueType);
        for (NamedElementWildcardPattern namedElementWildcardPattern : resolution.getChildren(NamedElementWildcardPattern.class)) {
            xsdPattern = this.m_xsdFactory.createXsdElementPattern();
            ((XsdElementPattern)xsdPattern).setType(XsdElementPatternType.WILDCARD);
            ((XsdElementPattern)xsdPattern).setValue(namedElementWildcardPattern.getPattern());
            xsdResolution.getElementPattern().add((XsdElementPattern)xsdPattern);
        }
        for (NamedElementFullyQualifiedNamePattern namedElementFullyQualifiedNamePattern : resolution.getChildren(NamedElementFullyQualifiedNamePattern.class)) {
            xsdPattern = this.m_xsdFactory.createXsdElementPattern();
            ((XsdElementPattern)xsdPattern).setType(XsdElementPatternType.FULLY_QUALIFIED_NAME);
            if (namedElementFullyQualifiedNamePattern instanceof LineBasedContextSimilarityMatchPattern) {
                LineBasedContextSimilarityMatchPattern contextSimilarityMatchPattern = (LineBasedContextSimilarityMatchPattern)namedElementFullyQualifiedNamePattern;
                String hash = contextSimilarityMatchPattern.getHash();
                ((XsdElementPattern)xsdPattern).setHash(hash);
                ((XsdElementPattern)xsdPattern).setValue(contextSimilarityMatchPattern.getPatternForPersistence());
            } else {
                ((XsdElementPattern)xsdPattern).setValue(namedElementFullyQualifiedNamePattern.getPattern());
            }
            xsdResolution.getElementPattern().add((XsdElementPattern)xsdPattern);
        }
        for (DependencyWildcardPattern dependencyWildcardPattern : resolution.getChildren(DependencyWildcardPattern.class)) {
            xsdPattern = this.m_xsdFactory.createXsdDependencyPattern();
            ((XsdDependencyPattern)xsdPattern).setType(XsdDependencyPatternType.WILDCARD);
            ((XsdDependencyPattern)xsdPattern).setFrom(dependencyWildcardPattern.getFromPattern());
            ((XsdDependencyPattern)xsdPattern).setTo(dependencyWildcardPattern.getToPattern());
            xsdResolution.getDependencyPattern().add((XsdDependencyPattern)xsdPattern);
        }
        for (ParserDependencyEndpointPattern parserDependencyEndpointPattern : resolution.getChildren(ParserDependencyEndpointPattern.class)) {
            xsdPattern = this.m_xsdFactory.createXsdDependencyPattern();
            ((XsdDependencyPattern)xsdPattern).setType(XsdDependencyPatternType.PARSER_DEPENDENCY_ENDPOINT);
            ((XsdDependencyPattern)xsdPattern).setFrom(parserDependencyEndpointPattern.getFromPattern());
            ((XsdDependencyPattern)xsdPattern).setTo(parserDependencyEndpointPattern.getToPattern());
            xsdResolution.getDependencyPattern().add((XsdDependencyPattern)xsdPattern);
        }
        for (PatternBasedCycleIgnoreFilter patternBasedCycleIgnoreFilter : resolution.getChildren(PatternBasedCycleIgnoreFilter.class)) {
            XsdPatternFilter xsdPatternFilter = this.m_xsdFactory.createXsdPatternFilter();
            PatternBasedCycleIgnoreFilterData data = patternBasedCycleIgnoreFilter.getFilterData();
            xsdResolution.setPatternFilter(xsdPatternFilter);
            xsdPatternFilter.setMaxSize(BigInteger.valueOf(data.getMaximumSize()));
            xsdPatternFilter.setName(data.getName());
            xsdPatternFilter.setKind(data.getKind().name());
            List<XsdIncludePattern> includeFilters = xsdPatternFilter.getIncludes();
            for (PatternBasedCycleIgnoreFilterData.Pattern inc : data.getIncludePatterns()) {
                XsdIncludePattern xsdInc = this.m_xsdFactory.createXsdIncludePattern();
                xsdInc.setMandatory(inc.isMandatory());
                xsdInc.setPattern(inc.getPattern());
                includeFilters.add(xsdInc);
            }
            List<String> excludeFilters = xsdPatternFilter.getExcludes();
            for (PatternBasedCycleIgnoreFilterData.Pattern excl : data.getExcludePatterns()) {
                excludeFilters.add(excl.getPattern());
            }
        }
    }

    void save(IPersistableVirtualModel modifiableModel, OutputStream outputStream, OperationResult result) {
        assert (modifiableModel != null) : "Parameter 'modifiableModel' of method 'save' must not be null";
        assert (outputStream != null) : "Parameter 'outputStream' of method 'save' must not be null";
        assert (result != null) : "Parameter 'result' of method 'save' must not be null";
        try {
            JAXBElement<XsdVirtualModel> xsdModel = this.createXsdModel(modifiableModel);
            this.createJaxbAadpter().save(xsdModel, outputStream);
        }
        catch (IOException | DatatypeConfigurationException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, (Throwable)ex);
        }
    }
}

