/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ApplicationData {
    private final Map<RefactoringDefinition, List<Element>> m_refactoringDefinitionsBefore = new HashMap<RefactoringDefinition, List<Element>>();
    private final Map<RefactoringDefinition, List<Element>> m_refactoringDefinitionsAfter = new HashMap<RefactoringDefinition, List<Element>>();
    private final Set<Issue> m_issuesBefore = new THashSet();
    private final Set<Issue> m_issuesAfter = new THashSet();
    private final List<Resolution> m_toBeDeleted;
    private boolean m_started;

    ApplicationData(List<Resolution> toBeDeleted) {
        assert (toBeDeleted != null) : "Parameter 'toBeDeleted' of method 'ApplicationData' must not be null";
        this.m_toBeDeleted = new ArrayList<Resolution>(toBeDeleted);
    }

    ApplicationData() {
        this.m_toBeDeleted = Collections.emptyList();
    }

    List<Resolution> getToBeDeleted() {
        return Collections.unmodifiableList(this.m_toBeDeleted);
    }

    void start() {
        assert (!this.m_started) : "Already started";
        this.m_started = true;
    }

    boolean hasBeenStarted() {
        return this.m_started;
    }

    void addIssuesBefore(List<Issue> issues) {
        assert (issues != null) : "Parameter 'issues' of method 'addIssuesBefore' must not be null";
        this.m_issuesBefore.addAll(issues);
    }

    void addIssuesAfter(List<Issue> issues) {
        assert (issues != null) : "Parameter 'issues' of method 'addIssuesAfter' must not be null";
        this.m_issuesAfter.addAll(issues);
    }

    void addRefactoringBefore(RefactoringDefinition refactoringDefinition, List<Element> elements) {
        assert (refactoringDefinition != null) : "Parameter 'refactoringDefinition' of method 'addRefactoringBefore' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'addRefactoringBefore' must not be null";
        this.m_refactoringDefinitionsBefore.put(refactoringDefinition, elements);
    }

    void addRefactoringAfter(RefactoringDefinition refactoringDefinition, List<Element> elements) {
        assert (refactoringDefinition != null) : "Parameter 'refactoringDefinition' of method 'addRefactoringAfter' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'addRefactoringAfter' must not be null";
        this.m_refactoringDefinitionsAfter.put(refactoringDefinition, elements);
    }

    void consume(VirtualModel model) {
        assert (model != null) : "Parameter 'model' of method 'consume' must not be null";
        if (!this.m_issuesBefore.equals(this.m_issuesAfter)) {
            THashSet removed = new THashSet(this.m_issuesBefore);
            removed.removeAll(this.m_issuesAfter);
            if (!removed.isEmpty()) {
                model.issuesRemoved(new ArrayList<Issue>((Collection<Issue>)removed));
            }
            this.m_issuesAfter.removeAll(this.m_issuesBefore);
            if (!this.m_issuesAfter.isEmpty()) {
                model.issuesAdded(new ArrayList<Issue>(this.m_issuesAfter));
            }
        }
        if (!this.m_refactoringDefinitionsBefore.equals(this.m_refactoringDefinitionsAfter)) {
            model.refactoringsModified();
        }
        this.m_issuesBefore.clear();
        this.m_issuesAfter.clear();
        this.m_refactoringDefinitionsBefore.clear();
        this.m_refactoringDefinitionsAfter.clear();
    }

    boolean hasBeforeAfterInfo() {
        return !this.m_issuesBefore.isEmpty() || !this.m_issuesAfter.isEmpty() || !this.m_refactoringDefinitionsBefore.isEmpty() || !this.m_refactoringDefinitionsAfter.isEmpty();
    }
}

