/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.script;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.script.ParameterType;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class ParameterDefinition<V>
extends NamedElement {
    private final String m_name;
    private final String m_description;
    private final boolean m_predefined;
    private final V m_defaultValue;
    private final Set<V> m_possibleValues;

    public ParameterDefinition(Builder<V> builder) {
        super(null);
        assert (builder != null) : "Parameter 'builder' of method 'ParameterDefinition' must not be null";
        this.m_name = builder.m_name;
        this.m_description = builder.m_description;
        this.m_predefined = builder.m_predefined;
        this.m_defaultValue = builder.m_defaultValue;
        this.m_possibleValues = builder.m_possibleValues;
    }

    @Override
    public final String getShortName() {
        return this.m_name;
    }

    @Override
    public final String getDescription() {
        return this.m_description;
    }

    public boolean isPredefined() {
        return this.m_predefined;
    }

    @Property
    public abstract Class<?> getParameterClass();

    @Property
    public final V getDefaultValue() {
        return this.m_defaultValue;
    }

    public final String getDefaultValueAsString() {
        return this.format(this.m_defaultValue);
    }

    public boolean hasPossibleValues() {
        return this.m_possibleValues != null && !this.m_possibleValues.isEmpty();
    }

    @Property
    public Set<V> getPossibleValues() {
        return this.m_possibleValues;
    }

    @Property
    public abstract ParameterType getType();

    public String getPossibleValuesAsString() {
        if (!this.hasPossibleValues()) {
            return "";
        }
        ArrayList<String> result = new ArrayList<String>();
        for (V next : this.getPossibleValues()) {
            result.add(this.format(next));
        }
        return StringUtility.concat(result, (String)" ");
    }

    public String format(V value) {
        return value != null ? value.toString() : null;
    }

    public abstract V parse(String var1);

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_defaultValue.hashCode();
        result = 31 * result + this.m_description.hashCode();
        result = 31 * result + this.m_name.hashCode();
        result = 31 * result + this.m_possibleValues.hashCode();
        result = 31 * result + (this.m_predefined ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ParameterDefinition other = (ParameterDefinition)obj;
        return this.m_defaultValue.equals(other.m_defaultValue) && this.m_description.equals(other.m_description) && this.m_name.equals(other.m_name) && this.m_possibleValues.equals(other.m_possibleValues) && this.m_predefined == other.m_predefined;
    }

    public static abstract class Builder<V> {
        private final String m_name;
        private String m_description;
        private boolean m_predefined;
        private V m_defaultValue;
        private Set<V> m_possibleValues;

        public Builder(String name, V defaultValue) {
            assert (name != null && name.length() > 0) : "Parameter 'name' of method 'Builder' must not be empty";
            assert (defaultValue != null) : "Parameter 'defaultValue' of method 'Builder' must not be null";
            this.m_name = name;
            this.m_description = "";
            this.m_predefined = false;
            this.m_possibleValues = new LinkedHashSet<V>();
            this.m_defaultValue = defaultValue;
        }

        public Builder<V> description(String description) {
            assert (description != null) : "Parameter 'description' of method 'description' must not be null";
            this.m_description = description;
            return this;
        }

        public Builder<V> predefined(boolean predefined) {
            this.m_predefined = predefined;
            return this;
        }

        public Builder<V> defaultValue(V defaultValue) {
            assert (defaultValue != null) : "Parameter 'defaultValue' of method 'defaultValue' must not be null";
            this.m_defaultValue = defaultValue;
            return this;
        }

        public Builder<V> candidates(Set<V> candidates) {
            assert (candidates != null) : "Parameter 'candidates' of method 'candidates' must not be null";
            this.m_possibleValues = candidates;
            return this;
        }

        public Builder<V> candidates(String newCandidates) {
            assert (newCandidates != null) : "Parameter 'newCandidates' of method 'candidates' must not be null";
            LinkedHashSet<V> candidates = new LinkedHashSet<V>();
            for (String next : StringUtility.splitAndTrim((String)newCandidates.trim(), (String)" ")) {
                candidates.add(this.parse(next));
            }
            this.m_possibleValues = candidates;
            return this;
        }

        public String getName() {
            return this.m_name;
        }

        public String getDescription() {
            return this.m_description;
        }

        public V getDefaultValue() {
            return this.m_defaultValue;
        }

        public Set<V> getCandidates() {
            return this.m_possibleValues;
        }

        public boolean isPredefined() {
            return this.m_predefined;
        }

        public abstract ParameterDefinition<V> build();

        protected abstract V parse(String var1);

        public Builder<V> parseDefaultValue(String newDefaultValue) {
            assert (newDefaultValue != null) : "Parameter 'newDefaultValue' of method 'parseDefaultValue' must not be null";
            this.m_defaultValue = this.parse(newDefaultValue);
            return this;
        }

        public String toString() {
            return this.m_name;
        }
    }
}

