/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.refactoring;

import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementRenameRefactoringIssue;
import com.hello2morrow.sonargraph.core.model.element.Priority;
import com.hello2morrow.sonargraph.core.model.refactoring.IRefactoringAdapter;
import com.hello2morrow.sonargraph.core.model.refactoring.LanguageSpecificRefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRenameRefactoringElementType;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringType;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import java.util.Date;

public final class RenameRefactoringDefinition
extends LanguageSpecificRefactoringDefinition {
    public static final IIssueId ASSOCIATED_ISSUE_ID = CoreIssueId.RENAME_REFACTORING;
    private final String m_newName;

    public static String getDescription(String toName) {
        assert (toName != null) : "Parameter 'toName' of method 'getDescription' must not be null";
        return "Rename to '" + toName + "'";
    }

    public RenameRefactoringDefinition(NamedElement parent, Date date, String assignee, String description, Priority priority, String definedForLanguage, MoveRenameRefactoringElementType elementType, String newName) {
        super(parent, date, assignee, description, priority, definedForLanguage, elementType);
        assert (newName != null && newName.length() > 0) : "Parameter 'newName' of method 'RenameRefactoringDefinition' must not be empty";
        this.m_newName = newName;
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.RENAME;
    }

    @Property
    public String getNewName() {
        return this.m_newName;
    }

    @Override
    public String getName() {
        return "Rename Refactoring";
    }

    @Override
    public String getShortName() {
        return "Rename";
    }

    @Override
    public IIssueId getAssociatedIssueId() {
        return ASSOCIATED_ISSUE_ID;
    }

    @Override
    public Issue createAssociatedIssue(Element element, String descriptor) {
        assert (element != null) : "Parameter 'element' of method 'createAssociatedIssue' must not be null";
        assert (descriptor != null && descriptor.length() > 0) : "Parameter 'descriptor' of method 'createAssociatedIssue' must not be empty";
        assert (element != null && element instanceof NamedElement) : "Unexpected class in method 'createAssociatedIssue': " + String.valueOf(element);
        return new NamedElementRenameRefactoringIssue((NamedElement)element, descriptor, RenameRefactoringDefinition.getDescription(this.m_newName));
    }

    @Override
    public String getTargetFqName(String nonMatchingFqName, IRefactoringAdapter refactoringAdapter) {
        assert (nonMatchingFqName != null && nonMatchingFqName.length() > 0) : "Parameter 'nonMatchingFqName' of method 'getTargetFqName' must not be empty";
        assert (refactoringAdapter != null) : "Parameter 'refactoringAdapter' of method 'getTargetFqName' must not be null";
        int pos = nonMatchingFqName.lastIndexOf(58);
        if (pos != -1) {
            String nextName = nonMatchingFqName.substring(pos + 1);
            String nextRenamedName = refactoringAdapter.getTargetElementName(nextName, this.getNewName(), this.getRefactoringElementType());
            return nonMatchingFqName.substring(0, pos + 1) + nextRenamedName;
        }
        return null;
    }
}

