/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.path;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.IBaseDirectory;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModifiablePathListener;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import de.schlichtherle.truezip.file.TFile;

public abstract class ModifiableFile
extends FilePath
implements IModifiableFile {
    private final IModifiablePathListener m_listener;
    private String m_fileId;
    private boolean m_existsOnDisk;
    private boolean m_needsSave;

    protected ModifiableFile(NamedElement parent, TFile file, IModifiablePathListener listener) {
        super(parent, file);
        assert (listener != null) : "IModifiableFileListener for ModifiableFile must not be null";
        this.m_existsOnDisk = file.exists();
        this.createNewFileId();
        this.m_listener = listener;
        this.m_listener.created(this);
    }

    protected ModifiableFile(NamedElement parent, ModifiableFile other) {
        super(parent, other.getFile());
        this.m_listener = other.m_listener;
        this.m_existsOnDisk = other.m_existsOnDisk;
        this.m_fileId = other.m_fileId;
    }

    public final void reSync() {
        this.setExistsOnDisk(this.getFile().exists());
        this.resetTimestamp();
    }

    public final void setExistsOnDisk(boolean exists) {
        if (exists != this.m_existsOnDisk) {
            this.m_existsOnDisk = exists;
            this.m_listener.additionalInformationModified(this);
        }
    }

    @Override
    public final boolean existsOnDisk() {
        return this.m_existsOnDisk;
    }

    public final void reloaded(long timestamp, boolean needsSave) {
        this.setTimestamp(timestamp);
        this.m_needsSave = needsSave;
        this.m_listener.reloaded(this);
    }

    @Override
    public final String getIdentifyingPath() {
        return this.getName();
    }

    @Override
    public final void reallocate() {
        String previous = this.getPath();
        DirectoryPath parent = this.getParent(DirectoryPath.class, new Class[0]);
        if (parent != null && !(parent instanceof IBaseDirectory)) {
            String ownPath = this.getPath();
            int pos = ownPath.lastIndexOf("/");
            assert (pos != -1) : "No path separator found: " + ownPath;
            String parentPath = parent.getPath();
            assert (parentPath != null && parentPath.length() > 0) : "'parentPath' of method 'reallocate' must not be empty";
            this.setPath(parentPath + ownPath.substring(pos));
        }
        this.resetFile();
        this.getFile();
        this.m_listener.pathModified(this, previous);
    }

    @Override
    public final void createNewFileId() {
        this.m_fileId = StringUtility.createTimebasedId((String)this.getName());
    }

    @Override
    public final boolean persist(ISnapshotProcessor.Mode mode) {
        return false;
    }

    @Override
    public final boolean needsSave() {
        return this.m_needsSave;
    }

    @Override
    public final void setNeedsSave(boolean needsSave) {
        this.m_needsSave = needsSave;
        if (this.m_needsSave) {
            this.m_listener.modified(this);
        } else {
            this.m_listener.saved(this);
            this.resetTimestamp();
        }
    }

    @Override
    public void setPath(TFile path) {
        String previous = this.getPath();
        super.setPath(path);
        this.m_listener.pathModified(this, previous);
    }

    protected final void modified() {
        this.m_listener.modified(this);
    }

    protected final void additionalInformationModified() {
        this.m_listener.additionalInformationModified(this);
    }

    @Override
    public final String getFileId() {
        return this.m_fileId;
    }

    @Override
    public final void remove() {
        this.m_listener.deleted(this);
        super.remove();
    }

    @Override
    public final void parentRemoved() {
        this.m_listener.deleted(this);
        super.parentRemoved();
    }

    @Override
    public final void resetTimestamp() {
        this.setTimestamp(this.getFile().lastModified());
    }
}

