/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.path;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.IDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.Path;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.List;
import java.util.Stack;

public abstract class DirectoryPath
extends Path
implements IDirectoryPath {
    private static boolean checkForPathUpInPath(String relativePath) {
        String test = relativePath;
        String prefix = "../";
        while (test.startsWith("../")) {
            test = test.substring("../".length(), test.length());
        }
        return test.contains("..");
    }

    private static void checkRelativeDirectoryPath(String relativeDirectoryPath) {
        assert (relativeDirectoryPath != null) : "Parameter 'relativeDirectoryPath' of method 'checkRelativeDirectoryPath' must not be null";
        if (relativeDirectoryPath.equals(".") || relativeDirectoryPath.equals("..")) {
            return;
        }
        assert (relativeDirectoryPath.indexOf(92) == -1) : "'relativeDirectoryPath' must not contain '\\': " + relativeDirectoryPath;
        assert (!relativeDirectoryPath.startsWith("/") && !relativeDirectoryPath.endsWith("/")) : "'relativeDirectoryPath' must not start/end with '/': " + relativeDirectoryPath;
        assert (!DirectoryPath.checkForPathUpInPath(relativeDirectoryPath)) : "'relativeDirectoryPath' must not contain '/../': " + relativeDirectoryPath;
        assert (relativeDirectoryPath.startsWith(".") || relativeDirectoryPath.startsWith("..")) : "'relativeDirectoryPath' must start with '.' or '..': " + relativeDirectoryPath;
        assert (!relativeDirectoryPath.contains("/./")) : "'relativeDirectoryPath' must not contain '/./': " + relativeDirectoryPath;
        assert (relativeDirectoryPath.length() == 1 || !relativeDirectoryPath.endsWith(".")) : "'relativeDirectoryPath' must not end with '.': " + relativeDirectoryPath;
        assert (relativeDirectoryPath.length() == 1 || relativeDirectoryPath.startsWith("..") || relativeDirectoryPath.charAt(1) == '/') : "Parameter 'relativeDirectoryPath' of method 'checkRelativeDirectoryPath' must start with './'";
        assert (relativeDirectoryPath.length() < 3 || !relativeDirectoryPath.startsWith("..") || relativeDirectoryPath.charAt(2) == '/') : "Parameter 'relativeDirectoryPath' of method 'checkRelativeDirectoryPath' must start with '../'";
    }

    public DirectoryPath(NamedElement parent) {
        super(parent);
    }

    protected DirectoryPath(NamedElement parent, TFile file) {
        super(parent, file);
    }

    protected DirectoryPath(NamedElement parent, String relativeDirectoryPath) {
        super(parent, relativeDirectoryPath);
        DirectoryPath.checkRelativeDirectoryPath(relativeDirectoryPath);
    }

    @Override
    public final NamedElement getNamedElement() {
        return this;
    }

    @Override
    public String getImageResourceName() {
        return DirectoryPath.class.getSimpleName();
    }

    @Override
    protected void lastChildRemoved() {
        this.remove();
    }

    @Override
    public boolean removeOnLastChildRemoval() {
        return true;
    }

    public final boolean isOwnerOf(TFile file) {
        assert (file != null) : "Parameter 'file' of method 'isOwnerOf' must not be null";
        TFile root = this.getFile();
        return root.equals((Object)file) || root.isParentOf((File)file);
    }

    public boolean isAutomatic() {
        return false;
    }

    public final DirectoryPath getDirectoryPath(IDirectoryPathCreator creator, TFile directory) {
        assert (creator != null) : "Parameter 'creator' of method 'getDirectoryPath' must not be null";
        assert (directory != null) : "Parameter 'directory' of method 'getDirectoryPath' must not be null";
        Stack<TFile> parents = new Stack<TFile>();
        DirectoryPath current = this;
        TFile currentDirectory = directory;
        while (!FileUtility.areEqual((TFile)currentDirectory, (TFile)this.getFile())) {
            parents.push(currentDirectory);
            currentDirectory = currentDirectory.getParentFile();
        }
        while (!parents.isEmpty()) {
            DirectoryPath found = null;
            currentDirectory = (TFile)parents.pop();
            List<DirectoryPath> directoryPaths = current.getChildren(DirectoryPath.class);
            for (DirectoryPath nextDirectoryPath : directoryPaths) {
                if (!nextDirectoryPath.getFile().equals((Object)currentDirectory)) continue;
                found = nextDirectoryPath;
                break;
            }
            if (found == null) {
                found = creator.create(current, currentDirectory);
                current.addChild(found);
            }
            current = found;
        }
        return current;
    }

    public boolean isRootDirectory() {
        return false;
    }

    public boolean mayContainSourceFiles() {
        return false;
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitDirectoryPath(this);
        } else {
            super.accept(visitor);
        }
    }

    @Override
    public boolean ignoreInModelRepresentation() {
        return false;
    }

    public static interface IDirectoryPathCreator {
        public DirectoryPath create(NamedElement var1, TFile var2);
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitDirectoryPath(DirectoryPath var1);
    }
}

