/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.path;

import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.IBaseDirectory;
import com.hello2morrow.sonargraph.core.model.path.IDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.PhysicalRecursiveElement;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.StringTokenizer;

public abstract class DirectoryFragment
extends PhysicalRecursiveElement
implements IDirectoryPath {
    public static final String DIRECTORY_FRAGMENT = "DirectoryFragment";
    public static final String DIRECTORY_FRAGMENT_PART = "DirectoryFragmentPart";
    private static final boolean CASE_SENSITIVE_FILENAMES = Platform.isCaseSensitive();

    public DirectoryFragment(NamedElement parent) {
        super(parent);
    }

    public DirectoryFragment(IModelServiceProvider msp, NamedElement parent, String shortName) {
        super(msp, parent, shortName);
    }

    private static boolean checkDirectoryNameEquality(String name1, String name2) {
        assert (name1 != null);
        assert (name2 != null);
        if (CASE_SENSITIVE_FILENAMES) {
            return name1.equals(name2);
        }
        return name1.equalsIgnoreCase(name2);
    }

    public static IDirectoryPath getDirectoryFragmentOrSpecifiedParent(IModelServiceProvider msp, IDirectoryPath parent, String directory, IDirectoryFragmentCreator creator) {
        assert (parent != null) : "Parameter 'parent' of method 'getDirectoryFragmentOrSpecifiedParent' must not be null";
        assert (directory != null) : "Parameter 'namespace' of method 'getDirectoryFragmentOrSpecifiedParent' must not be null";
        assert (creator != null) : "Parameter 'creator' of method 'getDirectoryFragmentOrSpecifiedParent' must not be null";
        if (".".equals(directory)) {
            return parent;
        }
        String directoryPath = directory;
        if (directoryPath.startsWith("./")) {
            directoryPath = directoryPath.substring("./".length());
        }
        if (directoryPath.isEmpty()) {
            return parent;
        }
        String separator = "/";
        StringTokenizer tokenizer = new StringTokenizer(directoryPath, "/");
        IDirectoryPath current = parent;
        while (tokenizer.hasMoreTokens()) {
            String nextDirectoryName = tokenizer.nextToken();
            assert (nextDirectoryName != null && nextDirectoryName.length() > 0) : "'nextDirectoryName' of method 'getDirectoryFragmentOrSpecifiedParent' must not be empty";
            DirectoryFragment found = null;
            for (DirectoryFragment nextDirectoryFragment : current.getNamedElement().getChildren(DirectoryFragment.class)) {
                if (!DirectoryFragment.checkDirectoryNameEquality(nextDirectoryFragment.getShortName(), nextDirectoryName)) continue;
                if (!creator.accept(nextDirectoryFragment)) break;
                found = nextDirectoryFragment;
            }
            if (found == null) {
                found = creator.create(msp, current.getNamedElement(), nextDirectoryName);
                NamedElement parentUsed = found.getParent();
                assert (parentUsed != null) : "Parameter 'parentUsed' of method 'getDirectoryFragmentOrSpecifiedParent' must not be null";
                parentUsed.addChild(found);
            }
            current = found;
        }
        return current;
    }

    private IBaseDirectory getBaseDirectory() {
        return this.getParent(IBaseDirectory.class, new Class[0]);
    }

    @Override
    public String getIdentifyingPath() {
        IBaseDirectory baseDirectory = this.getBaseDirectory();
        if (baseDirectory != null && baseDirectory.contributesToIdentifyingPath()) {
            return baseDirectory.getNamedElement().getName() + "/" + this.getName();
        }
        return this.getName();
    }

    @Override
    public String getRelativeDirectoryPath() {
        return "./" + this.getName();
    }

    @Override
    public TFile getFile() {
        String path = "./" + this.getName();
        IBaseDirectory baseDirectory = this.getBaseDirectory();
        if (baseDirectory != null) {
            return new TFile((File)baseDirectory.getDirectoryFile(), path).getNormalizedAbsoluteFile();
        }
        return new TFile(path);
    }

    @Override
    public String getAbsolutePath() {
        return this.getFile().getNormalizedAbsolutePath();
    }

    @Override
    public final String getImageResourceName() {
        if (this.isPart()) {
            return DIRECTORY_FRAGMENT_PART;
        }
        return DIRECTORY_FRAGMENT;
    }

    @Override
    public final String getImageResource() {
        return DIRECTORY_FRAGMENT;
    }

    @Override
    public final String getImageResourcePart() {
        return DIRECTORY_FRAGMENT_PART;
    }

    @Override
    public final String getSeparator() {
        return "/";
    }

    @Override
    public final String getPresentationKind() {
        return "Directory";
    }

    @Override
    public boolean ignoreInModelRepresentation() {
        return false;
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitDirectoryFragment(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IDirectoryFragmentCreator {
        public static final /* synthetic */ boolean $assertionsDisabled;

        public DirectoryFragment create(IModelServiceProvider var1, NamedElement var2, String var3);

        default public boolean accept(DirectoryFragment found) {
            assert (found != null) : "Parameter 'found' of method 'accept' must not be null";
            return true;
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitDirectoryFragment(DirectoryFragment var1);
    }
}

