/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.metrics;

import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.foundation.persistence.IObjectReader;
import com.hello2morrow.sonargraph.foundation.persistence.IObjectWriter;
import com.hello2morrow.sonargraph.foundation.persistence.IPersistable;
import com.hello2morrow.sonargraph.foundation.persistence.RestoreException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetricValue
extends NamedElement
implements IMetricValue {
    private static final String ELEMENT = "element";
    private static final String METRIC_DESCRIPTOR = "metricDescriptor";
    private static final String VALUE = "value";
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricValue.class);
    private NamedElement m_element;
    private Number m_value;
    private IMetricDescriptor m_metricDescriptor;

    public MetricValue(NamedElement parent) {
        super(parent);
    }

    @Override
    public void writeAttributes(IObjectWriter writer) throws IOException {
        super.writeAttributes(writer);
        writer.writeObjectReference(ELEMENT, (IPersistable)this.m_element);
        writer.writeOther(METRIC_DESCRIPTOR, (Object)this.m_metricDescriptor);
        if (this.m_metricDescriptor.isFloat()) {
            writer.writeFloat(VALUE, this.m_value.floatValue());
        } else {
            writer.writeInt(VALUE, this.m_value.intValue());
        }
    }

    @Override
    public void readAttributes(IObjectReader reader) throws IOException, RestoreException {
        super.readAttributes(reader);
        reader.readObjectReference(ELEMENT, NamedElement.class, e -> {
            NamedElement namedElement = this.m_element = e;
        });
        reader.readOther(METRIC_DESCRIPTOR, IMetricDescriptor.class, o -> {
            IMetricDescriptor iMetricDescriptor = this.m_metricDescriptor = o;
        });
        if (this.m_metricDescriptor.isFloat()) {
            this.m_value = reader.readFloat(VALUE);
            MetricValue.isNumberValid(this.m_value, this.m_metricDescriptor);
        } else {
            this.m_value = reader.readInt(VALUE);
        }
    }

    private static boolean isNumberValid(Number number, IMetricDescriptor metricDescriptor) {
        assert (number != null) : "Parameter 'number' of method 'isNumberValid' must not be null";
        assert (metricDescriptor != null) : "Parameter 'metricDescriptor' of method 'isNumberValid' must not be null";
        if (number instanceof Float && (((Float)number).isNaN() || ((Float)number).isInfinite())) {
            LOGGER.error("Not a valid float metric for '" + String.valueOf(metricDescriptor.getMetricId()) + ":" + String.valueOf(metricDescriptor.getLevel()) + "'");
            return false;
        }
        return true;
    }

    public MetricValue(NamedElement parent, NamedElement element, Number value, IMetricDescriptor metricDescriptor) {
        super(parent);
        assert (element != null) : "Parameter 'element' of method 'MetricValue' must not be null";
        assert (value != null) : "Parameter 'value' of method 'MetricValue' must not be null";
        assert (metricDescriptor != null) : "Parameter 'metricDescriptor' of method 'MetricValue' must not be null";
        this.m_element = element;
        this.m_value = value;
        this.m_metricDescriptor = metricDescriptor;
        MetricValue.isNumberValid(value, metricDescriptor);
    }

    @Override
    public boolean isValid() {
        if (this.m_value == null) {
            return false;
        }
        if (this.m_metricDescriptor == null) {
            return false;
        }
        if (!MetricValue.isNumberValid(this.m_value, this.m_metricDescriptor)) {
            return false;
        }
        if (!this.m_element.isValid()) {
            return false;
        }
        return super.isValid();
    }

    @Override
    public String getDescription() {
        return this.m_metricDescriptor.getDescription();
    }

    @Override
    public String getFullyQualifiedNamePart() {
        return String.valueOf(this.m_metricDescriptor.getMetricId()) + INNER_NAME_PARTS_SEPARATOR + String.valueOf(this.m_metricDescriptor.getLevel()) + INNER_NAME_PARTS_SEPARATOR + this.m_element.getFullyQualifiedName();
    }

    @Override
    public NamedElement getAssociatedElement() {
        return this.m_element;
    }

    @Override
    public Number getValue() {
        return this.m_value;
    }

    @Override
    public IMetricDescriptor getMetricDescriptor() {
        return this.m_metricDescriptor;
    }

    @Override
    public NamedElement getElement() {
        return this.m_element;
    }

    @Override
    public String getShortName() {
        return this.m_metricDescriptor.getShortName();
    }

    @Override
    public String getDebugInfo() {
        StringBuilder builder = new StringBuilder(super.getDebugInfo());
        builder.append("\n").append("Element: ").append(this.m_element.getFullyQualifiedName());
        builder.append("\n").append("Metric descriptor: ").append(this.m_metricDescriptor.getPresentationName());
        builder.append("\n").append("Value: ").append(this.m_value);
        return builder.toString();
    }
}

